/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pesquisaefetuada;

import com.touchcomp.basementor.model.vo.PesquisaEfetuada;
import com.touchcomp.basementor.model.vo.QuestaoPesquisaEfetuada;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidPesquisaEfetuada
extends ValidGenericEntitiesImpl<PesquisaEfetuada> {
    @Override
    protected void isValid(PesquisaEfetuada vo) {
        this.valid(this.code("V.ERP.1005.001", "edicaoPesquisa"), vo.getEdicaoPesquisa());
        this.valid(this.code("V.ERP.1005.002", "pessoa"), vo.getPessoa());
        this.valid(this.code("V.ERP.1005.003", "pessoaEmpresa"), vo.getPessoaEmpresa());
        if (this.valid(this.code("V.ERP.1005.004", "questoesPesquisa"), (Object)vo.getQuestoesPesquisa())) {
            this.validQuestoesPesquisa(vo);
        }
    }

    private void validQuestoesPesquisa(PesquisaEfetuada vo) {
        for (QuestaoPesquisaEfetuada q : vo.getQuestoesPesquisa()) {
            this.validarQuestao(q, vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "Realizacao Pesquisa";
    }

    private void validarQuestao(QuestaoPesquisaEfetuada q, PesquisaEfetuada vo) {
        String tpVlr;
        if (!this.valid(this.code("V.ERP.1005.005", "questaoPesquisa"), q.getQuestaoPesquisa())) {
            return;
        }
        if (vo.getDataPesquisa() == null) {
            return;
        }
        if (!this.valid(this.code("V.ERP.1005.006", "valor", q.getQuestaoPesquisa()), q.getValor())) {
            return;
        }
        if (TMethods.isWithData((Collection)q.getQuestaoPesquisa().getValoresPadroes())) {
            this.valid(this.code("V.ERP.1005.007", "questaoPesquisaVlrPadrao", q.getQuestaoPesquisa()), q.getQuestaoPesquisaVlrPadrao());
        }
        if ((tpVlr = q.getQuestaoPesquisa().getTipoItem().getClazz()).endsWith(Double.class.getSimpleName()) || tpVlr.endsWith(Float.class.getSimpleName()) || tpVlr.endsWith(Long.class.getSimpleName()) || tpVlr.endsWith(Integer.class.getSimpleName()) || tpVlr.endsWith(Short.class.getSimpleName())) {
            String vlrStr = TString.onlyNumbers((String)q.getValor());
            if (this.valid(this.code("V.ERP.1005.008", "valor", q.getQuestaoPesquisa()), vlrStr)) {
                Double vlr = Double.valueOf(vlrStr);
                this.validMinMax(this.code("V.ERP.1005.009", "valor", q.getQuestaoPesquisa(), q.getQuestaoPesquisa().getNotaMinima(), q.getQuestaoPesquisa().getNotaMaxima()), vlr, q.getQuestaoPesquisa().getNotaMinima(), q.getQuestaoPesquisa().getNotaMaxima());
            }
        }
    }
}

