/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.planoconta;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidPlanoConta
extends ValidGenericEntitiesImpl<PlanoConta> {
    @Override
    protected void isValid(PlanoConta vo) {
        this.valid(this.code("V.ERP.0160.001", "tipoConta"), vo.getMarca());
        this.valid(this.code("V.ERP.0160.002", "dataCadastro"), vo.getDataCadastro());
        this.valid(this.code("V.ERP.0160.004", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0160.005", "grupoConta"), vo.getCodigo());
        this.valid(this.code("V.ERP.0160.006", "naturezaOperacao"), vo.getNaturezaOperacaoPC());
    }

    @Override
    public String getSimpleName() {
        return "Plano Conta";
    }

    public static boolean isAnalitica(PlanoConta pc) {
        if (pc == null) {
            return false;
        }
        return ToolMethods.isEquals((Object)pc.getMarca(), (Object)EnumConstSinteticoAnalitico.ANALITICO.getValueInt());
    }

    public static boolean isNivel4(PlanoConta pc) {
        return ValidPlanoConta.isNivel4(pc.getCodigo());
    }

    public static boolean isNivel4(String codigo) {
        if (ValidPlanoConta.isNivel1(codigo)) {
            return false;
        }
        if (ValidPlanoConta.isNivel2(codigo)) {
            return false;
        }
        if (ValidPlanoConta.isNivel3(codigo)) {
            return false;
        }
        return codigo.endsWith("00000");
    }

    public static boolean isNivel3(PlanoConta pc) {
        return ValidPlanoConta.isNivel3(pc.getCodigo());
    }

    public static boolean isNivel3(String codigo) {
        if (ValidPlanoConta.isNivel1(codigo)) {
            return false;
        }
        if (ValidPlanoConta.isNivel2(codigo)) {
            return false;
        }
        return codigo.endsWith("0000000");
    }

    public static boolean isNivel2(PlanoConta pc) {
        return ValidPlanoConta.isNivel2(pc.getCodigo());
    }

    public static boolean isNivel2(String codigo) {
        if (ValidPlanoConta.isNivel1(codigo)) {
            return false;
        }
        return codigo.endsWith("00000000");
    }

    public static boolean isNivel1(PlanoConta pc) {
        return ValidPlanoConta.isNivel1(pc.getCodigo());
    }

    public static boolean isNivel1(String codigo) {
        return codigo.endsWith("000000000");
    }
}

