/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.precadastrocolaborador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.PreCadastroColaborador;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import org.springframework.stereotype.Component;

@Component
public class ValidPreCadastroColaborador
extends ValidGenericEntitiesImpl<PreCadastroColaborador> {
    @Override
    protected void isValid(PreCadastroColaborador vo) {
        this.valid(this.code("V.ERP.1305.001", "nome"), vo.getNome());
        if (this.isEquals(vo.getPossuiValeTransporte(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid0(this.code("V.ERP.1305.002", "valorPassagem"), vo.getValorPassagem());
        } else {
            this.valid0(this.code("V.ERP.1305.003", "qtdadeValeTransporte"), vo.getQtdadeValeTransporte());
        }
        if (this.isEquals(vo.getPossuiDoenca(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1305.004", "doenca"), vo.getDoenca());
        }
        if (!ValidadeCPFCNPJ.isValid(vo.getCpf())) {
            this.addWarn(this.code("V.ERP.1305.005", "cnpj", vo.getCpf()), vo.getCpf());
        }
        if (!ValidadeCPFCNPJ.isValid(vo.getCpfConjugue())) {
            this.addWarn(this.code("V.ERP.1305.006", "cnpj", vo.getCpfConjugue()), vo.getCpfConjugue());
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

