/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.produto;

import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstConfereciaNFTerceiros;
import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofinsNatReceita;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.barcode.ValidateBarcode;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidProduto
extends ValidGenericEntitiesImpl<Produto> {
    @Override
    protected void isValid(Produto vo) {
        this.valid(this.code("V.ERP.0065.001", "nome"), vo.getNome());
        this.valid(this.code("V.ERP.0065.002", "unidadeMedida"), vo.getUnidadeMedida());
        if (this.valid(this.code("V.ERP.0065.003", "itemUnidadeMedida"), (Object)vo.getItemUnidadeMedida())) {
            this.validarItemUnidadeMedida(vo);
        }
        this.valid(this.code("V.ERP.0065.004", "especie"), vo.getEspecie());
        this.valid(this.code("V.ERP.0065.005", "subEspecie"), vo.getSubEspecie());
        this.valid(this.code("V.ERP.0065.006", "fabricante"), vo.getFabricante());
        this.valid(this.code("V.ERP.0065.007", "planoConta"), vo.getPlanoConta());
        this.valid(this.code("V.ERP.0065.008", "planoContaGerencial"), vo.getPlanoContaGerencial());
        this.valid(this.code("V.ERP.0065.009", "entradaSaida"), vo.getEntradaSaida());
        if (!(!this.valid(this.code("V.ERP.0065.010", "tipoIemSped"), vo.getTipoIemSped()) || vo.getGenero() == null || vo.getTipoIemSped() == null || vo.getTipoIemSped().getCodigo().equals("07") || vo.getTipoIemSped().getCodigo().equals("08") || vo.getTipoIemSped().getCodigo().equals("09") || vo.getTipoIemSped().getCodigo().equals("10") || vo.getTipoIemSped().getCodigo().equals("99") || vo.getGenero().getCodigo().equals("00"))) {
            this.valid(this.code("V.ERP.0065.011", "ncm"), vo.getNcm());
        }
        this.validarNCM(vo);
        this.valid(this.code("V.ERP.0065.012", "genero"), vo.getGenero());
        this.valid(this.code("V.ERP.0065.013", "localizacao"), vo.getLocalizacao());
        if (this.valid(this.code("V.ERP.0065.014", "qtdMin"), vo.getQtdMin()) && this.valid(this.code("V.ERP.0065.015", "qtdMax"), vo.getQtdMax()) && vo.getQtdMax() < vo.getQtdMin()) {
            this.addError(this.code("V.ERP.0065.016", "qtdMax"), vo.getQtdMax());
        }
        if (this.valid(this.code("V.ERP.0065.017", "qtdMinVenda"), vo.getQtdMinVenda()) && this.valid(this.code("V.ERP.0065.018", "qtdMaxVenda"), vo.getQtdMaxVenda()) && vo.getQtdMaxVenda() < vo.getQtdMinVenda()) {
            this.addError(this.code("V.ERP.0065.019", "qtdMaxVenda"), vo.getQtdMaxVenda());
        }
        if (this.getSharedObjects() != null && this.getSharedObjects().getOpcoesVendas(vo.getEmpresa()) != null && TMethods.isAffirmative((Number)this.getSharedObjects().getOpcoesVendas(vo.getEmpresa()).getUsarClassificacaoProdutos())) {
            this.valid(this.code("V.ERP.0065.020", "classificacaoProdutos"), vo.getClassificacaoProdutos());
        }
        if (this.valid(this.code("V.ERP.0065.021", "codigoBarras"), (Object)vo.getCodigoBarras())) {
            this.validarCodigoBarras(vo);
        }
        if (this.getSharedObjects() != null && this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()) != null && this.isEquals(this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()).getConferirNFTerceiros(), EnumConstConfereciaNFTerceiros.CONFERIR.getValue()) && this.isEquals(this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa()).getTipoConfNFTerceirosItens(), EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            this.valid(this.code("V.ERP.0065.022", "tipoConfNFTerceirosProduto"), vo.getTipoConfNFTerceirosProduto());
        }
        if (this.valid(this.code("V.ERP.0065.026", "tipoProduto"), vo.getTipoProduto()) && this.isEquals(vo.getTipoProduto(), (short)1) && this.isEquals(vo.getEntradaSaida(), (short)1)) {
            this.validLenght(this.code("V.ERP.0065.027", "codigoServico"), vo.getCodigoServico(), 3, new Object[0]);
        }
        if (this.valid(this.code("V.ERP.0065.028", "pisCofinsTributadoQuantidade"), vo.getPisCofinsTributadoQuantidade()) && this.isAffirmative(vo.getPisCofinsTributadoQuantidade())) {
            this.validGreather0(this.code("V.ERP.0065.029", "aliquotaPisQtde"), vo.getAliquotaPisQtde());
            this.validGreather0(this.code("V.ERP.0065.030", "aliquotaCofinsQtde"), vo.getAliquotaCofinsQtde());
        }
        if (vo.getCodBeneficioFiscal() != null && vo.getCodBeneficioFiscal().trim().length() > 0 && vo.getCodBeneficioFiscal().trim().length() != 10) {
            this.addError(this.code("V.ERP.0065.031", "codBeneficioFiscal"), vo);
        }
        if (vo.getCodAnvisa() != null && vo.getCodAnvisa().trim().length() > 0 && vo.getCodAnvisa().trim().length() != 13 && vo.getCodAnvisa().trim().length() != 11 && !vo.getCodAnvisa().trim().equalsIgnoreCase("ISENTO")) {
            this.addError(this.code("V.ERP.0065.032", "codAnvisa"), vo.getCodAnvisa());
        }
        if (vo.getCodAnvisa() != null && vo.getCodAnvisa().trim().length() > 0 && vo.getCodAnvisa().equalsIgnoreCase("ISENTO")) {
            this.validLenght(this.code("V.ERP.0065.033", "motivoIsencaoAnvisa"), vo.getMotivoIsencaoAnvisa(), 1, new Object[0]);
        }
        if (vo.getCodigoFCI() != null && !vo.getCodigoFCI().isEmpty() && vo.getCodigoFCI().trim().length() != 36) {
            this.addError(this.code("V.ERP.0065.034", "codigoFCI"), vo.getCodigoFCI());
        }
        if (this.valid(this.code("V.ERP.0065.035", "produtosKit"), vo.getUtilizarProdutoKit()) && this.isAffirmative(vo.getUtilizarProdutoKit())) {
            this.validNotEmpty(this.code("V.ERP.0065.036", "produtosKit"), vo.getProdutosKit());
        }
        if (this.valid(this.code("V.ERP.0065.037", "naturezasReceita"), (Object)vo.getNaturezasReceita())) {
            this.validNaturezasReceitaPisCofins(vo);
        }
        if (this.valid(this.code("V.ERP.0065.038", "aliquotasUF"), (Object)vo.getAliquotasUF())) {
            this.validAliquotasUF(vo);
        }
        this.valid(this.code("V.ERP.0065.050", "aliqImpEstimadaEst"), vo.getAliqImpEstimadaEst());
        this.valid(this.code("V.ERP.0065.051", "aliqImpEstimadaFed"), vo.getAliqImpEstimadaFed());
        this.valid(this.code("V.ERP.0065.052", "aliqImpEstimadaMun"), vo.getAliqImpEstimadaMun());
        this.valid(this.code("V.ERP.0065.053", "aliquotaCide"), vo.getAliquotaCide());
        this.valid(this.code("V.ERP.0065.054", "aliquotaCofins"), vo.getAliquotaCofins());
        this.valid(this.code("V.ERP.0065.055", "aliquotaCofinsQtde"), vo.getAliquotaCofinsQtde());
        this.valid(this.code("V.ERP.0065.056", "aliquotaCofinsSt"), vo.getAliquotaCofinsSt());
        this.valid(this.code("V.ERP.0065.057", "aliquotaContSoc"), vo.getAliquotaContSoc());
        this.valid(this.code("V.ERP.0065.058", "aliquotaFunrural"), vo.getAliquotaFunrural());
        this.valid(this.code("V.ERP.0065.059", "aliquotaIcms"), vo.getAliquotaIcms());
        this.valid(this.code("V.ERP.0065.060", "aliquotaImportacao"), vo.getAliquotaImportacao());
        this.valid(this.code("V.ERP.0065.061", "aliquotaInss"), vo.getAliquotaInss());
        this.valid(this.code("V.ERP.0065.062", "aliquotaIpi"), vo.getAliquotaIpi());
        this.valid(this.code("V.ERP.0065.063", "aliquotaIrrf"), vo.getAliquotaIrrf());
        this.valid(this.code("V.ERP.0065.064", "aliquotaIss"), vo.getAliquotaIss());
        this.valid(this.code("V.ERP.0065.065", "aliquotaLei10833"), vo.getAliquotaLei10833());
        this.valid(this.code("V.ERP.0065.066", "aliquotaOutros"), vo.getAliquotaOutros());
        this.valid(this.code("V.ERP.0065.067", "aliquotaPis"), vo.getAliquotaPis());
        this.valid(this.code("V.ERP.0065.068", "aliquotaPisQtde"), vo.getAliquotaPisQtde());
        this.valid(this.code("V.ERP.0065.069", "aliquotaPisSt"), vo.getAliquotaPisSt());
        this.valid(this.code("V.ERP.0065.070", "aliquotaRat"), vo.getAliquotaRat());
        this.valid(this.code("V.ERP.0065.071", "aliquotaSenar"), vo.getAliquotaSenar());
        this.valid(this.code("V.ERP.0065.072", "altura"), vo.getAltura());
        this.valid(this.code("V.ERP.0065.073", "ativo"), vo.getAtivo());
        this.valid(this.code("V.ERP.0065.074", "comprimento"), vo.getComprimento());
        this.valid(this.code("V.ERP.0065.075", "densidade"), vo.getDensidade());
        this.valid(this.code("V.ERP.0065.076", "diametro"), vo.getDiametro());
        this.valid(this.code("V.ERP.0065.077", "espessura"), vo.getEspessura());
        this.valid(this.code("V.ERP.0065.078", "fatorTaxaSanidadeAnimal"), vo.getFatorTaxaSanidadeAnimal());
        this.valid(this.code("V.ERP.0065.079", "largura"), vo.getLargura());
        this.valid(this.code("V.ERP.0065.080", "percGLP"), vo.getPercGLP());
        this.valid(this.code("V.ERP.0065.081", "percGNI"), vo.getPercGNI());
        this.valid(this.code("V.ERP.0065.082", "percGNN"), vo.getPercGNN());
        this.valid(this.code("V.ERP.0065.083", "percRedBCINSS"), vo.getPercRedBCINSS());
        this.valid(this.code("V.ERP.0065.084", "percRedContSoc"), vo.getPercRedContSoc());
        this.valid(this.code("V.ERP.0065.085", "percRedFunrural"), vo.getPercRedFunrural());
        this.valid(this.code("V.ERP.0065.086", "percRedIrrf"), vo.getPercRedIrrf());
        this.valid(this.code("V.ERP.0065.087", "percRedLei10833"), vo.getPercRedLei10833());
        this.valid(this.code("V.ERP.0065.088", "percRedOutros"), vo.getPercRedOutros());
        this.valid(this.code("V.ERP.0065.089", "percRedSestSenat"), vo.getPercRedSestSenat());
        this.valid(this.code("V.ERP.0065.090", "percSestSenat"), vo.getPercSestSenat());
        this.valid(this.code("V.ERP.0065.091", "percentualDiferimento"), vo.getPercentualDiferimento());
        this.valid(this.code("V.ERP.0065.092", "pesoEmbalagem"), vo.getPesoEmbalagem());
        this.valid(this.code("V.ERP.0065.093", "pesoUnitario"), vo.getPesoUnitario());
        this.valid(this.code("V.ERP.0065.094", "pontoRessupEstoque"), vo.getPontoRessupEstoque());
        this.valid(this.code("V.ERP.0065.095", "qtdVolume"), vo.getQtdVolume());
        this.valid(this.code("V.ERP.0065.096", "taxaSanidadeAnimal"), vo.getTaxaSanidadeAnimal());
        this.valid(this.code("V.ERP.0065.097", "valorMaximoConsumo"), vo.getValorMaximoConsumo());
        this.valid(this.code("V.ERP.0065.098", "valorTabICMS"), vo.getValorTabICMS());
        this.valid(this.code("V.ERP.0065.099", "valorTabICMSST"), vo.getValorTabICMSST());
        this.valid(this.code("V.ERP.0065.100", "volume"), vo.getVolume());
        this.valid(this.code("V.ERP.0065.106", "statusLoteFabricacao"), vo.getStatusLoteFabricacao());
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarItemUnidadeMedida(Produto vo) {
        int qtdUnidadeConversao = 0;
        for (ItemUnidadeMedida item : vo.getItemUnidadeMedida()) {
            this.valid(this.code("V.ERP.0065.039", "unidadeMedida"), item.getUnidadeMedida());
            this.validGreather0(this.code("V.ERP.0065.040", "fatorConversao"), item.getFatorConversao());
            this.valid(this.code("V.ERP.0065.041", "utilizarConversaoSaida"), item.getUtilizarConversaoSaida());
            if (!this.valid(this.code("V.ERP.0065.024", "utilizarConversaoSaida"), item.getUtilizarConversaoSaida()) || !this.isEquals(item.getUtilizarConversaoSaida(), (short)1)) continue;
            ++qtdUnidadeConversao;
        }
        if (qtdUnidadeConversao > 1) {
            this.addError(this.code("V.ERP.0065.025", "fatorConversao"), vo);
        }
    }

    private void validarCodigoBarras(Produto vo) {
        boolean jaExiste = false;
        boolean jaExisteTrib = false;
        for (CodigoBarras codBarras : vo.getCodigoBarras()) {
            this.valid(this.code("V.ERP.0065.042", "codigoBarras"), codBarras.getCodigoBarras());
            this.valid(this.code("V.ERP.0065.043", "usarComoCodPrincTrib"), codBarras.getUsarComoCodPrincTrib());
            this.valid(this.code("V.ERP.0065.044", "usarComoCodigoPrinc"), codBarras.getUsarComoCodigoPrinc());
            if (this.isEquals(codBarras.getUsarComoCodigoPrinc(), (short)1)) {
                if (jaExiste) {
                    this.addError(this.code("V.ERP.0065.101", "codigoFCI"), codBarras.getUsarComoCodigoPrinc());
                }
                jaExiste = true;
            }
            if (this.isEquals(codBarras.getUsarComoCodPrincTrib(), (short)1)) {
                if (jaExisteTrib) {
                    this.addError(this.code("V.ERP.0065.102", "codigoFCI"), codBarras.getUsarComoCodPrincTrib());
                }
                jaExisteTrib = true;
            }
            int length = codBarras.getCodigoBarras().length();
            if (!this.isEquals(codBarras.getUsarComoCodPrincTrib(), (short)1) && !this.isEquals(codBarras.getUsarComoCodigoPrinc(), (short)1)) continue;
            if (length != 0 && length != 8 && length != 12 && length != 13 && length != 14) {
                this.addError(this.code("V.ERP.0065.103", "codigoBarras", codBarras.getCodigoBarras()), codBarras.getCodigoBarras());
            }
            if (length != 12 && length != 13 || ValidateBarcode.valEan13(codBarras.getCodigoBarras())) continue;
            this.addError(this.code("V.ERP.0065.104", "codigoBarras", codBarras.getCodigoBarras()), codBarras.getCodigoBarras());
        }
    }

    private void validNaturezasReceitaPisCofins(Produto vo) {
        for (ParamReceitaPisCofinsNatReceita natRec : vo.getNaturezasReceita()) {
            this.valid(this.code("V.ERP.0065.045", "naturezaReceitaPisCofins"), natRec.getNaturezaReceitaPisCofins());
        }
    }

    private void validAliquotasUF(Produto vo) {
        for (ProdutoAliquotaUF pp : vo.getAliquotasUF()) {
            this.validGreather0(this.code("V.ERP.0065.046", "aliquotaIcms"), pp.getAliquotaIcms());
        }
    }

    private void validarNCM(Produto vo) {
        if (vo.getEmpresa() == null) {
            return;
        }
        EmpresaDados ed = vo.getEmpresa().getEmpresaDados();
        Date dataAtual = TDate.dataSemHora((Date)new Date());
        if (this.isEquals(ed.getPermitirAlterarNCM(), (short)1) && vo.getNcm() != null && vo.getNcm().getDataFinal() != null && dataAtual.after(vo.getNcm().getDataFinal())) {
            this.addError(this.code("V.ERP.0065.047", "ncm"), vo);
        }
        if (this.isEquals(ed.getBloquearProdutoSemNcm(), (short)1)) {
            this.valid(this.code("V.ERP.0065.048", "ncm"), vo.getNcm());
        }
    }
}

