/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.relpessoacontato;

import com.touchcomp.basementor.constants.enums.motivoreagendamento.EnumConstMotivoReagendamentoTP;
import com.touchcomp.basementor.constants.enums.procedenciasolicitacao.EnumProcedenciaSolicitacao;
import com.touchcomp.basementor.constants.enums.touch.EnumConstTipoHoraRelTouch;
import com.touchcomp.basementor.model.vo.AvaAnalistaRelPessoaContato;
import com.touchcomp.basementor.model.vo.FichaTecRelPessoaContato;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoContatoGrupoUsuario;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoCheckList;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.RelPessoaContatoPrev;
import com.touchcomp.basementor.model.vo.RelPessoaContatoReabert;
import com.touchcomp.basementor.model.vo.RelPessoaContatoTreinamento;
import com.touchcomp.basementor.model.vo.RelPessoaContatoVenda;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.map.ToolMap;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.relpessoacontato.ValidRelPessoaContatoFichaTecnica;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidRelPessoaContato
extends ValidGenericEntitiesImpl<RelPessoaContato> {
    @Autowired
    ValidRelPessoaContatoFichaTecnica validRelPessoaContatoFichaTecnica;

    @Override
    protected void isValid(RelPessoaContato vo) {
        EnumProcedenciaSolicitacao canal;
        this.valid(this.code("V.ERP.0694.001", "versaoAtual", vo), vo.getVersaoAtual());
        this.valid(this.code("V.ERP.0694.002", "tipoBdVersao", vo), vo.getTipoBdVersao());
        this.valid(this.code("V.ERP.0694.003", "clienteContSistemas", vo), vo.getClienteContSistemas());
        this.valid(this.code("V.ERP.0694.004", "usuarioCliContSistemas", vo), vo.getUsuarioCliContSistemas());
        this.valid(this.code("V.ERP.0694.005", "usuarioResponsavel", vo), vo.getUsuarioResponsavel());
        this.valid(this.code("V.ERP.0694.006", "tipoAtendimento", vo), vo.getTipoAtendimento());
        this.valid(this.code("V.ERP.0694.007", "prioridadeAtendimento", vo), vo.getPrioridadeAtendimento());
        this.valid(this.code("V.ERP.0694.008", "setorUsuario", vo), vo.getSetorUsuario());
        this.validMinLenght(this.code("V.ERP.0694.009", "assunto", vo), vo.getAssunto(), 30);
        this.validMaxLenght(this.code("V.ERP.0694.010", "assunto", vo), vo.getAssunto(), 20000);
        if (vo.getProcedenciaSolicitacaoContato() != null && this.isEquals(vo.getProcedenciaSolicitacaoContato().getProcedenciaTarifada(), (short)1) && !TMethods.isWithData((Collection)vo.getVendasVinculadas())) {
            this.addError(this.code("V.ERP.0694.023", vo), vo);
        }
        if (vo.getProcedenciaSolicitacaoContato() != null && !TMethods.isAffirmative((Number)vo.getProcedenciaSolicitacaoContato().getSugestao())) {
            this.valid(this.code("V.ERP.0694.012", "dataPrevFinalizacaoInterna", vo), vo.getDataPrevFinalizacaoInterna());
            if (this.valid(this.code("V.ERP.0694.017", "dataPrevFinalizacao", vo), vo.getDataPrevFinalizacao())) {
                if (vo.getDataPrevFinalizacao().before(new Date()) && !this.isAffirmative(vo.getFinalizado())) {
                    this.addError(this.code("V.ERP.0694.018", vo), vo.getDataPrevFinalizacao());
                }
                if (vo.getDataPrevFinalizacaoInterna().before(new Date()) && !this.isAffirmative(vo.getFinalizado())) {
                    this.addError(this.code("V.ERP.0694.018", vo), vo.getDataPrevFinalizacaoInterna());
                }
                Date dataLimite = ToolDate.nextDays((Date)new Date(), (int)360);
                if (vo.getDataPrevFinalizacao().after(dataLimite)) {
                    this.addError(this.code("V.ERP.0694.081", vo), vo.getDataPrevFinalizacaoInterna());
                }
                if (vo.getDataPrevFinalizacaoInterna().after(vo.getDataPrevFinalizacao())) {
                    this.addError(this.code("V.ERP.0694.082", vo), vo.getDataPrevFinalizacaoInterna());
                }
            }
        }
        if (vo.getNotaAtendimento() != null && this.isEquals(vo.getNotaAtendimento().getFlagTratativaNota(), (short)1)) {
            this.valid(this.code("V.ERP.0694.013", "tratativaNota", vo), vo.getNotaAtendimento().getTratativaNota());
        }
        if (this.valid(this.code("V.ERP.0694.014", "canalAtendimento", vo), vo.getCanalAtendimento()) && this.isEquals(EnumProcedenciaSolicitacao.ATENDIMENTO_WHATS, canal = EnumProcedenciaSolicitacao.get((Object)vo.getCanalAtendimento().getIdentificador()))) {
            this.valid(this.code("V.ERP.0694.015", "numeroProtocoloWhats", vo), vo.getNumeroProtocoloWhats());
        }
        if (this.valid(this.code("V.ERP.0694.016", "procedenciaSolicitacaoContato", vo), vo.getProcedenciaSolicitacaoContato())) {
            this.validarTiposProcedencia(vo);
        }
        if (this.isAffirmative(vo.getFinalizado())) {
            EnumProcedenciaSolicitacao procedencia;
            this.valid(this.code("V.ERP.0694.019", "dataFinalizacao", vo), vo.getDataFinalizacao());
            this.validBeforeEqual(this.code("V.ERP.0694.073", "dataFinalizacao", vo), vo.getDataFinalizacao(), new Date(), new Object[0]);
            this.validMinLenght(this.code("V.ERP.0694.020", "assunto", vo), vo.getSolucao(), 30);
            this.validMaxLenght(this.code("V.ERP.0694.021", "assunto", vo), vo.getSolucao(), 20000);
            if (vo.getTempoTotal() < ToolDate.difBetweenDatesInHoursNumber((Date)vo.getDataRelacionamento(), (Date)vo.getDataFinalizacao())) {
                this.addError(this.code("V.ERP.0694.024", vo), vo.getDataPrevFinalizacao());
            }
            if (this.isEquals(procedencia = EnumProcedenciaSolicitacao.get((Object)vo.getProcedenciaSolicitacaoContato().getTipoProcedencia()), EnumProcedenciaSolicitacao.IMPLEMENTACAO)) {
                this.validarAnalise(vo);
            }
            if (this.isEquals(procedencia, EnumProcedenciaSolicitacao.VISITA_TECNICA)) {
                this.validWarn(this.code("V.ERP.0694.022", "reembolsos", vo), (Collection)vo.getReembolsoContSistemas());
            }
            if (this.isEquals(vo.getProcedenciaSolicitacaoContato().getProcedenciaTarifada(), (short)1) && (vo.getAvaAnalistaRel() == null || vo.getAvaAnalistaRel() != null && vo.getAvaAnalistaRel().getTarifar() == 1)) {
                Optional<RelPessoaContatoVenda> found;
                if (this.valid(this.code("V.ERP.0694.023", "vendaServicosTouch", vo), (Object)vo.getVendasVinculadas()) && (found = vo.getVendasVinculadas().stream().filter(i -> TMethods.isEquals((Object)vo.getClienteContSistemas(), (Object)i.getVendaServicosTouch().getClienteContSistemas())).findFirst()).isPresent()) {
                    this.addError(this.code("V.ERP.0694.024", vo), vo.getDataPrevFinalizacao());
                }
                if (!this.isEquals(procedencia, EnumProcedenciaSolicitacao.PROVA_AVALIACAO) && this.valid(this.code("V.ERP.0694.025", "pesquisaEfetuada", vo), vo.getPesquisaEfetuada()) && !vo.getPesquisaEfetuada().getUsuario().equals((Object)vo.getUsuarioFinalizacao())) {
                    this.addError(this.code("V.ERP.0694.026", vo), vo.getDataPrevFinalizacao());
                }
            }
            if (!this.isEquals(vo.getProcedenciaSolicitacaoContato().getProcedenciaTarifada(), (short)1) && TMethods.isWithData((Collection)vo.getVendasVinculadas())) {
                this.addError(this.code("V.ERP.0694.027", vo), vo.getDataPrevFinalizacao());
            }
            if (this.isEquals(vo.getAtendListagemVersao(), (short)1) && !ToolMethods.isStrWithData((String)vo.getDescricaoTecnica())) {
                this.addError(this.code("V.ERP.0694.028", vo), vo.getDescricaoTecnica());
            }
        }
        this.validarTreinamentos(vo);
        this.validarEventos(vo);
        this.validarReaberturas(vo);
        this.validarReagendamentos(vo);
        this.validarResponsaveis(vo);
        this.validarTipoAtendimento(vo);
        this.validarCheckList(vo);
        this.validarVendasVinculadas(vo);
        this.validarCheckListTreinamento(vo);
    }

    @Override
    public String getSimpleName() {
        return "1708";
    }

    private void validarAnalise(RelPessoaContato vo) {
        if (this.isAffirmative(vo.getFinalizado()) && this.isEquals(vo.getProcedenciaSolicitacaoContato().getTipoProcedencia(), EnumProcedenciaSolicitacao.IMPLEMENTACAO.getValue())) {
            AvaAnalistaRelPessoaContato ava = vo.getAvaAnalistaRel();
            if (this.valid(this.code("V.ERP.0694.029", "versaoAtual", vo), vo.getAvaAnalistaRel())) {
                this.valid(this.code("V.ERP.0694.030", "versaoAtual", vo), ava.getUsuarioAnalista());
                this.valid(this.code("V.ERP.0694.031", "versaoAtual", vo), ava.getHorasEstimadas());
                if (!this.isAffirmative(ava.getTarifar())) {
                    this.valid(this.code("V.ERP.0694.032", "versaoAtual"), ava.getMotivoNaoTarifar());
                }
            }
        }
    }

    private void validarResponsaveis(RelPessoaContato vo) {
    }

    private void validarEventos(RelPessoaContato vo) {
        if (!this.valid(this.code("V.ERP.0694.033", "vendaServicosTouch", vo), (Object)vo.getAgendamentos())) {
            return;
        }
        boolean todosEventosFinalizados = true;
        for (RelPessoaContatoLog r : vo.getAgendamentos()) {
            this.valid(this.code("V.ERP.0694.035", "vendaServicosTouch", vo), r.getTipoHoraTouch());
            this.valid(this.code("V.ERP.0694.036", "vendaServicosTouch", vo), r.getDataAgendamento());
            this.valid(this.code("V.ERP.0694.037", "vendaServicosTouch", vo), r.getTempoDispendiado());
            if (r.getTempoDispendiado() > 10.0) {
                this.addWarn(this.code("V.ERP.0694.038", vo), vo.getDescricaoTecnica());
            }
            if (r.getTempoDispendiado() > 20.0) {
                this.addError(this.code("V.ERP.0694.039", vo), vo.getDescricaoTecnica());
            }
            if (!TMethods.isStrWithData((String)r.getObservacao()) && !TMethods.isStrWithData((String)r.getObservacaoInterna())) {
                this.addError(this.code("V.ERP.0694.040", vo), r.getObservacaoInterna());
            }
            if (this.isAffirmative(r.getFinalizado())) {
                this.valid(this.code("V.ERP.0694.041", "vendaServicosTouch", vo), r.getDataFinal());
                if (!this.isEquals(r.getTipoHoraTouch().getTipoHora(), EnumConstTipoHoraRelTouch.TIPO_HORA_OUTROS.getValue()) && (r.getTempoDispendiado() == null || r.getTempoDispendiado() <= 0.0) && r.getDataFinal() != null && r.getDataFinal().after(ToolDate.strToDate((String)"15/07/2020"))) {
                    this.addError(this.code("V.ERP.0694.042", vo), vo.getDescricaoTecnica());
                }
            }
            if (this.isAffirmative(r.getFinalizado())) continue;
            todosEventosFinalizados = false;
        }
        if (todosEventosFinalizados && vo.getFinalizado() != 1) {
            this.addError(this.code("V.ERP.0694.043", vo), vo.getDescricaoTecnica());
        }
        if (!todosEventosFinalizados && vo.getFinalizado() == 1) {
            this.addError(this.code("V.ERP.0694.044", vo), vo.getDescricaoTecnica());
        }
    }

    private void validarReaberturas(RelPessoaContato vo) {
        if (vo.getReaberturas() == null) {
            return;
        }
        for (RelPessoaContatoReabert r : vo.getReaberturas()) {
            this.valid(this.code("V.ERP.0694.045", "vendaServicosTouch", vo), r.getMotivoReabertura());
            this.valid(this.code("V.ERP.0694.046", "vendaServicosTouch", vo), r.getSetorUsuario());
            Boolean achou = false;
            for (RelPessoaContatoLog ag : vo.getAgendamentos()) {
                if (!this.isEquals(r.getSetorUsuario(), ag.getUsuarioAgendamento().getSetorUsuario())) continue;
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            this.addError(this.code("V.ERP.0694.047", r.getSetorUsuario(), vo), vo.getDescricaoTecnica());
        }
    }

    private void validarReagendamentos(RelPessoaContato vo) {
        if (vo.getReagendamentos() == null) {
            return;
        }
        HashMap temp = new HashMap();
        for (RelPessoaContatoPrev reagendamento : vo.getReagendamentos()) {
            this.valid(this.code("V.ERP.0694.048", "vendaServicosTouch", vo), reagendamento.getDataPrevista());
            this.valid(this.code("V.ERP.0694.048", "vendaServicosTouch", vo), reagendamento.getDataPrevistaInterna());
            this.valid(this.code("V.ERP.0694.049", "vendaServicosTouch", vo), reagendamento.getSetorUsuario());
            if (!this.isEquals(reagendamento.getMotivo().getTipo(), EnumConstMotivoReagendamentoTP.AGENDAMENTO.getValue())) {
                this.valid(this.code("V.ERP.0694.050", "vendaServicosTouch", vo), reagendamento.getMotivo());
                this.valid(this.code("V.ERP.0694.051", "vendaServicosTouch", vo), reagendamento.getInfoAdicional());
            }
            if (!this.isEquals(reagendamento.getMotivo().getTipo(), EnumConstMotivoReagendamentoTP.AGENDAMENTO.getValue())) continue;
            ToolMap.sumIt(temp, (Object)reagendamento.getSetorUsuario(), (Number)1);
        }
        Optional<Number> found = temp.values().stream().filter(i -> i.doubleValue() > 1.0).findFirst();
        if (found.isPresent()) {
            this.addError(this.code("V.ERP.0694.052", vo), vo.getDescricaoTecnica());
        }
    }

    private void validarTreinamentos(RelPessoaContato vo) {
        if (TMethods.isAffirmative((Number)vo.getFinalizado()) && (TMethods.isEquals((Object)vo.getProcedenciaSolicitacaoContato().getTipoProcedencia(), (Object)EnumProcedenciaSolicitacao.TREINAMENTO.getValue()) || TMethods.isEquals((Object)vo.getProcedenciaSolicitacaoContato().getTipoProcedencia(), (Object)EnumProcedenciaSolicitacao.PROVA_AVALIACAO.getValue())) && !TMethods.isWithData((Collection)vo.getTreinamentos())) {
            this.addError(this.code("V.ERP.0694.053", vo), vo.getDescricaoTecnica());
        }
        for (RelPessoaContatoTreinamento tr : vo.getTreinamentos()) {
            if (TMethods.isEquals((Object)tr.getTreinamento().getUsuario().getClienteContSistemas(), (Object)vo.getClienteContSistemas())) continue;
            this.addError(this.code("V.ERP.0694.054", vo), vo.getDescricaoTecnica());
        }
    }

    private void validarTiposProcedencia(RelPessoaContato vo) {
        EnumProcedenciaSolicitacao procedencia = EnumProcedenciaSolicitacao.get((Object)vo.getProcedenciaSolicitacaoContato().getTipoProcedencia());
        if (this.isAffirmative(vo.getFinalizado()) && this.isEquals(procedencia, EnumProcedenciaSolicitacao.TEMPORARIA)) {
            this.addError(this.code("V.ERP.0694.055", vo), vo.getProcedenciaSolicitacaoContato());
        }
        if (vo.getProjetoTarefa() != null && this.isAffirmative(vo.getProcedenciaSolicitacaoContato().getSugestao())) {
            this.addError(this.code("V.ERP.0694.056", vo), vo.getProcedenciaSolicitacaoContato());
        }
        if (!vo.getVendasVinculadas().isEmpty() && vo.getProcedenciaSolicitacaoContato() != null && TMethods.isAffirmative((Number)vo.getProcedenciaSolicitacaoContato().getSugestao())) {
            this.addError(this.code("V.ERP.0694.079", vo), vo.getProcedenciaSolicitacaoContato());
        }
        if (vo.getProcedenciaSolicitacaoContato() != null && TMethods.isAffirmative((Number)vo.getProcedenciaSolicitacaoContato().getSugestao()) && !TMethods.isAffirmative((Number)vo.getFinalizado())) {
            this.addError(this.code("V.ERP.0694.080", vo), vo.getProcedenciaSolicitacaoContato());
        }
        if (vo.getUsuarioFinalizacao() != null) {
            boolean foundit = false;
            for (ProcedenciaSolicitacaoContatoGrupoUsuario gru : vo.getProcedenciaSolicitacaoContato().getGruposUsuarios()) {
                Optional<UsuarioEmpresa> found = vo.getUsuarioFinalizacao().getUsuarioBasico().getEmpresas().stream().filter(i -> i.getGrupo().equals((Object)gru.getGrupo())).findFirst();
                if (!found.isPresent()) continue;
                foundit = true;
                break;
            }
            if (!foundit) {
                this.addError(this.code("V.ERP.0694.067", vo), vo.getProcedenciaSolicitacaoContato());
            }
        }
        if ((this.isEquals(procedencia, EnumProcedenciaSolicitacao.VISITA_TECNICA) || this.isEquals(procedencia, EnumProcedenciaSolicitacao.TREINAMENTO)) && vo.getNodo() != null) {
            this.addError(this.code("V.ERP.0694.057", vo), vo.getProcedenciaSolicitacaoContato());
        }
        if ((this.isEquals(procedencia, EnumProcedenciaSolicitacao.DUVIDAS) || this.isEquals(procedencia, EnumProcedenciaSolicitacao.ERRO_SISTEMA) || this.isEquals(procedencia, EnumProcedenciaSolicitacao.IMPLEMENTACAO)) && this.valid(this.code("V.ERP.0694.058", "nodo", vo), vo.getNodo()) && !ToolMethods.isStrWithData((String)vo.getNodo().getFrameClass()) && !ToolMethods.isStrWithData((String)vo.getNodo().getPathWeb())) {
            this.addError(this.code("V.ERP.0694.059", vo), vo.getNodo());
        }
        if ((this.isEquals(procedencia, EnumProcedenciaSolicitacao.ERRO_SISTEMA) || this.isEquals(procedencia, EnumProcedenciaSolicitacao.IMPLEMENTACAO)) && this.isAffirmative(vo.getFinalizado())) {
            if (vo.getNodo() != null) {
                this.valid(this.code("V.ERP.0694.060", vo), vo.getDescricaoTecnica());
            }
            if (vo.getVersaoSerDisponibilizada() != null && vo.getVersaoSerDisponibilizada().getAtivo() != null && vo.getVersaoSerDisponibilizada().getAtivo() == 0 && vo.getProcedenciaSolicitacaoContato() != null) {
                this.addError(this.code("V.ERP.0694.061", vo), vo.getDescricaoTecnica());
            }
        }
        Long id = 38L;
        if (this.isEquals(vo.getProcedenciaSolicitacaoContato().getIdentificador(), id)) {
            this.valid(this.code("V.ERP.0694.062", vo, "relPessoaPrincipal"), vo.getRelPessoaPrincipal());
        }
        if (this.isAffirmative(vo.getFinalizado()) && this.isEquals(vo.getProcedenciaSolicitacaoContato().getExigirReembolsos(), (short)1) && !TMethods.isWithData((Collection)vo.getReembolsoContSistemas())) {
            this.addError(this.code("V.ERP.0694.068", vo), vo.getProcedenciaSolicitacaoContato());
        }
    }

    private void validarTipoAtendimento(RelPessoaContato vo) {
        Boolean desenvAnalise = false;
        for (RelPessoaContatoLog r : vo.getAgendamentos()) {
            if (!this.isEquals(r.getUsuario().getSetorUsuario().getIdentificador(), 4L) && !this.isEquals(r.getUsuario().getSetorUsuario().getIdentificador(), 14L)) continue;
            desenvAnalise = true;
            break;
        }
        if (!desenvAnalise.booleanValue()) {
            return;
        }
        if (vo.getTipoAtendimento() == null || vo.getTipoAtendimento().getModeloFichaTecnica() == null) {
            return;
        }
        ModeloFichaTecnica modelo = vo.getTipoAtendimento().getModeloFichaTecnica();
        boolean achou = false;
        for (FichaTecRelPessoaContato f : vo.getFichasTecnicas()) {
            if (!this.isEquals(f.getModeloFichaTecnica(), modelo)) continue;
            achou = true;
            break;
        }
        if (!achou) {
            this.addError(this.code("V.ERP.0694.063", vo), vo.getDescricaoTecnica());
        }
    }

    private void validarCheckList(RelPessoaContato vo) {
        if (vo.getTipoAtendimento() != null && !this.isEquals(vo.getTipoAtendimento().getCodigo(), "99") && this.validNotEmpty(this.code("V.ERP.0694.063"), vo.getFichasTecnicas())) {
            this.validarFichasTecnicas(vo);
        }
    }

    public void validarVendasVinculadas(RelPessoaContato vo) {
        if (!TMethods.isWithData((Collection)vo.getVendasVinculadas())) {
            return;
        }
        HashSet tiposVenda = new HashSet();
        vo.getVendasVinculadas().forEach(i -> tiposVenda.add(i.getVendaServicosTouch().getTipoVenda()));
        boolean contemApont = false;
        boolean contemBancoHoras = false;
        boolean contemOutros = false;
        for (Short tt : tiposVenda) {
            if (TMethods.isEquals((Object)tt, (Object)3)) {
                contemBancoHoras = true;
                continue;
            }
            if (TMethods.isEquals((Object)tt, (Object)4)) {
                contemApont = true;
                continue;
            }
            contemOutros = true;
        }
        if ((contemBancoHoras || contemApont) && contemOutros) {
            this.addError(this.code("V.ERP.0694.069", vo), vo);
            return;
        }
        if (contemApont || contemBancoHoras) {
            double tempoAtend = vo.getTempoTotalCobranca();
            double tempoPrev = vo.getTempos().stream().mapToDouble(i -> i.getTempoPrevisto()).sum();
            double tempoVendas = vo.getVendasVinculadas().stream().mapToDouble(i -> i.getTempoTotal()).sum();
            if (TMethods.isAffirmative((Number)vo.getFinalizado()) && !ToolMethods.isEqualsNumber((Number)tempoAtend, (Number)tempoVendas, (int)2)) {
                this.addError(this.code("V.ERP.0694.070", vo, tempoAtend, tempoVendas), vo);
            }
            if (!TMethods.isAffirmative((Number)vo.getFinalizado()) && !ToolMethods.isWithData((Number)tempoPrev)) {
                this.addError(this.code("V.ERP.0694.072", vo), vo);
            }
        }
    }

    private void validarFichasTecnicas(RelPessoaContato vo) {
        this.valid((ValidGenericEntitiesImpl)this.validRelPessoaContatoFichaTecnica, vo.getFichasTecnicas());
    }

    private void validarCheckListTreinamento(RelPessoaContato vo) {
        if (vo.getCheckList() == null) {
            return;
        }
        for (RelPessoaContatoCheckList ch : vo.getCheckList()) {
            if (this.isEquals(ch.getCheckList().getOrigemCheckList().getPessoa(), vo.getClienteContSistemas().getTomadorPrestadorRps().getPessoa())) continue;
            this.addError(this.code("V.ERP.0694.076", vo), vo);
        }
    }
}

