/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.representante;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidRepresentante
extends ValidGenericEntitiesImpl<Representante> {
    @Override
    protected void isValid(Representante vo) {
        this.valid(this.code("V.ERP.0072.001", "pessoa"), vo.getPessoa());
        if (this.isEquals(vo.getAtivo(), EnumConstStatusObjeto.ATIVO.getValue()) && vo.getPessoa() != null && this.isEquals(vo.getPessoa().getAtivo(), EnumConstStatusObjeto.INATIVO.getValue())) {
            this.addError(this.code("V.ERP.0072.002", "ativo"), vo.getAtivo());
        }
        this.valid(this.code("V.ERP.0072.003", "classificacaoRepresentantes"), vo.getClassificacaoRepresentantes());
        this.validarComissao(vo);
        if (this.validarClassificacaoRepresentantes(vo)) {
            this.validNotEmpty(this.code("V.ERP.0072.005", "classificacoes"), vo.getClassificacoes());
        }
    }

    private boolean validarClassificacaoRepresentantes(Representante vo) {
        OpcoesVendas opcoesVendas = this.getSharedObjects().getOpcoesVendas(vo.getEmpresa());
        return opcoesVendas != null && ToolMethods.isAffirmative((Number)opcoesVendas.getUsarClassForcasVendas());
    }

    private void validarComissao(Representante vo) {
        Double totalComissao;
        if (ToolMethods.isNull((Object)vo.getComissaoFaturamento()).booleanValue()) {
            vo.setComissaoFaturamento(Double.valueOf(0.0));
        }
        if (ToolMethods.isNull((Object)vo.getComissaoPagamento()).booleanValue()) {
            vo.setComissaoPagamento(Double.valueOf(0.0));
        }
        if (ToolMethods.isNull((Object)vo.getComissaoVencimento()).booleanValue()) {
            vo.setComissaoVencimento(Double.valueOf(0.0));
        }
        if (!ToolMethods.isEquals((Object)(totalComissao = Double.valueOf(vo.getComissaoFaturamento() + vo.getComissaoPagamento() + vo.getComissaoVencimento())), (Object)100.0)) {
            this.addError(this.code("V.ERP.0072.004", "pessoa"), vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "72 - Representantes";
    }
}

