/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.rps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.modelorps.EnumConstStatusRPS;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidRps
extends ValidGenericEntitiesImpl<Rps> {
    @Override
    protected void isValid(Rps vo) {
        this.valid(this.code("V.ERP.0657.001", "condicoesPagamento"), vo.getCondicoesPagamento());
        this.valid(this.code("V.ERP.0657.002", "meioPagamento"), vo.getMeioPagamento());
        if (vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            this.valid(this.code("V.ERP.0657.003", "parcelas"), vo.getParcelas());
        }
        this.valid(this.code("V.ERP.0657.004", "dataEmissao"), vo.getDataEmissao());
        this.valid(this.code("V.ERP.0657.005", "horaEmissao"), vo.getHoraEmissao());
        if (this.isEquals(vo.getStatus(), EnumConstStatusRPS.RPS_CANCELADO.getValue())) {
            this.valid(this.code("V.ERP.0657.006", "motivoCancelamento"), vo.getMotivoCancelamento());
        }
        this.valid(this.code("V.ERP.0657.007", "unidadeTomPrestRPS"), vo.getUnidadeTomPrestRPS());
        this.valid(this.code("V.ERP.0657.008", "discriminacao"), vo.getDiscriminacao());
        this.valid(this.code("V.ERP.0657.009", "modeloRps"), vo.getModeloRps());
        this.valid(this.code("V.ERP.0657.010", "cnae"), vo.getCnae());
        this.validGreather0(this.code("V.ERP.0657.011", "valorLiquidoNfse"), vo.getValorLiquidoNfse());
        if (vo.getRpsSubstituto() != null) {
            this.validNotEquals(this.code("V.ERP.0657.012", "rpsSubstituto"), vo, vo.getRpsSubstituto());
            this.validGreather0(this.code("V.ERP.0657.013", "numeroNFseRpsSubstituto"), vo.getRpsSubstituto().getNumeroNFse());
        }
        if (this.valid(this.code("V.ERP.0657.016", "servicoRPS"), vo.getServicoRPS()) && this.isAffirmative(vo.getServicoRPS().getObrigarVincularCRMAt())) {
            this.valid(this.code("V.ERP.0657.017", "relacionamentoPessoa"), vo.getRelacionamentoPessoa());
        }
        this.valid(this.code("V.ERP.0657.018", "cidade"), vo.getCidade());
        this.validarTitulos(vo);
        this.validarObra(vo);
        this.validarTransportadora(vo);
    }

    private void validarTitulos(Rps vo) {
        if (vo.getTitulos() != null) {
            for (Titulo t : vo.getTitulos()) {
                this.valid(this.code("V.ERP.0657.019", "valor"), t.getValor());
                this.valid(this.code("V.ERP.0657.020", "carteiraCobranca"), t.getCarteiraCobranca());
                this.valid(this.code("V.ERP.0657.021", "tipoDoc"), t.getTipoDoc());
                this.valid(this.code("V.ERP.0657.022", "dataVencimento"), t.getDataVencimento());
                this.valid(this.code("V.ERP.0657.023", "dataCompetencia"), t.getDataCompetencia());
                this.valid(this.code("V.ERP.0657.024", "planoConta"), t.getPlanoConta());
            }
        }
    }

    private void validarObra(Rps vo) {
        if (this.isAffirmative(vo.getIsObra())) {
            this.valid(this.code("V.ERP.0657.025", "tipoObraConstrucao"), vo.getTipoObraConstrucao());
            this.valid(this.code("V.ERP.0657.026", "cadastroNacionalObra"), vo.getCadastroNacionalObra());
        }
    }

    private void validarTransportadora(Rps vo) {
        if (this.isTransportadora(vo).booleanValue()) {
            this.valid(this.code("V.ERP.0657.027", "tipoOperacao"), vo.getTipoOperacao());
        }
    }

    private Boolean isTransportadora(Rps vo) {
        return this.isEquals(vo.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (short)5);
    }

    @Override
    public String getSimpleName() {
        return "657 - Rps";
    }
}

