/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.tabelaprocessosesoc;

import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidTabelaProcessosEsoc
extends ValidGenericEntitiesImpl<TabelaProcessosEsoc> {
    @Override
    public String getSimpleName() {
        return "1683 - S-1070 Tabela de Processos Administrativos/Judiciais";
    }

    @Override
    protected void isValid(TabelaProcessosEsoc vo) {
        this.valid(this.code("V.ERP.1683.001", "tipoProcesso"), vo.getIdProcesso());
        this.valid(this.code("V.ERP.1683.002", "numeroProcesso"), vo.getNumeroProcesso());
        this.valid(this.code("V.ERP.1683.003", "dataInicio"), vo.getDataInicio());
        this.valid(this.code("V.ERP.1683.004", "materiaProcesso"), vo.getMateriaProcesso());
        this.validarTipoProcesso(vo);
        this.validarMateriaProcesso(vo);
    }

    public void validarMateriaProcesso(TabelaProcessosEsoc vo) {
        if (!TMethods.isNull((Object)vo.getMateriaProcesso()).booleanValue() && this.isEquals(vo.getIdProcesso().getCodigo(), "1")) {
            this.valid(this.code("V.ERP.1683.012", "codigoIndicativoSuspencao"), vo.getCodigoIndicativoSuspencao());
            this.valid(this.code("V.ERP.1683.013", "indicativoSuspencao"), vo.getIndicativoSuspensao());
        }
    }

    public void validarTipoProcesso(TabelaProcessosEsoc vo) {
        if (!TMethods.isNull((Object)vo.getIdProcesso()).booleanValue() && TMethods.isStrWithData((String)vo.getNumeroProcesso())) {
            if (this.isEquals(vo.getIdProcesso().getCodigo(), "1")) {
                if (vo.getNumeroProcesso().length() != 17 && vo.getNumeroProcesso().length() != 22) {
                    this.newMessageItem(this.code("V.ERP.1683.005"), "numeroProcesso");
                }
            } else if (this.isEquals(vo.getIdProcesso().getCodigo(), "2")) {
                if (vo.getNumeroProcesso().length() != 20) {
                    this.newMessageItem(this.code("V.ERP.1683.006"), "numeroProcesso");
                }
                this.valid(this.code("V.ERP.1683.009", "ufVara"), vo.getUfVara());
                this.valid(this.code("V.ERP.1683.010", "cidadeVara"), vo.getCidadeVara());
                this.valid(this.code("V.ERP.1683.011", "codigoIdentificacaoVara"), vo.getCodigoIdentificacaoVara());
            } else if (this.isEquals(vo.getIdProcesso().getCodigo(), "3")) {
                if (vo.getNumeroProcesso().length() != 10) {
                    this.newMessageItem(this.code("V.ERP.1683.007"), "numeroProcesso");
                }
            } else if (this.isEquals(vo.getIdProcesso().getCodigo(), "4") && vo.getNumeroProcesso().length() != 16) {
                this.newMessageItem(this.code("V.ERP.1683.008"), "numeroProcesso");
            }
        }
    }
}

