/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.transportadorredespacho;

import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComplementoTranspRedes;
import com.touchcomp.basementor.model.vo.EnderecoTranspRedes;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.complemento.ValidComplementoTranspRedes;
import com.touchcomp.basementorvalidator.entities.impl.endereco.ValidEnderecoTranspRedes;
import com.touchcomp.basementorvalidator.others.inscricaoestadual.ValidateInscricaoEstadual;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidTransportadorRedespacho
extends ValidGenericEntitiesImpl<TransportadorRedespacho> {
    @Autowired
    ValidEnderecoTranspRedes validEndereco;
    @Autowired
    ValidComplementoTranspRedes validComplemento;

    @Override
    protected void isValid(TransportadorRedespacho vo) {
        this.valid(this.code("V.ERP.0069.001", "nome"), vo.getNome());
        this.valid(this.code("V.ERP.0069.002", "endereco"), vo.getEndereco());
        this.valid(this.code("V.ERP.0069.003", "complemento"), vo.getComplemento());
        if (vo.getComplemento() != null && vo.getEndereco() != null) {
            this.validarInscEst(vo.getComplemento(), vo.getEndereco());
        }
        this.valid((ValidGenericEntitiesImpl)this.validComplemento, (InterfaceVO)vo.getComplemento());
        this.valid((ValidGenericEntitiesImpl)this.validEndereco, (InterfaceVO)vo.getEndereco());
    }

    @Override
    public String getSimpleName() {
        return "Transportador Redespacho";
    }

    private void validarInscEst(ComplementoTranspRedes vo, EnderecoTranspRedes end) {
        if (TMethods.isStrWithData((String)vo.getInscEst()) && end != null && end.getCidade() != null) {
            EnumConstUF uf = EnumConstUF.get((Object)end.getCidade().getUf().getSigla());
            if (!ValidateInscricaoEstadual.isValid(vo.getInscEst(), uf)) {
                this.addError(this.code("V.ERP.0069.004", "inscEst", vo.getInscEst()), vo.getInscEst());
            }
        }
    }
}

