/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.usuario;

import com.touchcomp.basementor.constants.enums.usuario.EnumConstTipoUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidUsuario
extends ValidGenericEntitiesImpl<Usuario> {
    @Override
    public void isValid(Usuario vo) {
        if (this.valid(this.code("V.ERP.0054.001", "usuarioBasico"), vo.getUsuarioBasico())) {
            if (!this.isAffirmative(vo.getUsuarioBasico().getPessoa().getAtivo()) && this.isAffirmative(vo.getAtivo())) {
                this.addError(this.code("V.ERP.0054.009", "usuarioBasico"), vo.getAtivo());
            }
            if (!this.isAffirmative(vo.getUsuarioBasico().getAtivo()) && this.isAffirmative(vo.getAtivo())) {
                this.addError(this.code("V.ERP.0054.010", "usuarioBasico"), vo.getAtivo());
            }
        }
        this.valid(this.code("V.ERP.0054.002", "setorUsuario"), vo.getSetorUsuario());
        if (this.valid(this.code("V.ERP.0054.003", "tipoUsuario"), vo.getTipoUsuario())) {
            if (this.isEquals(vo.getTipoUsuario(), EnumConstTipoUsuario.USUARIO_INTEGRADOR_API.getValue())) {
                this.valid(this.code("V.ERP.0054.008", "usuarioConfiguracoes"), vo.getUserAccessToken());
            } else {
                this.valid(this.code("V.ERP.1945.009", "pessoa"), vo.getUsuarioBasico().getPessoa().getComplemento().getDataNascimento());
                this.valid(this.code("V.ERP.1945.011", "pessoa"), vo.getUsuarioBasico().getPessoa().getComplemento().getEmailPrincipal());
            }
        }
        if (this.valid(this.code("V.ERP.0054.004", "usuarioConfiguracoes"), vo.getUsuarioConfiguracoes())) {
            this.validMinMax(this.code("V.ERP.0054.007", "usuarioConfiguracoes"), vo.getUsuarioConfiguracoes().getPercDescontoBaixaTitulo(), 0, 100);
            this.validMinMax(this.code("V.ERP.0054.008", "usuarioConfiguracoes"), vo.getUsuarioConfiguracoes().getPercDescontoPedido(), 0, 100);
        }
    }

    @Override
    public String getSimpleName() {
        return "54";
    }
}

