/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmsentradaestoque;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoqueItem;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.impl.RulesWmsEntradaProdutos;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.wmsentradaestoque.ValidWmsEntradaEstoqueItem;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsEntradaEstoque
extends ValidGenericEntitiesImpl<WmsEntradaEstoque> {
    private ValidWmsEntradaEstoqueItem validWmsEntradaEstoqueItem = new ValidWmsEntradaEstoqueItem();
    @Autowired
    RulesWmsEntradaProdutos rulesWmsEntrada;

    @Override
    protected void isValid(WmsEntradaEstoque vo) {
        this.valid(this.code("V.ERP.1912.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1912.002", "dataEntrada"), vo.getDataEntrada());
        if (this.isAffirmative(vo.getEfetivarEntrada()) && this.validNotEmpty(this.code("V.ERP.1912.004"), vo.getItens())) {
            this.validItens(vo);
            this.validQtdItens(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "entrada_estoque";
    }

    private void validItens(WmsEntradaEstoque vo) {
        for (WmsEntradaEstoqueItem item : vo.getItens()) {
            this.valid((ValidGenericEntitiesImpl)this.getValidWmsEntradaEstoqueItem(), (InterfaceVO)item);
        }
        this.getContainer().addItens(this.getValidWmsEntradaEstoqueItem().getContainer().getItens());
    }

    private void validQtdItens(WmsEntradaEstoque vo) {
        List m = this.rulesWmsEntrada.getResumoItensDiferenca(vo, true);
        if (m != null && !m.isEmpty()) {
            this.addError(this.code("V.ERP.1912.010", "quantidade", m.toString()), vo);
        }
    }

    public ValidWmsEntradaEstoqueItem getValidWmsEntradaEstoqueItem() {
        return this.validWmsEntradaEstoqueItem;
    }

    public void setValidWmsEntradaEstoqueItem(ValidWmsEntradaEstoqueItem validWmsEntradaEstoqueItem) {
        this.validWmsEntradaEstoqueItem = validWmsEntradaEstoqueItem;
    }
}

