/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmsopcoes;

import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsOpcoes
extends ValidGenericEntitiesImpl<WmsOpcoes> {
    @Override
    protected void isValid(WmsOpcoes entity) {
        this.valid(this.code("V.ERP.1899.001", "statusPedidoRecebimento"), entity.getStatusPedidoRecebimento());
        this.valid(this.code("V.ERP.1899.002", "statusPedidoSolicitacao"), entity.getStatusPedidoSolicitacao());
        this.valid(this.code("V.ERP.1899.003", "statusPedidoSeparacao"), entity.getStatusPedidoSeparacao());
        this.valid(this.code("V.ERP.1899.005", "statusPedidoConferencia"), entity.getStatusPedidoConferencia());
        this.valid(this.code("V.ERP.1899.006", "statusPedidoSaida"), entity.getStatusPedidoSaida());
        this.valid(this.code("V.ERP.1899.008", "mascara"), entity.getMascara());
        if (!this.validPontoFinal(entity)) {
            this.addError(this.code("V.ERP.1899.009", "mascara"), entity.getMascara());
        }
    }

    @Override
    public String getSimpleName() {
        return "1905";
    }

    protected boolean validPontoFinal(WmsOpcoes entity) {
        if (entity.getMascara() == null) {
            return true;
        }
        String mascara = entity.getMascara();
        Pattern pattern = Pattern.compile("([A]\\.?){2,}");
        return pattern.matcher(mascara).matches();
    }
}

