/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmsseparacaopedido;

import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsSeparacaoPedido
extends ValidGenericEntitiesImpl<WmsSeparacaoPedido> {
    @Autowired
    CompTotaisItemGradesAdp compTotaisItem;

    @Override
    protected void isValid(WmsSeparacaoPedido vo) {
        this.valid(this.code("V.ERP.1916.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1916.002", "usuarioSeparacao"), vo.getUsuarioSeparacao());
        this.valid0(this.code("V.ERP.1916.003", "quantidadeTotal"), vo.getQuantidadeTotal());
        this.valid0(this.code("V.ERP.1916.004", "volumeTotal"), vo.getVolumeTotal());
        this.valid0(this.code("V.ERP.1916.005", "pesoTotal"), vo.getPesoTotal());
        this.valid0(this.code("V.ERP.1916.008", "quantidadeTotalConf"), vo.getQuantidadeTotalConf());
        this.valid0(this.code("V.ERP.1916.009", "volumeTotaConf"), vo.getVolumeTotaConf());
        this.valid0(this.code("V.ERP.1916.010", "pesoTotalConf"), vo.getPesoTotalConf());
        this.valid0(this.code("V.ERP.1916.011", "percConferido"), vo.getPercConferido());
        this.valid(this.code("V.ERP.1916.006", "pedidoWms"), vo.getPedidoWms());
        if (this.validNotEmpty(this.code("V.ERP.1916.007", "itensConf"), vo.getEmbalagens())) {
            this.validEmbalagens(vo);
        }
        this.validarQuantidades(vo);
    }

    @Override
    public String getSimpleName() {
        return "1916";
    }

    private void validEmbalagens(WmsSeparacaoPedido wms) {
        for (WmsSeparacaoPedidoEmb vo : wms.getEmbalagens()) {
            this.valid(this.code("V.ERP.1916.013", "embalagem", vo.getNumeroCaixa()), vo.getEmbalagem());
            this.valid0(this.code("V.ERP.1916.014", "capacidadePeso", vo.getNumeroCaixa()), vo.getCapacidadePeso());
            this.valid0(this.code("V.ERP.1916.015", "capacidadeVolume", vo.getNumeroCaixa()), vo.getCapacidadeVolume());
            this.valid0(this.code("V.ERP.1916.016", "volumeUtilizado", vo.getNumeroCaixa()), vo.getVolumeUtilizado());
            this.valid0(this.code("V.ERP.1916.017", "pesoUtilizado", vo.getNumeroCaixa()), vo.getPesoUtilizado());
            this.valid0(this.code("V.ERP.1916.018", "quantidadeItens", vo.getNumeroCaixa()), vo.getQuantidadeItens());
            this.valid0(this.code("V.ERP.1916.019", "percPesoUtilizado", vo.getNumeroCaixa()), vo.getPercPesoUtilizado());
            this.valid0(this.code("V.ERP.1916.020", "percVolumeUtilizado", vo.getNumeroCaixa()), vo.getPercVolumeUtilizado());
            if (vo.getPesoUtilizado() != null && vo.getPesoUtilizado() > vo.getCapacidadePeso()) {
                this.addError(this.code("V.ERP.1916.029", "capacidadePeso", vo.getNumeroCaixa()), vo.getPesoUtilizado());
            }
            if (vo.getVolumeUtilizado() != null && vo.getVolumeUtilizado() > vo.getCapacidadeVolume()) {
                this.addError(this.code("V.ERP.1916.030", "capacidadePeso", vo.getNumeroCaixa()), vo.getVolumeUtilizado());
            }
            if (!this.validNotEmpty(this.code("V.ERP.1916.007", "itensConf", vo.getNumeroCaixa()), vo.getGradesConf())) continue;
            this.validItensEmbalagem(vo);
        }
    }

    private void validItensEmbalagem(WmsSeparacaoPedidoEmb emb) {
        for (WmsSeparacaoPedidoGrConf vo : emb.getGradesConf()) {
            this.valid(this.code("V.ERP.1916.021", "quantidadeConf", emb.getNumeroCaixa()), vo.getQuantidadeConf());
            this.valid(this.code("V.ERP.1916.023", "wmsEndereco", emb.getNumeroCaixa()), vo.getWmsEndereco());
        }
    }

    private void validarQuantidades(WmsSeparacaoPedido vo) {
        if (!this.isAffirmative(vo.getConferenciaFinalizada())) {
            return;
        }
        List totaisPed = this.compTotaisItem.getTotaisGrades(vo.getPedidoWms());
        List totaisSep = this.compTotaisItem.getTotaisGrades(vo);
        for (TotalItemGrade totalItemGrade : totaisPed) {
            Optional<TotalItemGrade> found = totaisSep.stream().filter(i -> this.isEquals(i.getGradeCor(), totalItemGrade.getGradeCor())).findFirst();
            if (!found.isPresent()) {
                this.addError(this.code("V.ERP.1916.028", "wmsSolicitacaoGrade", totalItemGrade.getGradeCor()), totalItemGrade.getGradeCor());
            }
            if (Math.abs(totalItemGrade.getQuantidadeTotal() - found.get().getQuantidadeTotal()) > 1.0E-4) {
                this.addError(this.code("V.ERP.1916.031", "wmsSolicitacaoGrade", totalItemGrade.getQuantidadeTotal(), totalItemGrade.getGradeCor(), found.get().getQuantidadeTotal()), totalItemGrade.getGradeCor());
            }
            totaisSep.remove(found.get());
        }
        for (TotalItemGrade totalItemGrade : totaisSep) {
            this.addError(this.code("V.ERP.1916.032", "wmsSolicitacaoGrade", totalItemGrade.getGradeCor()), totalItemGrade.getGradeCor());
        }
    }
}

