/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchvomodel.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UtilVOClass {
    private List<Class> classes = new ArrayList<Class>();
    private static UtilVOClass instance;

    private UtilVOClass() {
    }

    public static UtilVOClass get() {
        if (instance == null) {
            instance = new UtilVOClass();
            instance.loadClasses();
        }
        return instance;
    }

    public static List<Class<?>> getClassesForPackage(String pkgName) throws IOException, URISyntaxException {
        Path root;
        String pkgPath = pkgName.replace('.', '/');
        URI pkg = Objects.requireNonNull(ClassLoader.getSystemClassLoader().getResource(pkgPath)).toURI();
        ArrayList allClasses = new ArrayList();
        if (pkg.toString().startsWith("jar:")) {
            try {
                root = FileSystems.getFileSystem(pkg).getPath(pkgPath, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(pkg, Collections.emptyMap()).getPath(pkgPath, new String[0]);
            }
        } else {
            root = Paths.get(pkg);
        }
        String extension = ".class";
        try (Stream<Path> allPaths = Files.walk(root, new FileVisitOption[0]);){
            allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    String path = file.toString().replace('/', '.');
                    String name = path.substring(path.indexOf(pkgName), path.length() - ".class".length());
                    allClasses.add(Class.forName(name));
                }
                catch (ClassNotFoundException | StringIndexOutOfBoundsException exception) {
                    // empty catch block
                }
            });
        }
        return allClasses;
    }

    private void loadClasses() {
        try {
            this.classes = new ArrayList(UtilVOClass.getClassesForPackage("com.touchcomp.touchvomodel"));
            System.out.println("Classes Carregadas " + this.classes.size());
        }
        catch (Exception ex) {
            Logger.getLogger(UtilVOClass.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Class findClass(String name) {
        List res = this.classes.stream().filter(i -> i.getCanonicalName().endsWith(name)).collect(Collectors.toList());
        if (res.isEmpty()) {
            return null;
        }
        return (Class)res.get(0);
    }
}

