/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchvomodel.web;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Objects;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.messages.EnumConstStatusWebMessage;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.web.WebDTOEntity;
import com.touchcomp.touchvomodel.web.WebDTOMessage;
import com.touchcomp.touchvomodel.web.WebDTOObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=WebDTOEntity.class, name="tempEntity"), @JsonSubTypes.Type(value=WebDTOObject.class, name="tempObject")})
public class WebDTOResult<S> {
    private EnumConstantsMentorStatus status;
    private List<WebDTOMessage> messages = new LinkedList<WebDTOMessage>();
    private S result;
    private Long countOf = 0L;
    private String name;
    private String message;
    private String detailMessage;

    public WebDTOResult() {
        this.status = EnumConstantsMentorStatus.SUCESSO;
    }

    public WebDTOResult(EnumConstantsMentorStatus status) {
        this();
        this.status = status;
    }

    public WebDTOResult(EnumConstantsMentorStatus status, WebDTOMessage message) {
        this(status);
        this.messages = ToolMethods.toList((Object[])new Object[]{message});
    }

    public WebDTOResult(S result) {
        this();
        this.result = result;
    }

    public WebDTOResult(Throwable ex) {
        this();
        this.status = EnumConstantsMentorStatus.ERRO;
        this.message = ex.getMessage();
    }

    public WebDTOResult setResult(S result) {
        this.result = result;
        if (result instanceof Collection) {
            this.setCountOf(Long.valueOf(((Collection)result).size()));
        } else if (result != null) {
            this.setCountOf(1L);
        }
        return this;
    }

    public WebDTOResult addMessage(String codMessage, String message, EnumConstStatusWebMessage status) {
        this.getMessages().add(new WebDTOMessage(codMessage, message, status));
        return this;
    }

    public WebDTOResult addMessage(String codMessage, String message) {
        this.getMessages().add(new WebDTOMessage(codMessage, message, EnumConstStatusWebMessage.INFO));
        return this;
    }

    public WebDTOResult addMessage(String codMessage, String message, String fieldName) {
        this.getMessages().add(new WebDTOMessage(codMessage, message, EnumConstStatusWebMessage.INFO, fieldName));
        return this;
    }

    public WebDTOResult addErroMessage(String codMessage, String message) {
        this.setStatus(EnumConstantsMentorStatus.ERRO);
        if (ToolMethods.isStrWithData((String)message)) {
            this.getMessages().add(new WebDTOMessage(codMessage, message, EnumConstStatusWebMessage.ERRO));
        } else {
            this.getMessages().add(new WebDTOMessage(codMessage, MessagesBaseMentor.getValidationMsg((String)codMessage, (Object[])new Object[0]), EnumConstStatusWebMessage.ERRO));
        }
        return this;
    }

    public WebDTOResult addErroMessage(String codMessage, String message, String fieldName) {
        this.setStatus(EnumConstantsMentorStatus.ERRO);
        if (ToolMethods.isStrWithData((String)message)) {
            this.getMessages().add(new WebDTOMessage(codMessage, message, EnumConstStatusWebMessage.ERRO, fieldName));
        } else {
            this.getMessages().add(new WebDTOMessage(codMessage, MessagesBaseMentor.getValidationMsg((String)codMessage, (Object[])new Object[]{fieldName}), EnumConstStatusWebMessage.ERRO, fieldName));
        }
        return this;
    }

    public WebDTOResult addWarning(String codMessage) {
        this.getMessages().add(new WebDTOMessage(codMessage, MessagesBaseMentor.getMsg((String)codMessage, (Object[])new Object[0]), EnumConstStatusWebMessage.WARNING));
        this.setStatus(EnumConstantsMentorStatus.ATENCAO);
        return this;
    }

    public WebDTOResult addWarning(String codMessage, Object ... details) {
        this.getMessages().add(new WebDTOMessage(codMessage, MessagesBaseMentor.getMsg((String)codMessage, (Object[])details), EnumConstStatusWebMessage.WARNING));
        this.setStatus(EnumConstantsMentorStatus.ATENCAO);
        return this;
    }

    public WebDTOResult addWarning(String codMessage, String message, String fieldName) {
        this.getMessages().add(new WebDTOMessage(codMessage, MessagesBaseMentor.getMsg((String)codMessage, (Object[])new Object[0]), EnumConstStatusWebMessage.WARNING, fieldName));
        this.setStatus(EnumConstantsMentorStatus.ATENCAO);
        return this;
    }

    public boolean hasErrors() {
        Optional<WebDTOMessage> t = this.getMessages().stream().filter(i -> Objects.equal((Object)i.getStatus(), (Object)EnumConstStatusWebMessage.ERRO)).findFirst();
        return t.isPresent();
    }

    @Generated
    public EnumConstantsMentorStatus getStatus() {
        return this.status;
    }

    @Generated
    public List<WebDTOMessage> getMessages() {
        return this.messages;
    }

    @Generated
    public S getResult() {
        return this.result;
    }

    @Generated
    public Long getCountOf() {
        return this.countOf;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getDetailMessage() {
        return this.detailMessage;
    }

    @Generated
    public void setStatus(EnumConstantsMentorStatus status) {
        this.status = status;
    }

    @Generated
    public void setMessages(List<WebDTOMessage> messages) {
        this.messages = messages;
    }

    @Generated
    public void setCountOf(Long countOf) {
        this.countOf = countOf;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setDetailMessage(String detailMessage) {
        this.detailMessage = detailMessage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebDTOResult)) {
            return false;
        }
        WebDTOResult other = (WebDTOResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$countOf = this.getCountOf();
        Long other$countOf = other.getCountOf();
        if (this$countOf == null ? other$countOf != null : !((Object)this$countOf).equals(other$countOf)) {
            return false;
        }
        EnumConstantsMentorStatus this$status = this.getStatus();
        EnumConstantsMentorStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<WebDTOMessage> this$messages = this.getMessages();
        List<WebDTOMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        S this$result = this.getResult();
        S other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$detailMessage = this.getDetailMessage();
        String other$detailMessage = other.getDetailMessage();
        return !(this$detailMessage == null ? other$detailMessage != null : !this$detailMessage.equals(other$detailMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebDTOResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $countOf = this.getCountOf();
        result = result * 59 + ($countOf == null ? 43 : ((Object)$countOf).hashCode());
        EnumConstantsMentorStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<WebDTOMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        S $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $detailMessage = this.getDetailMessage();
        result = result * 59 + ($detailMessage == null ? 43 : $detailMessage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebDTOResult(status=" + String.valueOf(this.getStatus()) + ", messages=" + String.valueOf(this.getMessages()) + ", result=" + String.valueOf(this.getResult()) + ", countOf=" + this.getCountOf() + ", name=" + this.getName() + ", message=" + this.getMessage() + ", detailMessage=" + this.getDetailMessage() + ")";
    }

    public static class ComboObjects<C> {
        private List<C> data;
        private String chave;

        public ComboObjects(String chave, List<C> data) {
            this.data = data;
            this.chave = chave;
        }

        @Generated
        public List<C> getData() {
            return this.data;
        }

        @Generated
        public String getChave() {
            return this.chave;
        }

        @Generated
        public void setData(List<C> data) {
            this.data = data;
        }

        @Generated
        public void setChave(String chave) {
            this.chave = chave;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComboObjects)) {
                return false;
            }
            ComboObjects other = (ComboObjects)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<C> this$data = this.getData();
            List<C> other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            String this$chave = this.getChave();
            String other$chave = other.getChave();
            return !(this$chave == null ? other$chave != null : !this$chave.equals(other$chave));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComboObjects;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<C> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            String $chave = this.getChave();
            result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebDTOResult.ComboObjects(data=" + String.valueOf(this.getData()) + ", chave=" + this.getChave() + ")";
        }
    }
}

