/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.socket.EnumExcepSocket;
import com.touchcomp.basementorexceptions.exceptions.impl.socket.ExceptionSocket;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ComunicadorBaseTCPSocket {
    private String host;
    private int port;
    private Socket clientSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private int maxAttempts = 3;
    private int timeToRetry = 1000;
    private int timeoutCom = 500;
    private boolean configured;

    public synchronized void connect(String host, int port) throws ExceptionIO {
        this.connect(host, port, this.timeoutCom);
    }

    public synchronized void connect(String host, int port, int timeout) throws ExceptionIO {
        this.setHost(host);
        this.setPort(port);
        this.setTimeout(timeout);
        this.configured = true;
        try {
            this.setClientSocket(new Socket(this.getHost(), this.getPort()));
            this.setReader(new BufferedReader(new InputStreamReader(this.getClientSocket().getInputStream())));
            this.setWriter(new BufferedWriter(new OutputStreamWriter(this.getClientSocket().getOutputStream())));
        }
        catch (IOException ex) {
            Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{"Falha ao conectar " + host + ":" + port});
        }
    }

    public synchronized void reconnect() throws ExceptionIO {
        this.connect(this.getHost(), this.getPort(), this.getTimeout());
    }

    public boolean isConnected() {
        return this.configured && this.getClientSocket() != null && !this.clientSocket.isClosed();
    }

    public void disconnect() throws ExceptionIO {
        if (this.getClientSocket() != null && !this.clientSocket.isClosed()) {
            try {
                this.getClientSocket().close();
            }
            catch (IOException ex) {
                throw new ExceptionIO(ex);
            }
        }
    }

    public String sendCommand(String comando) throws ExceptionIO, ExceptionSocket {
        return this.sendCommand(comando, this.getTimeout());
    }

    public String sendCommand(String comando, int timeout) throws ExceptionIO, ExceptionSocket {
        return this.sendCommand(comando, timeout, true);
    }

    public synchronized String sendCommand(String comando, int timeout, boolean waitForResponse) throws ExceptionIO, ExceptionSocket {
        System.out.println("Comando: " + comando);
        this.testIfConnected();
        try {
            String output = "";
            this.writeSocket(comando);
            this.setReader(new BufferedReader(new InputStreamReader(this.getClientSocket().getInputStream())));
            if (!waitForResponse) {
                this.writeInLocalFile(comando, "", timeout, waitForResponse);
                return comando;
            }
            long fim = System.currentTimeMillis() + (long)timeout;
            long run = 0L;
            while (!this.reader.ready()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
                }
                if ((run += 10L) <= 5000L) continue;
                throw new ExceptionSocket(EnumExcepSocket.COMANDO_INVALIDO, new Object[]{comando});
            }
            while (fim > System.currentTimeMillis()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
                }
                char chRec = (char)this.getReader().read();
                output = output + chRec;
                if (chRec == '(') {
                    output = "(";
                }
                if (chRec != ')') continue;
                break;
            }
            System.out.println("Recebido: " + output);
            System.out.println("");
            this.writeInLocalFile(comando, output, timeout, waitForResponse);
            return output;
        }
        catch (IOException ex) {
            Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public String read() throws ExceptionIO, ExceptionSocket {
        this.testIfConnected();
        try {
            char[] buf = new char[100];
            while (!this.reader.ready()) {
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.getReader().read(buf);
            return new String(buf);
        }
        catch (IOException ex) {
            Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    private void testIfConnected() throws ExceptionSocket {
        if (!this.configured) {
            throw new ExceptionSocket(EnumExcepSocket.SOCKET_DESCONECTADO, new Object[]{this.getHost() + ":" + this.getPort()});
        }
        if (!this.isConnected()) {
            int count = 0;
            do {
                if (count > 0) {
                    try {
                        Thread.sleep(this.getTimeToRetry());
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                try {
                    this.connect(this.getHost(), this.getPort(), this.getTimeout());
                }
                catch (ExceptionIO ex) {
                    Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
                }
            } while (!this.isConnected() || ++count < this.getMaxAttempts());
        }
        if (!this.isConnected()) {
            throw new ExceptionSocket(EnumExcepSocket.SOCKET_DESCONECTADO, new Object[]{this.getHost() + ":" + this.getPort()});
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeoutCom;
    }

    public void setTimeout(int timeout) {
        this.timeoutCom = timeout;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getTimeToRetry() {
        return this.timeToRetry;
    }

    public void setTimeToRetry(int timeToRetry) {
        this.timeToRetry = timeToRetry;
    }

    public abstract String preparaComando(String var1);

    public abstract String preparaComandoCheckSum(String var1);

    public double toDouble(String number, int casasDec) {
        String pre = number.substring(0, number.length() - casasDec);
        String suf = number.substring(number.length() - casasDec);
        return Double.valueOf(pre + "." + suf);
    }

    public Double truncarValorTotalPagar(Double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, 1);
        return bd.doubleValue();
    }

    private void writeInLocalFile(String comando, String output, int timeout, boolean waitForResponse) {
        String value = System.getProperty("debugCompanytecFile");
        if (value == null || value.isEmpty()) {
            return;
        }
        File f = new File("local_debug_file_companytec.txt");
        String builder = comando + "|" + timeout + "|" + waitForResponse + "|" + output;
        if (!f.exists()) {
            builder = "Comando|Timeout|Aguarda retorno|Resposta automacao" + builder;
        }
        try (FileWriter fileWriter = new FileWriter(f, true);){
            fileWriter.write(builder);
        }
        catch (IOException e) {
            e.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)e);
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    protected void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    protected void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    private void writeSocket(String comando) throws IOException {
        try {
            this.getWriter().write(comando);
            this.getWriter().flush();
        }
        catch (IOException ex) {
            Logger.getLogger(ComunicadorBaseTCPSocket.class.getName()).log(Level.SEVERE, null, ex);
            this.configured = false;
            throw ex;
        }
    }
}

