/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.params;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.dao.ExhibitionParam;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.NamedColor;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.Palette;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.Util;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.DataBuffer;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class ArgDisplayText
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TEXT_MAX_LENGTH = 128;
    private static final int FONT_NAME_MAX_LENGTH = 32;
    private static final Charset TEXT_CHARSET = Charset.forName("ISO-8859-1");
    private final short posX;
    private final short posY;
    private final String text;
    private final String font;
    private final short fontSize;
    private final short fontColor;
    private final short backgroundColor;

    public static ArgDisplayText createArgDisplayText(String text, ExhibitionParam param) {
        return new ArgDisplayText(param.getX(), param.getY(), text, param.getFont(), param.getFontSize(), Palette.getInstance().getColorId(param.getFgColor()), Palette.getInstance().getColorId(param.getBgColor()));
    }

    public ArgDisplayText(byte[] data) {
        DataBuffer buffer = new DataBuffer();
        buffer.put(data);
        this.posX = buffer.readShort();
        this.posY = buffer.readShort();
        this.text = Util.getNullTerminatedString(buffer.readBytes(128), TEXT_CHARSET);
        this.font = Util.getNullTerminatedString(buffer.readBytes(32));
        this.fontSize = buffer.readShort();
        this.fontColor = buffer.readShort();
        this.backgroundColor = buffer.readShort();
    }

    public ArgDisplayText(short posX, short posY, String text, String font, short fontSize, short fontColor, short backgroundColor) {
        if (text.getBytes(TEXT_CHARSET).length > 128) {
            throw new IllegalArgumentException("Text is too long: " + text);
        }
        if (font.getBytes(TEXT_CHARSET).length > 32) {
            throw new IllegalArgumentException("Font name is too long: " + font);
        }
        this.posX = posX;
        this.posY = posY;
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
    }

    public short getPosX() {
        return this.posX;
    }

    public short getPosY() {
        return this.posY;
    }

    public String getText() {
        return this.text;
    }

    public String getFont() {
        return this.font;
    }

    public short getFontSize() {
        return this.fontSize;
    }

    public short getFontColor() {
        return this.fontColor;
    }

    public short getBackgroundColor() {
        return this.backgroundColor;
    }

    public String toString() {
        return String.format("Position X: %s\nPosition Y: %s\nText: %s\nFont: %s\nFont Size: %s\nFont Color: %s\nBackground Color: %s", this.posX, this.posY, this.text, this.font, this.fontSize, NamedColor.fromId(this.fontColor).name(), NamedColor.fromId(this.backgroundColor).name());
    }

    public byte[] getSerializedData() {
        DataBuffer buffer = new DataBuffer();
        buffer.putShort(this.posX);
        buffer.putShort(this.posY);
        try {
            buffer.putString(this.text, TEXT_CHARSET.name(), 128);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid charset: " + TEXT_CHARSET);
        }
        buffer.putString(this.font, 32);
        buffer.putShort(this.fontSize);
        buffer.putShort(this.fontColor);
        buffer.putShort(this.backgroundColor);
        return buffer.readBytes();
    }
}

