/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.Palette;
import java.awt.Color;

public enum NamedColor {
    BLACK(Color.BLACK.getRGB()),
    RED(Color.RED.getRGB()),
    YELLOW(Color.YELLOW.getRGB()),
    BLUE(Color.BLUE.getRGB()),
    WHITE(new Color(254, 255, 254, 255).getRGB()),
    GREEN(Color.GREEN.getRGB()),
    BROWN(new Color(139, 69, 19, 255).getRGB()),
    OLIVE(new Color(128, 128, 0, 255).getRGB()),
    NAVY(new Color(0, 0, 128, 255).getRGB()),
    PURPLE(new Color(128, 0, 128, 255).getRGB()),
    METALLIC(new Color(191, 191, 191, 255).getRGB()),
    GREY(new Color(128, 128, 128, 255).getRGB()),
    SILVER(new Color(192, 192, 192, 255).getRGB()),
    LIME(new Color(191, 255, 0, 255).getRGB()),
    FUCHSIA(new Color(255, 0, 255, 255).getRGB()),
    WATER(new Color(28, 163, 236, 255).getRGB()),
    TRANSPARENT(new Color(255, 255, 255, 255).getRGB());

    private int rgb;

    public static NamedColor fromName(String name) {
        try {
            return NamedColor.valueOf(name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static NamedColor fromId(Short id) {
        return Palette.getInstance().getColor(id);
    }

    public static NamedColor fromRGB(int rgb) {
        NamedColor color = null;
        for (NamedColor nc : NamedColor.values()) {
            if (nc.getRgb() != rgb) continue;
            color = nc;
        }
        return color;
    }

    private NamedColor(int colorCode) {
        this.rgb = colorCode;
    }

    public Short getId() {
        return Palette.getInstance().getColorId(this);
    }

    public int getRgb() {
        return this.rgb;
    }

    public String toString() {
        return this.name();
    }
}

