/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcConnection;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcException;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class JdbcResultSet {
    private final ResultSet coreRs;
    private final JdbcStatment stmt;

    JdbcResultSet(ResultSet rs, JdbcStatment stmt) {
        this.coreRs = rs;
        this.stmt = stmt;
    }

    public final ResultSet getCoreResultSet() {
        return this.coreRs;
    }

    public final JdbcStatment getStatement() {
        return this.stmt;
    }

    public JdbcConnection getConnection() {
        return this.getStatement().getConnection();
    }

    public Integer getInt(String col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            int val = rs.getInt(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Integer getInt(int col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            int val = rs.getInt(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Long getLong(String col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            long val = rs.getLong(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Long getLong(int col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            long val = rs.getLong(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Short getShort(String col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            short val = rs.getShort(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Short getShort(int col) throws JdbcException {
        try {
            ResultSet rs = this.getCoreResultSet();
            short val = rs.getShort(col);
            if (rs.wasNull()) {
                return null;
            }
            return val;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public String getString(String col) throws JdbcException {
        try {
            return this.getCoreResultSet().getString(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public String getString(int col) throws JdbcException {
        try {
            return this.getCoreResultSet().getString(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Date getDate(String col) throws JdbcException {
        try {
            return this.getCoreResultSet().getDate(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Date getDate(int col) throws JdbcException {
        try {
            return this.getCoreResultSet().getDate(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Timestamp getTimestamp(String col) throws JdbcException {
        try {
            return this.getCoreResultSet().getTimestamp(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Timestamp getTimestamp(int col) throws JdbcException {
        try {
            return this.getCoreResultSet().getTimestamp(col);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public <E extends Enum<E>> E getEnum(Class<E> enumType, String col) throws JdbcException {
        String name = this.getString(col);
        if (name == null) {
            return null;
        }
        return Enum.valueOf(enumType, name);
    }

    public <E extends Enum<E>> E getEnum(Class<E> enumType, int col) throws JdbcException {
        String name = this.getString(col);
        if (name == null) {
            return null;
        }
        return Enum.valueOf(enumType, name);
    }

    public boolean next() throws JdbcException {
        try {
            return this.getCoreResultSet().next();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isClosed() throws JdbcException {
        try {
            return this.getCoreResultSet().isClosed();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void close() throws JdbcException {
        try {
            this.getCoreResultSet().close();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }
}

