/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.EventLoop;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.AbstractRawConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ConnectionChannel;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.SocketChannel;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.SocketConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class RawSocketConnection
extends AbstractRawConnection
implements SocketConnection {
    private Socket socket;

    public RawSocketConnection(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected String getReaderThreadName(Object ... args) {
        Socket socket = (Socket)args[0];
        String host = (String)args[1];
        Integer port = (Integer)args[2];
        if (socket != null) {
            host = socket.getInetAddress().getHostAddress();
            port = socket.getPort();
        }
        return String.format("socket-reader (%s:%d)", host, port);
    }

    protected SocketChannel getTcpSocketChannel(Socket socket) {
        return new SocketChannel(socket);
    }

    @Override
    protected final ConnectionChannel getChannel(Object ... args) throws Throwable {
        Socket socket = (Socket)args[0];
        String host = (String)args[1];
        Integer port = (Integer)args[2];
        Integer timeout = (Integer)args[3];
        if (socket == null) {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, (int)port), timeout);
        }
        this.socket = socket;
        return this.getTcpSocketChannel(socket);
    }

    @Override
    public void open(String host, int port, int timeout) {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty host");
        }
        if (port < 1 || port > 65536) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.open(null, host, port, timeout);
    }

    @Override
    public void open(Socket socket) {
        this.open(socket, null, null, null);
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getPort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    @Override
    public int getLocalPort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    public String toString() {
        if (this.socket == null) {
            return String.format("%s (unused)", super.toString());
        }
        return String.format("%s (open: %s, port: %d, localPort: %d)", this.getInetAddress().getHostAddress(), this.isOpen(), this.getPort(), this.getLocalPort());
    }
}

