/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.thermalprinter;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;

public class USBConnectedDevices {
    public static List<USBConnectedDevice> listAll() throws UsbException {
        LinkedList<USBConnectedDevice> devices = new LinkedList<USBConnectedDevice>();
        UsbServices services = UsbHostManager.getUsbServices();
        USBConnectedDevices.processDevice((UsbDevice)services.getRootUsbHub(), devices);
        return devices;
    }

    public static UsbDevice getByNumeroSerie(String numeroSerie) throws UsbException, UnsupportedEncodingException {
        UsbServices services = UsbHostManager.getUsbServices();
        return USBConnectedDevices.getDevice((UsbDevice)services.getRootUsbHub(), numeroSerie);
    }

    private static UsbDevice getDevice(UsbDevice device, String numeroSerie) throws UsbException, UnsupportedEncodingException {
        UsbDevice found = null;
        if (device.isUsbHub()) {
            UsbDevice child;
            UsbHub hub = (UsbHub)device;
            Iterator iterator = hub.getAttachedUsbDevices().iterator();
            while (iterator.hasNext() && (found = USBConnectedDevices.getDevice(child = (UsbDevice)iterator.next(), numeroSerie)) == null) {
            }
        } else if (device.getSerialNumberString() != null && device.getSerialNumberString().equalsIgnoreCase(numeroSerie)) {
            found = device;
        }
        return found;
    }

    private static void processDevice(UsbDevice device, List<USBConnectedDevice> devices) {
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            for (UsbDevice child : hub.getAttachedUsbDevices()) {
                USBConnectedDevices.processDevice(child, devices);
            }
        } else {
            try {
                USBConnectedDevices.dumpName(device, devices);
            }
            catch (Exception e) {
                System.err.println("Ignoring problematic device: " + e);
                e.printStackTrace();
            }
        }
    }

    private static void dumpName(UsbDevice device, List<USBConnectedDevice> devices) throws UnsupportedEncodingException, UsbException {
        UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
        byte iManufacturer = desc.iManufacturer();
        byte iProduct = desc.iProduct();
        if (iManufacturer == 0 || iProduct == 0) {
            return;
        }
        USBConnectedDevice us = new USBConnectedDevice();
        us.setManufacter(device.getString(iManufacturer));
        us.setProduct(device.getString(iProduct));
        us.setSerialNumber(device.getSerialNumberString());
        us.setiManufacturer(iManufacturer);
        us.setiProduct(iProduct);
        devices.add(us);
    }

    public static class USBConnectedDevice {
        private String product;
        private String manufacter;
        private String serialNumber;
        private byte iManufacturer;
        private byte iProduct;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String product) {
            this.product = product;
        }

        public String getManufacter() {
            return this.manufacter;
        }

        public void setManufacter(String manufacter) {
            this.manufacter = manufacter;
        }

        public byte getiManufacturer() {
            return this.iManufacturer;
        }

        public void setiManufacturer(byte iManufacturer) {
            this.iManufacturer = iManufacturer;
        }

        public byte getiProduct() {
            return this.iProduct;
        }

        public void setiProduct(byte iProduct) {
            this.iProduct = iProduct;
        }

        public String toString() {
            return "Fabricante: " + this.manufacter + ", Produto: " + this.product + ", Nr. S\u00c3\u00a9rie: " + this.serialNumber;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }
    }
}

