/**
 * 
 */
package org.brazilutils.br.telefone;

/**Telefone Mask List.<br>
 * <pre>
 *    --------------------> DDI - International Code
 *    |   ----------------> DDD - Regional Code
 *    |   |      ---------> Base - Phone Number
 *    |   |      | 
 *   --  ---  ------- 
 *  |  ||   ||       | 
 *  +145(032)2435-9857
 *  |   |   |    |
 *  |   |   |    |
 *  |   |   |    ---------> Base Separator - default "-"
 *  |   |   --------------> DDD End - default "("
 *  |   ------------------> DDD Begin - default ")"
 *  ----------------------> DDI Signal - default "+"
 * </pre>
 * @author Douglas Siviotti
 *
 */
public enum TelMask {
	/** Simple Brazilian Format (##)####-#### */
	BrazilianDDD("(##)####-####"),
	/**Default Format +###(###)####-####*/
	DefaultFormat("+**#(*##)*###-####"),
	/***Local Format, no codes.	 */
	LocalFormat("*###-####"),
	/**None format. */
	NullFormat("")
	;
	private String mask;
    /**
	 * @param memberCount
	 * @param baseMask
	 * @param dddMask
	 * @param ddiMask
	 */
	private TelMask(String mask){
		this.mask = mask;
	}
	public String getMask(){
		return mask;
	}
	/**
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return mask;
	}
	
}
