/**
 * 
 */
package org.brazilutils.br.uf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.brazilutils.br.uf.ie.InscricaoEstadual;
import org.brazilutils.br.uf.ie.InscricaoEstadualAC;
import org.brazilutils.br.uf.ie.InscricaoEstadualAL;
import org.brazilutils.br.uf.ie.InscricaoEstadualAM;
import org.brazilutils.br.uf.ie.InscricaoEstadualAP;
import org.brazilutils.br.uf.ie.InscricaoEstadualBA;
import org.brazilutils.br.uf.ie.InscricaoEstadualCE;
import org.brazilutils.br.uf.ie.InscricaoEstadualDF;
import org.brazilutils.br.uf.ie.InscricaoEstadualES;
import org.brazilutils.br.uf.ie.InscricaoEstadualGO;
import org.brazilutils.br.uf.ie.InscricaoEstadualMA;
import org.brazilutils.br.uf.ie.InscricaoEstadualMG;
import org.brazilutils.br.uf.ie.InscricaoEstadualMS;
import org.brazilutils.br.uf.ie.InscricaoEstadualMT;
import org.brazilutils.br.uf.ie.InscricaoEstadualPA;
import org.brazilutils.br.uf.ie.InscricaoEstadualPB;
import org.brazilutils.br.uf.ie.InscricaoEstadualPE;
import org.brazilutils.br.uf.ie.InscricaoEstadualPI;
import org.brazilutils.br.uf.ie.InscricaoEstadualPR;
import org.brazilutils.br.uf.ie.InscricaoEstadualRJ;
import org.brazilutils.br.uf.ie.InscricaoEstadualRN;
import org.brazilutils.br.uf.ie.InscricaoEstadualRO;
import org.brazilutils.br.uf.ie.InscricaoEstadualRR;
import org.brazilutils.br.uf.ie.InscricaoEstadualRS;
import org.brazilutils.br.uf.ie.InscricaoEstadualSC;
import org.brazilutils.br.uf.ie.InscricaoEstadualSE;
import org.brazilutils.br.uf.ie.InscricaoEstadualSP;
import org.brazilutils.br.uf.ie.InscricaoEstadualTO;


/**
 * @author Douglas Siviotti
 *
 */
public enum UF {
    AC("Acre", new InscricaoEstadualAC(),
			"69900000", "69999999","MZN", "NAG"),
    AL("Alagoas", new InscricaoEstadualAL(),
			"57000000", "57999999", "MUA", "MVK"),
    AM("Amazonas", new InscricaoEstadualAM(),
			"69000000", "69899999", "JWF", "JXY"),
    AP("Amap", new InscricaoEstadualAP(),
			"68900000", "68999999", "NEI", "NFB"),
    BA("Bahia", new InscricaoEstadualBA(),
			"40000000", "48999999", "JKS", "JSZ"),
    CE("Cear", new InscricaoEstadualCE(),
			"60000000", "63999999", "HTX", "HZA"),
    DF("Distrito Federal", new InscricaoEstadualDF(),
			"70000000", "73699999", "JDP", "JKR"),
    ES("ESprito Santo", new InscricaoEstadualES(),
			"29000000", "29999999", "MOX", "MTZ"),
    GO("Gois", new InscricaoEstadualGO(),
			"72800000", "76799999", "KAV", "KFC"),
    MA("Maranho", new InscricaoEstadualMA(),
			"65000000", "65999999", "HOL", "HQE"),
    MG("Minas Gerais", new InscricaoEstadualMG(),
			"30000000", "39999999", "GKJ", "HOK"),
    MS("Mato Grosso do Sul", new InscricaoEstadualMS(),
			"79000000", "79999999", "HQF", "HTW"),
    MT("Mato Grosso", new InscricaoEstadualMT(),
			"78000000", "78899999", "JXZ", "KAU"),
    PA("Par", new InscricaoEstadualPA(),
			"66000000", "68899999", "JTA", "JWE"),
    PB("Paraba", new InscricaoEstadualPB(),
			"58000000", "58999999", "MMN", "MOW"),
    PE("Pernambuco", new InscricaoEstadualPE(),
			"50000000", "56999999", "KFD", "KME"),
    PI("Piau", new InscricaoEstadualPI(),
			"64000000", "64999999", "LVF", "LWQ"),
    PR("Paran", new InscricaoEstadualPR(),
			"80000000", "87999999", "AAA", "BEZ"),
    RJ("Rio de Janeiro", new InscricaoEstadualRJ(),
			"20000000", "28999999", "KMF", "LVE"),
    RN("Rio Grande do Norte", new InscricaoEstadualRN(),
			"59000000", "59999999", "MXH", "MZM"),
    RO("Rondnia", new InscricaoEstadualRO(),
			"78900000", "78999999", "NBB", "NEH"),
    RR("Roraima", new InscricaoEstadualRR(),
			"69300000", "69399999", "NAH", "NBA"),
    RS("Rio Grande do Sul", new InscricaoEstadualRS(),
			"90000000", "99999999", "IAQ", "JDO"),
    SC("Santa Catarina", new InscricaoEstadualSC(),
			"88000000", "89999999", "LWR", "MMM"),
    SE("Sergipe", new InscricaoEstadualSE(),
			"49000000", "49999999", "HZB", "IAP"),
    SP("So Paulo", new InscricaoEstadualSP(),
			"01000000", "19999999", "BFA", "GKI"),
    TO("Tocantins", new InscricaoEstadualTO(),
			"77000000", "77999999", "MVL", "MXG")
    ;
	// PRIVATE
	private String firstCep;
	private String firstPlaca;
	private InscricaoEstadual inscricaoEstadual;
	private String lastCep;
	private String lastPlaca;
	private String ufName;
	/**Private Constructor.<p>
	 * @param ufName State Name
	 * @param ie InscricaoEstadual
	 * @param firstCep Fisrt Ce Number
	 * @param lastCep Last Cep Number
	 * @param firstPlaca Fisrt Placa Letters
	 * @param lastPlaca Last Placa Letters
	 */
	private UF(String ufName, InscricaoEstadual ie, 
			String firstCep, String lastCep, 
			String firstPlaca, String lastPlaca){
		this.ufName = ufName;
		this.inscricaoEstadual = ie;
		this.firstCep = firstCep;
		this.lastCep = lastCep;
		this.firstPlaca = firstPlaca;
		this.lastPlaca = lastPlaca;
	}
	
	/**Test the Cep Range.<p>
	 * Double Range: AM, DF and GO!
	 * Cep Range:<br>
	<TABLE BORDER=1>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>AC</TD>
	<TD DIR=LTR ALIGN=LEFT>69900000</TD>
	<TD DIR=LTR ALIGN=LEFT>69999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>AL</TD>
	<TD DIR=LTR ALIGN=LEFT>57000000</TD>
	<TD DIR=LTR ALIGN=LEFT>57999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>AM</TD>
	<TD DIR=LTR ALIGN=LEFT>69000000</TD>
	<TD DIR=LTR ALIGN=LEFT>69299999</TD>
	</TR>	
	<TR>
	<TD DIR=LTR ALIGN=LEFT>AM</TD>
	<TD DIR=LTR ALIGN=LEFT>69400000</TD>
	<TD DIR=LTR ALIGN=LEFT>69899999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>AP</TD>
	<TD DIR=LTR ALIGN=LEFT>68900000</TD>
	<TD DIR=LTR ALIGN=LEFT>68999999</TD>
	</TR>
	<TR>	
	<TD DIR=LTR ALIGN=LEFT>BA</TD>
	<TD DIR=LTR ALIGN=LEFT>40000000</TD>
	<TD DIR=LTR ALIGN=LEFT>48999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>CE</TD>
	<TD DIR=LTR ALIGN=LEFT>60000000</TD>
	<TD DIR=LTR ALIGN=LEFT>63999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>DF</TD>
	<TD DIR=LTR ALIGN=LEFT>70000000</TD>
	<TD DIR=LTR ALIGN=LEFT>72799999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>DF</TD>
	<TD DIR=LTR ALIGN=LEFT>73000000</TD>
	<TD DIR=LTR ALIGN=LEFT>73699999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>ES</TD>
	<TD DIR=LTR ALIGN=LEFT>29000000</TD>
	<TD DIR=LTR ALIGN=LEFT>29999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>GO</TD>
	<TD DIR=LTR ALIGN=LEFT>72800000</TD>
	<TD DIR=LTR ALIGN=LEFT>72999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>GO</TD>
	<TD DIR=LTR ALIGN=LEFT>73700000</TD>
	<TD DIR=LTR ALIGN=LEFT>76799999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>MA</TD>
	<TD DIR=LTR ALIGN=LEFT>65000000</TD>
	<TD DIR=LTR ALIGN=LEFT>65999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>MG</TD>
	<TD DIR=LTR ALIGN=LEFT>30000000</TD>
	<TD DIR=LTR ALIGN=LEFT>39999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>MS</TD>
	<TD DIR=LTR ALIGN=LEFT>79000000</TD>
	<TD DIR=LTR ALIGN=LEFT>79999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>MT</TD>
	<TD DIR=LTR ALIGN=LEFT>78000000</TD>
	<TD DIR=LTR ALIGN=LEFT>78899999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>PA</TD>
	<TD DIR=LTR ALIGN=LEFT>66000000</TD>
	<TD DIR=LTR ALIGN=LEFT>68899999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>PB</TD>
	<TD DIR=LTR ALIGN=LEFT>58000000</TD>
	<TD DIR=LTR ALIGN=LEFT>58999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>PE</TD>
	<TD DIR=LTR ALIGN=LEFT>50000000</TD>
	<TD DIR=LTR ALIGN=LEFT>56999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>PI</TD>
	<TD DIR=LTR ALIGN=LEFT>64000000</TD>
	<TD DIR=LTR ALIGN=LEFT>64999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>PR</TD>
	<TD DIR=LTR ALIGN=LEFT>80000000</TD>
	<TD DIR=LTR ALIGN=LEFT>87999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>RJ</TD>
	<TD DIR=LTR ALIGN=LEFT>20000000</TD>
	<TD DIR=LTR ALIGN=LEFT>28999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>RN</TD>
	<TD DIR=LTR ALIGN=LEFT>59000000</TD>
	<TD DIR=LTR ALIGN=LEFT>59999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>RO</TD>
	<TD DIR=LTR ALIGN=LEFT>78900000</TD>
	<TD DIR=LTR ALIGN=LEFT>78999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>RR</TD>
	<TD DIR=LTR ALIGN=LEFT>69300000</TD>
	<TD DIR=LTR ALIGN=LEFT>69399999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>RS</TD>
	<TD DIR=LTR ALIGN=LEFT>90000000</TD>
	<TD DIR=LTR ALIGN=LEFT>99999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>SC</TD>
	<TD DIR=LTR ALIGN=LEFT>88000000</TD>
	<TD DIR=LTR ALIGN=LEFT>89999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>SE</TD>
	<TD DIR=LTR ALIGN=LEFT>49000000</TD>
	<TD DIR=LTR ALIGN=LEFT>49999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>SP</TD>
	<TD DIR=LTR ALIGN=LEFT>01000000</TD>
	<TD DIR=LTR ALIGN=LEFT>19999999</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>TO</TD>
	<TD DIR=LTR ALIGN=LEFT>77000000</TD>
	<TD DIR=LTR ALIGN=LEFT>77999999</TD>
	</TR>
	</TABLE>
	 * @param cep
	 * @return
	 */
	public boolean cepMatches(String cep){
		cep = cep.replaceAll("[^0-9]*", "");
		if (cep != null && cep.length() == 8){
			long cepNum = Long.parseLong(cep);
			long first = Long.parseLong(firstCep);
			long last = Long.parseLong(lastCep);			
			if (this == UF.AM) {
				return 
				(cepNum >= first && cepNum <= 69299999)	||
				(cepNum >= 69400000 && cepNum <= last);
			} else if (this == UF.DF){
				return 
				(cepNum >= first && cepNum <= 72799999)	||
				(cepNum >= 73000000 && cepNum <= last);				
			} else if (this == UF.GO){
				return 
				(cepNum >= first && cepNum <= 72999999)	||
				(cepNum >= 73700000 && cepNum <= last);				
			} else {
				return (cepNum >= first && cepNum <= last);
			}
		} else {
			return false;
		}
		
	}
	
	/**
	 * @return Returns the inscricaoEstadual.
	 */
	public InscricaoEstadual getInscricaoEstadual() {
		return inscricaoEstadual;
	}
	
	/**State/UF Nam.<p>
	 * @return Returns the Uf Name.
	 */
	public String getUfName() {
		return ufName;
	}
	
	/**Test Placa Range.<p>
	 * Placa Range:<br>
	<TABLE BORDER=1>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Acre</TD>
	<TD DIR=LTR ALIGN=LEFT>MZN</TD>
	<TD DIR=LTR ALIGN=LEFT>NAG</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Alagoas</TD>
	<TD DIR=LTR ALIGN=LEFT>MUA</TD>
	<TD DIR=LTR ALIGN=LEFT>MVK</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Amap</TD>
	<TD DIR=LTR ALIGN=LEFT>NEI</TD>
	<TD DIR=LTR ALIGN=LEFT>NFB</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Amazonas</TD>
	<TD DIR=LTR ALIGN=LEFT>JWF</TD>
	<TD DIR=LTR ALIGN=LEFT>JXY</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Bahia</TD>
	<TD DIR=LTR ALIGN=LEFT>JKS</TD>
	<TD DIR=LTR ALIGN=LEFT>JSZ</TD>
	</TR>
	<TR>	
	<TD DIR=LTR ALIGN=LEFT>Cear</TD>
	<TD DIR=LTR ALIGN=LEFT>HTX</TD>
	<TD DIR=LTR ALIGN=LEFT>HZA</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Distrito Federal</TD>
	<TD DIR=LTR ALIGN=LEFT>JDP</TD>
	<TD DIR=LTR ALIGN=LEFT>JKR</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Esprito Santo</TD>	
	<TD DIR=LTR ALIGN=LEFT>MOX</TD>
	<TD DIR=LTR ALIGN=LEFT>MTZ</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Gois</TD>
	<TD DIR=LTR ALIGN=LEFT>KAV</TD>
	<TD DIR=LTR ALIGN=LEFT>KFC</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Maranho</TD>
	<TD DIR=LTR ALIGN=LEFT>HOL</TD>	
	<TD DIR=LTR ALIGN=LEFT>HQE</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Mato Grosso</TD>
	<TD DIR=LTR ALIGN=LEFT>JXZ</TD>
	<TD DIR=LTR ALIGN=LEFT>KAU</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Mato Grosso do Sul</TD>
	<TD DIR=LTR ALIGN=LEFT>HQF</TD>
	<TD DIR=LTR ALIGN=LEFT>HTW</TD>	
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Minas Gerais</TD>
	<TD DIR=LTR ALIGN=LEFT>GKJ</TD>
	<TD DIR=LTR ALIGN=LEFT>HOK</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Par</TD>
	<TD DIR=LTR ALIGN=LEFT>JTA</TD>
	<TD DIR=LTR ALIGN=LEFT>JWE</TD>
	</TR>	
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Paraba</TD>
	<TD DIR=LTR ALIGN=LEFT>MMN</TD>
	<TD DIR=LTR ALIGN=LEFT>MOW</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Paran</TD>
	<TD DIR=LTR ALIGN=LEFT>AAA</TD>
	<TD DIR=LTR ALIGN=LEFT>BEZ</TD>
	</TR>
	<TR>	
	<TD DIR=LTR ALIGN=LEFT>Pernambuco</TD>
	<TD DIR=LTR ALIGN=LEFT>KFD</TD>
	<TD DIR=LTR ALIGN=LEFT>KME</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Piau</TD>
	<TD DIR=LTR ALIGN=LEFT>LVF</TD>
	<TD DIR=LTR ALIGN=LEFT>LWQ</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Rio de Janeiro</TD>	
	<TD DIR=LTR ALIGN=LEFT>KMF</TD>
	<TD DIR=LTR ALIGN=LEFT>LVE</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Rio Grande do Norte</TD>
	<TD DIR=LTR ALIGN=LEFT>MXH</TD>
	<TD DIR=LTR ALIGN=LEFT>MZM</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Rio Grande do Sul</TD>
	<TD DIR=LTR ALIGN=LEFT>IAQ</TD>
	<TD DIR=LTR ALIGN=LEFT>JDO</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Rondnia</TD>
	<TD DIR=LTR ALIGN=LEFT>NBB</TD>
	<TD DIR=LTR ALIGN=LEFT>NEH</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Roraima</TD>
	<TD DIR=LTR ALIGN=LEFT>NAH</TD>
	<TD DIR=LTR ALIGN=LEFT>NBA</TD>	
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Santa Catarina</TD>
	<TD DIR=LTR ALIGN=LEFT>LWR</TD>
	<TD DIR=LTR ALIGN=LEFT>MMM</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>So Paulo</TD>
	<TD DIR=LTR ALIGN=LEFT>BFA</TD>
	<TD DIR=LTR ALIGN=LEFT>GKI</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Sergipe</TD>
	<TD DIR=LTR ALIGN=LEFT>HZB</TD>
	<TD DIR=LTR ALIGN=LEFT>IAP</TD>
	</TR>
	<TR>
	<TD DIR=LTR ALIGN=LEFT>Tocantins</TD>
	<TD DIR=LTR ALIGN=LEFT>MVL</TD>
	<TD DIR=LTR ALIGN=LEFT>MXG</TD>
	</TR>
	</TABLE>
	 * @param placa
	 * @return
	 */
	public boolean placaMatches(String placa){	
		placa = placa.toUpperCase();
		Pattern p = Pattern.compile("[A-Z]{3}-?[0-9]{4}");
		Matcher m = p.matcher(placa);
		if (m.find()) {
			String S = placa.replaceAll("[^A-Z]*","");						
			return (S.compareToIgnoreCase(firstPlaca)>= 0  && 
					S.compareToIgnoreCase(lastPlaca) <= 0 );			
		} else {
			return false;
		}		
	}
}
