/*
 * Created on 08/05/2005
 */
package org.brazilutils.test;

import junit.framework.TestCase;

import org.brazilutils.br.uf.UF;
import org.brazilutils.br.uf.ie.InscricaoEstadual;

/**
 * @author Douglas Siviotti
 */
public class UFInscricaoEstadualTest extends TestCase {

    public void testUfName() throws Exception {
        UF uf = null;
		//uf = UF.AC; // cria direto ou ...
		uf = UF.valueOf("AC"); // Cria a UF a partir da Sigla
		assertTrue(uf.getUfName().equals("Acre"));
		assertTrue(uf.toString().equals("AC"));
    }

	public void testUfInscricaoEstadual() throws Exception {
        UF uf = null;
		//uf = UF.AC; // cria direto ou ...
		uf = UF.valueOf("AC"); // Cria a UF a partir da Sigla		 
        uf.getInscricaoEstadual().setNumber("01.004.823/001-12");
        assertTrue(uf.getInscricaoEstadual().isValid());
        // SP
        uf = UF.SP;
        InscricaoEstadual ie = uf.getInscricaoEstadual();
        ie.setNumber("110.042.490.114");
        assertTrue(ie.isValid());
        // MG
        ie = UF.MG.getInscricaoEstadual();
        ie.setNumber("062.307.904/0081");
        assertTrue(ie.isValid());
    }
    
}
