/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.CNPJFormatter;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.CNPJError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CNPJValidator
implements Validator<String> {
    public static final Pattern FORMATED = Pattern.compile("(\\d{2})[.](\\d{3})[.](\\d{3})/(\\d{4})-(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{2})(\\d{3})(\\d{3})(\\d{4})(\\d{2})");
    private boolean isFormatted = false;
    private boolean isIgnoringRepeatedDigits;
    private MessageProducer messageProducer;

    public CNPJValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public CNPJValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.messageProducer = new SimpleMessageProducer();
    }

    public CNPJValidator(boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
        this.messageProducer = new SimpleMessageProducer();
    }

    public CNPJValidator(MessageProducer messageProducer, boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.messageProducer = messageProducer;
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
    }

    public CNPJValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.messageProducer = messageProducer;
        this.isFormatted = isFormatted;
    }

    public CNPJValidator(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    private List<ValidationMessage> getInvalidValues(String cnpj) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (cnpj != null) {
            String digitosCalculados;
            if (this.isFormatted != FORMATED.matcher(cnpj).matches()) {
                errors.add(this.messageProducer.getMessage(CNPJError.INVALID_FORMAT));
            }
            String unformatedCNPJ = null;
            try {
                unformatedCNPJ = new CNPJFormatter().unformat(cnpj);
            }
            catch (IllegalArgumentException e) {
                errors.add(this.messageProducer.getMessage(CNPJError.INVALID_DIGITS));
                return errors;
            }
            if (unformatedCNPJ.length() != 14 || !unformatedCNPJ.matches("[0-9]*")) {
                errors.add(this.messageProducer.getMessage(CNPJError.INVALID_DIGITS));
            }
            if (!this.isIgnoringRepeatedDigits && this.hasAllRepeatedDigits(unformatedCNPJ)) {
                errors.add(this.messageProducer.getMessage(CNPJError.REPEATED_DIGITS));
            }
            String cnpjSemDigito = unformatedCNPJ.substring(0, unformatedCNPJ.length() - 2);
            String digitos = unformatedCNPJ.substring(unformatedCNPJ.length() - 2);
            if (!digitos.equals(digitosCalculados = this.calculaDigitos(cnpjSemDigito))) {
                errors.add(this.messageProducer.getMessage(CNPJError.INVALID_CHECK_DIGITS));
            }
        }
        return errors;
    }

    private String calculaDigitos(String cnpjSemDigito) {
        DigitoPara digitoPara = new DigitoPara(cnpjSemDigito);
        digitoPara.complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11);
        String digito1 = digitoPara.calcula();
        digitoPara.addDigito(digito1);
        String digito2 = digitoPara.calcula();
        return digito1 + digito2;
    }

    @Override
    public boolean isEligible(String value) {
        if (value == null) {
            return false;
        }
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cnpj) {
        List<ValidationMessage> errors = this.getInvalidValues(cnpj);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cnpj) {
        return this.getInvalidValues(cnpj);
    }

    @Override
    public String generateRandomValid() {
        String cnpjSemDigitos = new DigitoGenerator().generate(12);
        String cnpjComDigitos = cnpjSemDigitos + this.calculaDigitos(cnpjSemDigitos);
        if (this.isFormatted) {
            return new CNPJFormatter().format(cnpjComDigitos);
        }
        return cnpjComDigitos;
    }

    private boolean hasAllRepeatedDigits(String cnpj) {
        for (int i = 1; i < cnpj.length(); ++i) {
            if (cnpj.charAt(i) == cnpj.charAt(0)) continue;
            return false;
        }
        return true;
    }
}

