/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.TituloEleitoralFormatter;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.TituloEleitoralError;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class TituloEleitoralValidator
implements Validator<String> {
    public static final Pattern FORMATED = Pattern.compile("(\\d{10})/(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{10})(\\d{2})");
    private boolean isFormatted = false;
    private MessageProducer messageProducer;

    public TituloEleitoralValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public TituloEleitoralValidator(boolean isFormatted) {
        this.messageProducer = new SimpleMessageProducer();
        this.isFormatted = isFormatted;
    }

    public TituloEleitoralValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.messageProducer = messageProducer;
        this.isFormatted = isFormatted;
    }

    public TituloEleitoralValidator(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    private List<ValidationMessage> getInvalidValues(String tituloDeEleitor) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (tituloDeEleitor != null) {
            if (this.isFormatted && !FORMATED.matcher(tituloDeEleitor).matches()) {
                errors.add(this.messageProducer.getMessage(TituloEleitoralError.INVALID_FORMAT));
            }
            String unformatedTitulo = null;
            try {
                unformatedTitulo = new TituloEleitoralFormatter().unformat(tituloDeEleitor);
            }
            catch (IllegalArgumentException e) {
                errors.add(this.messageProducer.getMessage(TituloEleitoralError.INVALID_DIGITS));
                return errors;
            }
            if (unformatedTitulo.length() != 12 || !unformatedTitulo.matches("[0-9]*")) {
                errors.add(this.messageProducer.getMessage(TituloEleitoralError.INVALID_DIGITS));
            }
            if (this.hasCodigoDeEstadoInvalido(unformatedTitulo)) {
                errors.add(this.messageProducer.getMessage(TituloEleitoralError.INVALID_CODIGO_DE_ESTADO));
            } else {
                String digitosCalculados;
                String tituloSemDigito = unformatedTitulo.substring(0, unformatedTitulo.length() - 2);
                String digitos = unformatedTitulo.substring(unformatedTitulo.length() - 2);
                if (!digitos.equals(digitosCalculados = this.calculaDigitos(tituloSemDigito))) {
                    errors.add(this.messageProducer.getMessage(TituloEleitoralError.INVALID_CHECK_DIGITS));
                }
            }
        }
        return errors;
    }

    private String calculaDigitos(String tituloSemDigito) {
        int length = tituloSemDigito.length();
        String sequencial = tituloSemDigito.substring(0, length - 2);
        String digito1 = new DigitoPara(sequencial).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11).calcula();
        String codigoEstado = tituloSemDigito.substring(length - 2, length);
        String digito2 = new DigitoPara(codigoEstado + digito1).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11).calcula();
        return digito1 + digito2;
    }

    private boolean hasCodigoDeEstadoInvalido(String tituloDeEleitor) {
        int codigo = Integer.parseInt(tituloDeEleitor.substring(tituloDeEleitor.length() - 4, tituloDeEleitor.length() - 2));
        return codigo < 1 || codigo > 28;
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String tituloDeEleitor) {
        List<ValidationMessage> errors = this.getInvalidValues(tituloDeEleitor);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String tituloDeEleitor) {
        return this.getInvalidValues(tituloDeEleitor);
    }

    @Override
    public String generateRandomValid() {
        String digitosSequenciais = new DigitoGenerator().generate(8);
        String digitosEstado = String.format("%02d", new Random().nextInt(28) + 1);
        String tituloSemDigito = digitosSequenciais + digitosEstado;
        String tituloComDigito = tituloSemDigito + this.calculaDigitos(tituloSemDigito);
        if (this.isFormatted) {
            return new TituloEleitoralFormatter().format(tituloComDigito);
        }
        return tituloComDigito;
    }
}

