/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer.config;

import jakarta.mail.Session;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TransportStrategy {
    SMTP{
        private static final int DEFAULT_SMTP_PORT = 25;
        private static final boolean DEFAULT_OPPORTUNISTIC_TLS = true;
        @Nullable
        private Boolean opportunisticTLS;

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            if (Preconditions.verifyNonnullOrEmpty(ConfigLoader.valueOrPropertyAsBoolean(this.opportunisticTLS, ConfigLoader.Property.OPPORTUNISTIC_TLS, true)).booleanValue()) {
                LOGGER.debug("Opportunistic TLS mode enabled for SMTP plain protocol.");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.required", "false");
            }
            return props;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            return "mail.smtp.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            return "mail.smtp.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            return "mail.smtp.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            return "mail.smtp.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            return "mail.smtp.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            return "mail.smtp.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            return "mail.smtp.ssl.trust";
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            throw new IllegalStateException("This property is not relevant for plain SMTP");
        }

        @Override
        public void setOpportunisticTLS(@Nullable Boolean opportunisticTLS) {
            this.opportunisticTLS = opportunisticTLS;
        }

        @Override
        public int getDefaultServerPort() {
            return 25;
        }
    }
    ,
    SMTPS{
        private static final int DEFAULT_SMTPS_PORT = 465;

        @Override
        public Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.put("mail.transport.protocol", "smtps");
            properties.put("mail.smtps.quitwait", "false");
            return properties;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtps.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtps.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtps.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtps.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            return "mail.smtps.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            return "mail.smtps.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            return "mail.smtps.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            return "mail.smtps.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            return "mail.smtps.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            return "mail.smtps.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            return "mail.smtps.ssl.trust";
        }

        @Override
        public int getDefaultServerPort() {
            return 465;
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            return "mail.smtps.ssl.checkserveridentity";
        }
    }
    ,
    SMTP_TLS{
        private static final int DEFAULT_SMTP_TLS_PORT = 587;

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
            return props;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }

        @Override
        public String propertyNameSocksHost() {
            return "mail.smtp.socks.host";
        }

        @Override
        public String propertyNameSocksPort() {
            return "mail.smtp.socks.port";
        }

        @Override
        public String propertyNameConnectionTimeout() {
            return "mail.smtp.connectiontimeout";
        }

        @Override
        public String propertyNameTimeout() {
            return "mail.smtp.timeout";
        }

        @Override
        public String propertyNameWriteTimeout() {
            return "mail.smtp.writetimeout";
        }

        @Override
        public String propertyNameEnvelopeFrom() {
            return "mail.smtp.from";
        }

        @Override
        public String propertyNameSSLTrust() {
            return "mail.smtp.ssl.trust";
        }

        @Override
        public int getDefaultServerPort() {
            return 587;
        }

        @Override
        public String propertyNameCheckServerIdentity() {
            return "mail.smtp.ssl.checkserveridentity";
        }
    };

    private static final Logger LOGGER;
    private static final String TRANSPORT_STRATEGY_MARKER = "simplejavamail.transportstrategy";

    public Properties generateProperties() {
        Properties properties = new Properties();
        properties.put(TRANSPORT_STRATEGY_MARKER, this.name());
        return properties;
    }

    public abstract String propertyNameHost();

    public abstract String propertyNamePort();

    public abstract String propertyNameUsername();

    public abstract String propertyNameAuthenticate();

    public abstract String propertyNameSocksHost();

    public abstract String propertyNameSocksPort();

    public abstract String propertyNameConnectionTimeout();

    public abstract String propertyNameWriteTimeout();

    public abstract String propertyNameTimeout();

    public abstract String propertyNameEnvelopeFrom();

    public abstract String propertyNameSSLTrust();

    public abstract String propertyNameCheckServerIdentity();

    public abstract int getDefaultServerPort();

    public void setOpportunisticTLS(@Nullable Boolean opportunisticTLS) {
    }

    @Nullable
    public static TransportStrategy findStrategyForSession(Session session) {
        String transportStrategyMarker = session.getProperty(TRANSPORT_STRATEGY_MARKER);
        if (transportStrategyMarker != null) {
            return TransportStrategy.valueOf(transportStrategyMarker);
        }
        return null;
    }

    public String toString(Properties properties) {
        return String.format("session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)", new Object[]{properties.get(this.propertyNameHost()), properties.get(this.propertyNamePort()), properties.get(this.propertyNameUsername()), properties.get(this.propertyNameAuthenticate()), this});
    }

    static {
        LOGGER = LoggerFactory.getLogger(TransportStrategy.class);
    }
}

