/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIconName;
import java.lang.reflect.ParameterizedType;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.text.Text;

public abstract class GlyphIcon<T extends Enum<T>>
extends Text {
    public static final String DEFAULT_ICON_SIZE = "16.0";
    public static final String DEFAULT_FONT_SIZE = "1em";
    private StringProperty glyphStyleClass;
    private StringProperty size;
    private StringProperty glyphStyle;
    private StringProperty iconName;
    private final Class<T> typeOfT = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @FXML
    public void init() {
    }

    public GlyphIcon() {
        this.setGlyphStyleClass(null);
    }

    public final StringProperty glyphStyleClassProperty() {
        if (this.glyphStyleClass == null) {
            this.glyphStyleClass = new SimpleStringProperty();
        }
        return this.glyphStyleClass;
    }

    public final String getGlyphStyleClass() {
        return this.glyphStyleClassProperty().getValue();
    }

    public final void setGlyphStyleClass(String styleClass) {
        this.glyphStyleClassProperty().setValue(styleClass);
        this.getStyleClass().add((Object)styleClass);
    }

    public final GlyphIcon glyphStyleClass(String styleClass) {
        this.setGlyphStyleClass(styleClass);
        return this;
    }

    public final StringProperty glyphStyleProperty() {
        if (this.glyphStyle == null) {
            this.glyphStyle = new SimpleStringProperty("");
        }
        return this.glyphStyle;
    }

    public final String getGlyphStyle() {
        return this.glyphStyleProperty().getValue();
    }

    public final void setGlyphStyle(String style) {
        this.glyphStyleProperty().setValue(style);
        this.updateStyle();
    }

    public final GlyphIcon style(String style) {
        this.setGlyphStyle(style);
        return this;
    }

    private GlyphIconName getGlyphIconName() {
        return (GlyphIconName)Enum.valueOf(this.typeOfT, this.getIconName());
    }

    private void updateStyle() {
        this.setText(this.getGlyphIconName().characterToString());
        String style = String.format("-fx-font-family: %s; -fx-font-size: %s; %s", this.getGlyphIconName().getFontFamily(), this.getSize(), this.getGlyphStyle());
        this.setStyle(style);
    }

    public final StringProperty sizeProperty() {
        if (this.size == null) {
            this.size = new SimpleStringProperty(DEFAULT_FONT_SIZE);
        }
        return this.size;
    }

    public final String getSize() {
        return this.sizeProperty().getValue();
    }

    public final void setSize(String size) {
        size = size == null || size.isEmpty() ? DEFAULT_FONT_SIZE : size;
        this.sizeProperty().setValue(size);
        this.updateStyle();
    }

    public final GlyphIcon size(String iconSize) {
        this.setSize(iconSize);
        return this;
    }

    public final StringProperty iconNameProperty() {
        if (this.iconName == null) {
            this.iconName = new SimpleStringProperty("");
        }
        return this.iconName;
    }

    public final String getIconName() {
        return this.iconNameProperty().getValue();
    }

    public final void setIconName(String iconName) {
        this.iconNameProperty().setValue(iconName);
        this.updateStyle();
    }

    public final void setIcon(GlyphIconName icon) {
        this.setIconName(icon.name());
    }
}

