/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.DirectionsApiRequest;
import com.google.maps.GeoApiContext;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.DirectionsRoute;
import com.google.maps.model.GeocodedWaypoint;

public class DirectionsApi {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/directions/json");

    private DirectionsApi() {
    }

    public static DirectionsApiRequest newRequest(GeoApiContext context) {
        return new DirectionsApiRequest(context);
    }

    public static DirectionsApiRequest getDirections(GeoApiContext context, String origin, String destination) {
        return new DirectionsApiRequest(context).origin(origin).destination(destination);
    }

    public static enum RouteRestriction implements StringJoin.UrlValue
    {
        TOLLS("tolls"),
        HIGHWAYS("highways"),
        FERRIES("ferries");

        private final String restriction;

        private RouteRestriction(String restriction) {
            this.restriction = restriction;
        }

        public String toString() {
            return this.restriction;
        }

        @Override
        public String toUrlValue() {
            return this.restriction;
        }
    }

    static class Response
    implements ApiResponse<DirectionsResult> {
        public String status;
        public String errorMessage;
        public GeocodedWaypoint[] geocodedWaypoints;
        public DirectionsRoute[] routes;

        Response() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public DirectionsResult getResult() {
            DirectionsResult result = new DirectionsResult();
            result.geocodedWaypoints = this.geocodedWaypoints;
            result.routes = this.routes;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

