/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.GeolocationApiRequest;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.GeolocationPayload;
import com.google.maps.model.GeolocationResult;
import com.google.maps.model.LatLng;

public class GeolocationApi {
    private static final String API_BASE_URL = "https://www.googleapis.com";
    static final ApiConfig GEOLOCATION_API_CONFIG = new ApiConfig("/geolocation/v1/geolocate").hostName("https://www.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY).requestVerb("POST");

    private GeolocationApi() {
    }

    public static PendingResult<GeolocationResult> geolocate(GeoApiContext context, GeolocationPayload payload) {
        return new GeolocationApiRequest(context).Payload(payload).CreatePayload();
    }

    public static GeolocationApiRequest newRequest(GeoApiContext context) {
        return new GeolocationApiRequest(context);
    }

    public static class Response
    implements ApiResponse<GeolocationResult> {
        public int code = 200;
        public String message = "OK";
        public double accuracy = -1.0;
        public LatLng location = null;
        public String domain = null;
        public String reason = null;
        public String debugInfo = null;

        @Override
        public boolean successful() {
            return this.code == 200;
        }

        @Override
        public GeolocationResult getResult() {
            GeolocationResult result = new GeolocationResult();
            result.accuracy = this.accuracy;
            result.location = this.location;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.reason, this.message);
        }
    }
}

