/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlTimeInput
extends HtmlInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("HH:mm");

    HtmlTimeInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) && StringUtils.isNotEmpty((CharSequence)newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValueAttribute(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                LocalTime timeValue = LocalTime.parse(this.getValueAttribute(), FORMATTER_);
                LocalTime minTime = LocalTime.parse(this.getMin(), FORMATTER_);
                return minTime.equals(timeValue) || minTime.isBefore(timeValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                LocalTime timeValue = LocalTime.parse(this.getValueAttribute(), FORMATTER_);
                LocalTime maxTime = LocalTime.parse(this.getMax(), FORMATTER_);
                return maxTime.equals(timeValue) || maxTime.isAfter(timeValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

