/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRp;
import com.gargoylesoftware.htmlunit.html.HtmlRt;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSvg;
import com.gargoylesoftware.htmlunit.html.HtmlUnknownElement;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.FontFaceSet;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeIterator;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Range;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TreeWalker;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathResult;
import com.gargoylesoftware.htmlunit.javascript.host.event.BeforeUnloadEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.CloseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.CompositionEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.CustomEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.DragEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.FocusEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.HashChangeEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseWheelEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MutationEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PopStateEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.ProgressEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.SVGZoomEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.TextEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.WheelEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAllCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAnchorElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFrameSetElement;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.traversal.NodeFilter;

@JsxClass
public class Document
extends Node {
    private static final Log LOG = LogFactory.getLog(Document.class);
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("\\w+");
    private static final Set<String> EXECUTE_CMDS_IE = new HashSet<String>();
    private static final Set<String> EXECUTE_CMDS_FF = new HashSet<String>();
    private static final Set<String> EXECUTE_CMDS_CHROME = new HashSet<String>();
    private static final String LAST_MODIFIED_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM2_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM3_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_VENDOR_EVENT_TYPE_MAP;
    private static final AtomicInteger UniqueID_Counter_;
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;
    private String compatMode_;
    private int documentMode_ = -1;
    private String uniqueID_;
    private String domain_;
    private String lastModified_;
    private ScriptableObject currentScript_;
    private transient FontFaceSet fonts_;
    private transient StyleSheetList styleSheetList_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Document() {
    }

    public void setWindow(Window window) {
        this.window_ = window;
    }

    @JsxGetter
    public Location getLocation() {
        if (this.window_ == null) {
            return null;
        }
        return this.window_.getLocation();
    }

    @JsxSetter
    public void setLocation(String location) throws IOException {
        Object target;
        Object event = this.getWindow().getEvent();
        if (event instanceof UIEvent && (target = ((UIEvent)event).getTarget()) instanceof HTMLAnchorElement) {
            String string = ((HTMLAnchorElement)target).getHref();
        }
        this.window_.setLocation(location);
    }

    @JsxGetter
    public String getReferrer() {
        String referrer = "";
        WebResponse webResponse = this.getPage().getWebResponse();
        if (webResponse != null && (referrer = webResponse.getWebRequest().getAdditionalHeaders().get("Referer")) == null) {
            referrer = "";
        }
        return referrer;
    }

    @JsxGetter
    public Element getDocumentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    @JsxGetter
    public Element getRootElement() {
        return null;
    }

    @JsxGetter
    public HtmlUnitScriptable getDoctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    @JsxGetter
    public String getDesignMode() {
        if (this.designMode_ == null) {
            this.designMode_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DESIGN_MODE_INHERIT) ? "inherit" : "off";
        }
        return this.designMode_;
    }

    @JsxSetter
    public void setDesignMode(String mode) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        boolean inherit = browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DESIGN_MODE_INHERIT);
        if (inherit) {
            if (!("on".equalsIgnoreCase(mode) || "off".equalsIgnoreCase(mode) || "inherit".equalsIgnoreCase(mode))) {
                throw Context.reportRuntimeError((String)("Invalid document.designMode value '" + mode + "'."));
            }
            if ("on".equalsIgnoreCase(mode)) {
                this.designMode_ = "on";
            } else if ("off".equalsIgnoreCase(mode)) {
                this.designMode_ = "off";
            } else if ("inherit".equalsIgnoreCase(mode)) {
                this.designMode_ = "inherit";
            }
        } else if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page != null && page.isHtmlPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SELECTION_RANGE_COUNT)) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                DomNode rangeNode = child == null ? htmlPage.getBody() : child;
                htmlPage.setSelectionRange(new SimpleRange(rangeNode, 0));
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    public SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    @JsxGetter
    public Object getDefaultView() {
        return this.getWindow();
    }

    @JsxFunction
    public Object createDocumentFragment() {
        DomDocumentFragment fragment = this.getDomNodeOrDie().getPage().createDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    @JsxFunction
    public Attr createAttribute(String attributeName) {
        return (Attr)this.getPage().createAttribute(attributeName).getScriptableObject();
    }

    @JsxFunction
    public Object importNode(Node importedNode, boolean deep) {
        DomNode domNode = importedNode.getDomNodeOrDie();
        domNode = domNode.cloneNode(deep);
        domNode.processImportNode(this);
        for (DomNode childNode : domNode.getDescendants()) {
            childNode.processImportNode(this);
        }
        return domNode.getScriptableObject();
    }

    @JsxFunction
    public Object adoptNode(Node externalNode) {
        externalNode.remove();
        return this.importNode(externalNode, true);
    }

    @JsxGetter
    public DOMImplementation getImplementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope((Scriptable)this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope((Scriptable)this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public Object createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            HtmlUnitScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createComment(String comment) {
        DomComment domNode = new DomComment(this.getDomNodeOrDie().getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public XPathResult evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        PrefixResolver prefixResolver = null;
        if (resolver instanceof NativeFunction) {
            prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
        } else if (resolver instanceof PrefixResolver) {
            prefixResolver = (PrefixResolver)resolver;
        }
        xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
        return xPathResult;
    }

    @JsxFunction
    public Object createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            Matcher matcher;
            if (tagName.contains("<") || tagName.contains(">")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character; '<' and '>' are not allowed"));
                }
                throw Context.reportRuntimeError((String)"String contains an invalid character");
            }
            if (tagName.length() > 0 && tagName.charAt(0) == '<' && tagName.endsWith(">") && !(matcher = TAG_NAME_PATTERN.matcher(tagName = tagName.substring(1, tagName.length() - 1))).matches()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character"));
                }
                throw Context.reportRuntimeError((String)"String contains an invalid character");
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            if (element instanceof HtmlInput) {
                ((HtmlInput)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlImage) {
                ((HtmlImage)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRp) {
                ((HtmlRp)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRt) {
                ((HtmlRt)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlUnknownElement) {
                ((HtmlUnknownElement)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlSvg) {
                element = UnknownElementFactory.instance.createElementNS(page, "", "svg", null);
                ((HtmlUnknownElement)element).markAsCreatedByJavascript();
            }
            HtmlUnitScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createElementNS(String namespaceURI, String qualifiedName) {
        if ("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI)) {
            throw Context.reportRuntimeError((String)"XUL not available");
        }
        org.w3c.dom.Element element = "http://www.w3.org/1999/xhtml".equals(namespaceURI) || "http://www.w3.org/2000/svg".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null);
        return this.getScriptableFor(element);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(final String tagName) {
        HTMLCollection collection = "*".equals(tagName) ? new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagName.equalsIgnoreCase(node.getNodeName());
            }
        };
        return collection;
    }

    @JsxFunction
    public Object getElementsByTagNameNS(Object namespaceURI, final String localName) {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return localName.equals(node.getLocalName());
            }
        };
    }

    @JsxGetter
    public Object getActiveElement() {
        return null;
    }

    @JsxGetter
    public String getCharacterSet() {
        if (!(this.getPage() instanceof HtmlPage)) {
            return "";
        }
        Charset charset = this.getPage().getCharset();
        if (charset != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            return charset.name().toLowerCase(Locale.ROOT);
        }
        return EncodingSniffer.translateEncodingLabel(charset);
    }

    @JsxGetter
    public String getCharset() {
        if (!(this.getPage() instanceof HtmlPage)) {
            return "";
        }
        Charset charset = this.getPage().getCharset();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            return charset.name().toLowerCase(Locale.ROOT);
        }
        return EncodingSniffer.translateEncodingLabel(charset);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getDefaultCharset() {
        return "windows-1252";
    }

    @JsxGetter
    public Object getAnchors() {
        return new HTMLCollection(this.getDomNodeOrDie(), true){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!(node instanceof HtmlAnchor)) {
                    return false;
                }
                HtmlAnchor anchor = (HtmlAnchor)node;
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHORS_REQUIRES_NAME_OR_ID)) {
                    return anchor.hasAttribute("name") || anchor.hasAttribute("id");
                }
                return anchor.hasAttribute("name");
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName()) || "id".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
    }

    @JsxGetter
    public Object getApplets() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlApplet;
            }
        };
    }

    @JsxGetter
    public HTMLElement getBody() {
        HtmlElement body;
        SgmlPage page = this.getPage();
        if (page instanceof HtmlPage && (body = ((HtmlPage)page).getBody()) != null) {
            return (HTMLElement)body.getScriptableObject();
        }
        return null;
    }

    @JsxSetter
    public void setBody(HTMLElement htmlElement) {
        if (htmlElement instanceof HTMLBodyElement || htmlElement instanceof HTMLFrameSetElement) {
            HtmlElement body;
            SgmlPage page = this.getPage();
            if (page instanceof HtmlPage && (body = ((HtmlPage)page).getBody()) != null) {
                body.replace(htmlElement.getDomNodeOrDie());
            }
            return;
        }
        throw Context.reportRuntimeError((String)("Failed to set the 'body' property on 'Document': The new body element is of type '" + htmlElement.getTagName() + "'. It must be either a 'BODY' or 'FRAMESET' element."));
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void close() throws IOException {
    }

    @JsxGetter
    public String getCompatMode() {
        this.getDocumentMode();
        return this.compatMode_;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getDocumentMode() {
        if (this.documentMode_ != -1) {
            return this.documentMode_;
        }
        this.compatMode_ = "CSS1Compat";
        if (this.isQuirksDocType()) {
            this.compatMode_ = "BackCompat";
        }
        float version = this.getBrowserVersion().getBrowserVersionNumeric();
        this.documentMode_ = (int)Math.floor(version);
        return this.documentMode_;
    }

    private boolean isQuirksDocType() {
        DocumentType docType = this.getPage().getDoctype();
        if (docType != null) {
            String systemId = docType.getSystemId();
            if (systemId != null) {
                String publicId;
                if ("http://www.w3.org/TR/html4/strict.dtd".equals(systemId)) {
                    return false;
                }
                if ("http://www.w3.org/TR/html4/loose.dtd".equals(systemId) && "-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicId = docType.getPublicId())) {
                    return false;
                }
                if ("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(systemId) || "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd".equals(systemId)) {
                    return false;
                }
            } else if (docType.getPublicId() == null) {
                return docType.getName() == null;
            }
        }
        return true;
    }

    public void forceDocumentMode(int documentMode) {
        this.documentMode_ = documentMode;
        this.compatMode_ = documentMode == 5 ? "BackCompat" : "CSS1Compat";
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw ScriptRuntime.constructError((String)"SyntaxError", (String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction
    public boolean queryCommandSupported(String cmd) {
        return this.hasCommand(cmd, true);
    }

    private boolean hasCommand(String cmd, boolean includeBold) {
        if (null == cmd) {
            return false;
        }
        String cmdLC = cmd.toLowerCase(Locale.ROOT);
        if (this.getBrowserVersion().isIE()) {
            return EXECUTE_CMDS_IE.contains(cmdLC);
        }
        if (this.getBrowserVersion().isChrome() || this.getBrowserVersion().isEdge()) {
            return EXECUTE_CMDS_CHROME.contains(cmdLC) || includeBold && "bold".equalsIgnoreCase(cmd);
        }
        return EXECUTE_CMDS_FF.contains(cmdLC);
    }

    @JsxFunction
    public boolean queryCommandEnabled(String cmd) {
        return this.hasCommand(cmd, true);
    }

    @JsxFunction
    public boolean execCommand(String cmd, boolean userInterface, Object value) {
        if (!this.hasCommand(cmd, false)) {
            return false;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Nothing done for execCommand(" + cmd + ", ...) (feature not implemented)"));
        }
        return true;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_.getAndIncrement();
        }
        return this.uniqueID_;
    }

    @JsxGetter(propertyName="URL")
    public String getURL_js() {
        return this.getPage().getUrl().toExternalForm();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getDocumentURI() {
        return this.getURL_js();
    }

    @JsxGetter(value={SupportedBrowser.IE}, propertyName="URLUnencoded")
    public String getURLUnencoded_js() {
        return this.getURL_js();
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS)) {
            DomNode page;
            Document document = null;
            if (start instanceof DocumentProxy) {
                document = ((DocumentProxy)start).getDelegee();
            } else if (start instanceof HTMLDocument && (page = ((HTMLDocument)start).getDomNodeOrNull()) != null) {
                document = (Document)page.getScriptableObject();
            }
            if (document instanceof HTMLDocument && document.getDocumentMode() < 8) {
                return NOT_FOUND;
            }
        }
        return response;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public String getCookie() {
        return "";
    }

    @JsxFunction
    public Event createEvent(String eventType) throws DOMException {
        Class<? extends Event> clazz = SUPPORTED_DOM2_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null && CloseEvent.class == (clazz = SUPPORTED_DOM3_EVENT_TYPE_MAP.get(eventType)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLOSE_DOCUMENT_CREATE_NOT_SUPPORTED)) {
            clazz = null;
        }
        if (clazz == null && ("Events".equals(eventType) || "HashChangeEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_HASHCHANGEEVENT) || "BeforeUnloadEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_BEFOREUNLOADEVENT) || "MouseWheelEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_MOUSEWHEELEVENT) || "PointerEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_POINTEREVENT) || "PopStateEvent".equals(eventType) || "ProgressEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_PROGRESSEVENT) || "FocusEvent".equals(eventType) || "WheelEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_WHEELEVENT)) && PopStateEvent.class == (clazz = SUPPORTED_VENDOR_EVENT_TYPE_MAP.get(eventType)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONPOPSTATE_DOCUMENT_CREATE_NOT_SUPPORTED)) {
            clazz = null;
        }
        if (clazz == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(9, "Event Type is not supported: " + eventType));
            return null;
        }
        try {
            Event event = clazz.newInstance();
            event.setParentScope((Scriptable)this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            event.eventCreated();
            return event;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
    }

    @JsxFunction
    public NodeIterator createNodeIterator(Node root, int whatToShow, Scriptable filter) {
        NodeFilter filterWrapper = Document.createFilterWrapper(filter, false);
        NodeIterator iterator = new NodeIterator(this.getPage(), root, whatToShow, filterWrapper);
        iterator.setParentScope(this.getParentScope());
        iterator.setPrototype(this.getPrototype(iterator.getClass()));
        return iterator;
    }

    private static NodeFilter createFilterWrapper(Scriptable filter, boolean filterFunctionOnly) {
        NodeFilter filterWrapper = null;
        if (filter != null) {
            filterWrapper = n -> {
                Object response;
                Object[] args = new Object[]{((DomNode)n).getScriptableObject()};
                if (filter instanceof Callable) {
                    response = ((Callable)filter).call(Context.getCurrentContext(), filter, filter, args);
                } else {
                    if (filterFunctionOnly) {
                        throw Context.reportRuntimeError((String)"only a function is allowed as filter");
                    }
                    response = ScriptableObject.callMethod((Scriptable)filter, (String)"acceptNode", (Object[])args);
                }
                return (short)Context.toNumber((Object)response);
            };
        }
        return filterWrapper;
    }

    @JsxFunction
    public Object createTreeWalker(Node root, double whatToShow, Scriptable filter, boolean expandEntityReferences) throws DOMException {
        int whatToShowI = (int)Double.valueOf(whatToShow).longValue();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TREEWALKER_EXPAND_ENTITY_REFERENCES_FALSE)) {
            expandEntityReferences = false;
        }
        boolean filterFunctionOnly = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TREEWALKER_FILTER_FUNCTION_ONLY);
        NodeFilter filterWrapper = Document.createFilterWrapper(filter, filterFunctionOnly);
        TreeWalker t = new TreeWalker(this.getPage(), root, whatToShowI, filterWrapper, expandEntityReferences);
        t.setParentScope((Scriptable)Document.getWindow((Scriptable)this));
        t.setPrototype(Document.staticGetPrototype(Document.getWindow((Scriptable)this), TreeWalker.class));
        return t;
    }

    private static Scriptable staticGetPrototype(Window window, Class<? extends HtmlUnitScriptable> javaScriptClass) {
        Scriptable prototype = window.getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != HtmlUnitScriptable.class) {
            return Document.staticGetPrototype(window, javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @JsxFunction
    public Range createRange() {
        Range r = new Range(this);
        r.setParentScope((Scriptable)this.getWindow());
        r.setPrototype(this.getPrototype(Range.class));
        return r;
    }

    @JsxGetter
    public String getDomain() {
        if (this.domain_ == null && this.getPage().getWebResponse() != null) {
            URL url = this.getPage().getUrl();
            if (url == UrlUtils.URL_ABOUT_BLANK) {
                WebWindow w = this.getWindow().getWebWindow();
                if (w instanceof FrameWindow) {
                    url = ((FrameWindow)w).getEnclosingPage().getUrl();
                } else {
                    return null;
                }
            }
            this.domain_ = url.getHost().toLowerCase(Locale.ROOT);
        }
        return this.domain_;
    }

    @JsxSetter
    public void setDomain(String newDomain) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (UrlUtils.URL_ABOUT_BLANK == this.getPage().getUrl() && browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SETTING_DOMAIN_THROWS_FOR_ABOUT_BLANK)) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from \"" + UrlUtils.URL_ABOUT_BLANK + "\" to: \"" + newDomain + "\"."));
        }
        newDomain = newDomain.toLowerCase(Locale.ROOT);
        String currentDomain = this.getDomain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(46) == -1) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\" (new domain has to contain a dot)."));
        }
        if (currentDomain.indexOf(46) > -1 && !currentDomain.toLowerCase(Locale.ROOT).endsWith("." + newDomain.toLowerCase(Locale.ROOT))) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = newDomain;
    }

    @JsxSetter
    public void setOnclick(Object handler) {
        this.setEventHandler("click", handler);
    }

    @JsxGetter
    public Object getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOndblclick(Object handler) {
        this.setEventHandler("dblclick", handler);
    }

    @JsxGetter
    public Object getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOnblur(Object handler) {
        this.setEventHandler("blur", handler);
    }

    @JsxGetter
    public Object getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxSetter
    public void setOnfocus(Object handler) {
        this.setEventHandler("focus", handler);
    }

    @JsxGetter
    public Object getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusin(Object handler) {
        this.setEventHandler("focusin", handler);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getOnfocusin() {
        return this.getEventHandler("focusin");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusout(Object handler) {
        this.setEventHandler("focusout", handler);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getOnfocusout() {
        return this.getEventHandler("focusout");
    }

    @JsxSetter
    public void setOnkeydown(Object handler) {
        this.setEventHandler("keydown", handler);
    }

    @JsxGetter
    public Object getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeypress(Object handler) {
        this.setEventHandler("keypress", handler);
    }

    @JsxGetter
    public Object getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeyup(Object handler) {
        this.setEventHandler("keyup", handler);
    }

    @JsxGetter
    public Object getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnmousedown(Object handler) {
        this.setEventHandler("mousedown", handler);
    }

    @JsxGetter
    public Object getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousemove(Object handler) {
        this.setEventHandler("mousemove", handler);
    }

    @JsxGetter
    public Object getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmouseout(Object handler) {
        this.setEventHandler("mouseout", handler);
    }

    @JsxGetter
    public Object getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseover(Object handler) {
        this.setEventHandler("mouseover", handler);
    }

    @JsxGetter
    public Object getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseup(Object handler) {
        this.setEventHandler("mouseup", handler);
    }

    @JsxGetter
    public Object getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOncontextmenu(Object handler) {
        this.setEventHandler("contextmenu", handler);
    }

    @JsxGetter
    public Object getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnresize(Object handler) {
        this.setEventHandler("resize", handler);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnerror(Object handler) {
        this.setEventHandler("error", handler);
    }

    @JsxGetter
    public Object getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxGetter
    public Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setEventHandler("input", oninput);
    }

    @JsxGetter
    public boolean getHidden() {
        return false;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getChildElementCount() {
        int counter = 0;
        if (this.getPage().getDocumentElement() != null) {
            ++counter;
        }
        return counter;
    }

    @JsxFunction
    public Object elementFromPoint(int x, int y) {
        return null;
    }

    @JsxGetter
    public Object getForms() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlForm && node.getPrefix() == null;
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED)) {
                    return super.call(cx, scope, thisObj, args);
                }
                throw ScriptRuntime.typeError((String)"document.forms is not a function");
            }
        };
    }

    @JsxGetter
    public Object getEmbeds() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlEmbed;
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED)) {
                    return super.call(cx, scope, thisObj, args);
                }
                throw ScriptRuntime.typeError((String)"document.embeds is not a function");
            }
        };
    }

    @JsxGetter
    public Object getImages() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlImage;
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED)) {
                    return super.call(cx, scope, thisObj, args);
                }
                throw ScriptRuntime.typeError((String)"document.images is not a function");
            }
        };
    }

    @JsxGetter
    public Object getScripts() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlScript;
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED)) {
                    return super.call(cx, scope, thisObj, args);
                }
                throw ScriptRuntime.typeError((String)"document.scripts is not a function");
            }
        };
    }

    @JsxGetter
    public StyleSheetList getStyleSheets() {
        if (this.styleSheetList_ == null) {
            this.styleSheetList_ = new StyleSheetList(this);
        }
        return this.styleSheetList_;
    }

    @JsxGetter
    public Object getPlugins() {
        return this.getEmbeds();
    }

    @JsxGetter
    public Object getLinks() {
        return new HTMLCollection(this.getDomNodeOrDie(), true){

            @Override
            protected boolean isMatching(DomNode node) {
                return (node instanceof HtmlAnchor || node instanceof HtmlArea) && ((HtmlElement)node).hasAttribute("href");
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                HtmlElement node = event.getHtmlElement();
                if ((node instanceof HtmlAnchor || node instanceof HtmlArea) && "href".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
    }

    @JsxFunction
    public HTMLCollection getElementsByClassName(String className) {
        return null;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public HTMLCollection getElementsByName(String elementName) {
        return null;
    }

    @JsxFunction
    public boolean hasFocus() {
        return false;
    }

    @JsxGetter
    public String getTitle() {
        return "";
    }

    @JsxSetter
    public void setTitle(String title) {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getContentType() {
        return this.getPage().getContentType();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Selection getSelection() {
        return null;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Object getHead() {
        return null;
    }

    @JsxGetter
    public String getInputEncoding() {
        Charset encoding = this.getPage().getCharset();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            return encoding.name();
        }
        return EncodingSniffer.translateEncodingLabel(encoding);
    }

    @JsxGetter
    public String getLastModified() {
        if (this.lastModified_ == null) {
            Date lastModified;
            WebResponse webResponse = this.getPage().getWebResponse();
            if (webResponse != null) {
                String stringDate = webResponse.getResponseHeaderValue("Last-Modified");
                if (stringDate == null) {
                    stringDate = webResponse.getResponseHeaderValue("Date");
                }
                lastModified = Document.parseDateOrNow(stringDate);
            } else {
                lastModified = new Date();
            }
            this.lastModified_ = new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT, Locale.ROOT).format(lastModified);
        }
        return this.lastModified_;
    }

    private static Date parseDateOrNow(String stringDate) {
        Date date = StringUtils.parseHttpDate(stringDate);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR, SupportedBrowser.IE})
    public boolean releaseCapture() {
        return true;
    }

    @JsxGetter
    public String getReadyState() {
        return this.getDomNodeOrDie().getReadyState();
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction
    public void releaseEvents(String type) {
    }

    @JsxGetter
    public String getAlinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            String color = ((HTMLBodyElement)body).getALink();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == color && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
                color = "#0000ff";
            } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
                color = "#000000";
            }
            return color;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            return "#0000ff";
        }
        return null;
    }

    @JsxSetter
    public void setAlinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setALink(color);
        }
    }

    @JsxGetter
    public String getBgColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            String color = ((HTMLBodyElement)body).getBgColor();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == color && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
                color = "#ffffff";
            } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
                color = "#000000";
            }
            return color;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            return "#ffffff";
        }
        return null;
    }

    @JsxSetter
    public void setBgColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setBgColor(color);
        }
    }

    @JsxGetter
    public String getFgColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            String color = ((HTMLBodyElement)body).getText();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == color && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
                color = "#000000";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
                color = "#000000";
            }
            return color;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            return "#000000";
        }
        return null;
    }

    @JsxSetter
    public void setFgColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setText(color);
        }
    }

    @JsxGetter
    public String getLinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            String color = ((HTMLBodyElement)body).getLink();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == color && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
                color = "#0000ff";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
                color = "#000000";
            }
            return color;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            return "#0000ff";
        }
        return null;
    }

    @JsxSetter
    public void setLinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setLink(color);
        }
    }

    @JsxGetter
    public String getVlinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            String color = ((HTMLBodyElement)body).getVLink();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == color && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
                color = "#800080";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
                color = "#000000";
            }
            return color;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            return "#800080";
        }
        return null;
    }

    @JsxSetter
    public void setVlinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setVLink(color);
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getFrames() {
        if (ScriptableObject.getTopLevelScope((Scriptable)this) == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"Not implemented");
        }
        return this.getWindow().getFrames_js();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public String getXmlEncoding() {
        String encoding = this.getPage().getXmlEncoding();
        if (encoding == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            encoding = "";
        }
        return encoding;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public boolean isXmlStandalone() {
        return this.getPage().getXmlStandalone();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public String getXmlVersion() {
        String version = this.getPage().getXmlVersion();
        if (version == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            version = "";
        }
        return version;
    }

    @JsxGetter
    public Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setEventHandler("abort", onabort);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnauxclick(Object onauxclick) {
        this.setEventHandler("auxclick", onauxclick);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecopy() {
        return this.getEventHandler("beforecopy");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecopy(Object onbeforecopy) {
        this.setEventHandler("beforecopy", onbeforecopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecut() {
        return this.getEventHandler("beforecut");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecut(Object onbeforecut) {
        this.setEventHandler("beforecut", onbeforecut);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforepaste() {
        return this.getEventHandler("beforepaste");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforepaste(Object onbeforepaste) {
        this.setEventHandler("beforepaste", onbeforepaste);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncancel(Object oncancel) {
        this.setEventHandler("cancel", oncancel);
    }

    @JsxGetter
    public Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setEventHandler("canplay", oncanplay);
    }

    @JsxGetter
    public Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setEventHandler("canplaythrough", oncanplaythrough);
    }

    @JsxGetter
    public Function getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setEventHandler("change", onchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnclose(Object onclose) {
        this.setEventHandler("close", onclose);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOncopy() {
        return this.getEventHandler("copy");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOncopy(Object oncopy) {
        this.setEventHandler("copy", oncopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncuechange(Object oncuechange) {
        this.setEventHandler("cuechange", oncuechange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOncut() {
        return this.getEventHandler("cut");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOncut(Object oncut) {
        this.setEventHandler("cut", oncut);
    }

    @JsxGetter
    public Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setEventHandler("drag", ondrag);
    }

    @JsxGetter
    public Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setEventHandler("dragend", ondragend);
    }

    @JsxGetter
    public Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setEventHandler("dragenter", ondragenter);
    }

    @JsxGetter
    public Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setEventHandler("dragleave", ondragleave);
    }

    @JsxGetter
    public Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setEventHandler("dragover", ondragover);
    }

    @JsxGetter
    public Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setEventHandler("dragstart", ondragstart);
    }

    @JsxGetter
    public Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setEventHandler("drop", ondrop);
    }

    @JsxGetter
    public Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setEventHandler("durationchange", ondurationchange);
    }

    @JsxGetter
    public Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setEventHandler("emptied", onemptied);
    }

    @JsxGetter
    public Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setEventHandler("ended", onended);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setEventHandler("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOninvalid(Object oninvalid) {
        this.setEventHandler("invalid", oninvalid);
    }

    @JsxGetter
    public Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setEventHandler("loadeddata", onloadeddata);
    }

    @JsxGetter
    public Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setEventHandler("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter
    public Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setEventHandler("loadstart", onloadstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setEventHandler("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmouseenter(Object onmouseenter) {
        this.setEventHandler("mouseenter", onmouseenter);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmouseleave(Object onmouseleave) {
        this.setEventHandler("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setEventHandler("mousewheel", onmousewheel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnpaste() {
        return this.getEventHandler("paste");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnpaste(Object onpaste) {
        this.setEventHandler("paste", onpaste);
    }

    @JsxGetter
    public Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setEventHandler("pause", onpause);
    }

    @JsxGetter
    public Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setEventHandler("play", onplay);
    }

    @JsxGetter
    public Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setEventHandler("playing", onplaying);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointercancel(Object onpointercancel) {
        this.setEventHandler("pointercancel", onpointercancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerdown(Object onpointerdown) {
        this.setEventHandler("pointerdown", onpointerdown);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerenter(Object onpointerenter) {
        this.setEventHandler("pointerenter", onpointerenter);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerleave(Object onpointerleave) {
        this.setEventHandler("pointerleave", onpointerleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnpointerlockchange() {
        return this.getEventHandler("pointerlockchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerlockchange(Object onpointerlockchange) {
        this.setEventHandler("pointerlockchange", onpointerlockchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnpointerlockerror() {
        return this.getEventHandler("pointerlockerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerlockerror(Object onpointerlockerror) {
        this.setEventHandler("pointerlockerror", onpointerlockerror);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointermove(Object onpointermove) {
        this.setEventHandler("pointermove", onpointermove);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerout(Object onpointerout) {
        this.setEventHandler("pointerout", onpointerout);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerover(Object onpointerover) {
        this.setEventHandler("pointerover", onpointerover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnpointerup(Object onpointerup) {
        this.setEventHandler("pointerup", onpointerup);
    }

    @JsxGetter
    public Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setEventHandler("progress", onprogress);
    }

    @JsxGetter
    public Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setEventHandler("ratechange", onratechange);
    }

    @JsxGetter
    public Function getOnreadystatechange() {
        return this.getEventHandler("readystatechange");
    }

    @JsxSetter
    public void setOnreadystatechange(Object onreadystatechange) {
        this.setEventHandler("readystatechange", onreadystatechange);
    }

    @JsxGetter
    public Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setEventHandler("reset", onreset);
    }

    @JsxGetter
    public Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setEventHandler("scroll", onscroll);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnsearch(Object onsearch) {
        this.setEventHandler("search", onsearch);
    }

    @JsxGetter
    public Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setEventHandler("seeked", onseeked);
    }

    @JsxGetter
    public Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setEventHandler("seeking", onseeking);
    }

    @JsxGetter
    public Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setEventHandler("select", onselect);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnselectionchange() {
        return this.getEventHandler("selectionchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnselectionchange(Object onselectionchange) {
        this.setEventHandler("selectionchange", onselectionchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnselectstart() {
        return this.getEventHandler("selectstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnselectstart(Object onselectstart) {
        this.setEventHandler("selectstart", onselectstart);
    }

    @JsxGetter
    public Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setEventHandler("stalled", onstalled);
    }

    @JsxGetter
    public Function getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandler("submit", onsubmit);
    }

    @JsxGetter
    public Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setEventHandler("suspend", onsuspend);
    }

    @JsxGetter
    public Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setEventHandler("timeupdate", ontimeupdate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOntoggle(Object ontoggle) {
        this.setEventHandler("toggle", ontoggle);
    }

    @JsxGetter
    public Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setEventHandler("volumechange", onvolumechange);
    }

    @JsxGetter
    public Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setEventHandler("waiting", onwaiting);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenchange() {
        return this.getEventHandler("webkitfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenchange(Object onwebkitfullscreenchange) {
        this.setEventHandler("webkitfullscreenchange", onwebkitfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenerror() {
        return this.getEventHandler("webkitfullscreenerror");
    }

    @JsxSetter
    public void setOnwebkitfullscreenerror(Object onwebkitfullscreenerror) {
        this.setEventHandler("webkitfullscreenerror", onwebkitfullscreenerror);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnwheel(Object onwheel) {
        this.setEventHandler("wheel", onwheel);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnafterscriptexecute() {
        return this.getEventHandler("afterscriptexecute");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnafterscriptexecute(Object onafterscriptexecute) {
        this.setEventHandler("afterscriptexecute", onafterscriptexecute);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnbeforescriptexecute() {
        return this.getEventHandler("beforescriptexecute");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnbeforescriptexecute(Object onbeforescriptexecute) {
        this.setEventHandler("beforescriptexecute", onbeforescriptexecute);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setEventHandler("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setEventHandler("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnhelp() {
        return this.getEventHandler("help");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnhelp(Object onhelp) {
        this.setEventHandler("help", onhelp);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmscontentzoom() {
        return this.getEventHandler("mscontentzoom");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmscontentzoom(Object onmscontentzoom) {
        this.setEventHandler("mscontentzoom", onmscontentzoom);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsfullscreenchange() {
        return this.getEventHandler("msfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsfullscreenchange(Object onmsfullscreenchange) {
        this.setEventHandler("msfullscreenchange", onmsfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsfullscreenerror() {
        return this.getEventHandler("msfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsfullscreenerror(Object onmsfullscreenerror) {
        this.setEventHandler("msfullscreenerror", onmsfullscreenerror);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturechange() {
        return this.getEventHandler("msgesturechange");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturechange(Object onmsgesturechange) {
        this.setEventHandler("msgesturechange", onmsgesturechange);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturedoubletap() {
        return this.getEventHandler("msgesturedoubletap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturedoubletap(Object onmsgesturedoubletap) {
        this.setEventHandler("msgesturedoubletap", onmsgesturedoubletap);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgestureend() {
        return this.getEventHandler("msgestureend");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgestureend(Object onmsgestureend) {
        this.setEventHandler("msgestureend", onmsgestureend);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturehold() {
        return this.getEventHandler("msgesturehold");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturehold(Object onmsgesturehold) {
        this.setEventHandler("msgesturehold", onmsgesturehold);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturestart() {
        return this.getEventHandler("msgesturestart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturestart(Object onmsgesturestart) {
        this.setEventHandler("msgesturestart", onmsgesturestart);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturetap() {
        return this.getEventHandler("msgesturetap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturetap(Object onmsgesturetap) {
        this.setEventHandler("msgesturetap", onmsgesturetap);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsinertiastart() {
        return this.getEventHandler("msinertiastart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsinertiastart(Object onmsinertiastart) {
        this.setEventHandler("msinertiastart", onmsinertiastart);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsmanipulationstatechanged() {
        return this.getEventHandler("msmanipulationstatechanged");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsmanipulationstatechanged(Object onmsmanipulationstatechanged) {
        this.setEventHandler("msmanipulationstatechanged", onmsmanipulationstatechanged);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointercancel() {
        return this.getEventHandler("mspointercancel");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointercancel(Object onmspointercancel) {
        this.setEventHandler("mspointercancel", onmspointercancel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerdown() {
        return this.getEventHandler("mspointerdown");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerdown(Object onmspointerdown) {
        this.setEventHandler("mspointerdown", onmspointerdown);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerenter() {
        return this.getEventHandler("mspointerenter");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerenter(Object onmspointerenter) {
        this.setEventHandler("mspointerenter", onmspointerenter);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerleave() {
        return this.getEventHandler("mspointerleave");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerleave(Object onmspointerleave) {
        this.setEventHandler("mspointerleave", onmspointerleave);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointermove() {
        return this.getEventHandler("mspointermove");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointermove(Object onmspointermove) {
        this.setEventHandler("mspointermove", onmspointermove);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerout() {
        return this.getEventHandler("mspointerout");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerout(Object onmspointerout) {
        this.setEventHandler("mspointerout", onmspointerout);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerover() {
        return this.getEventHandler("mspointerover");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerover(Object onmspointerover) {
        this.setEventHandler("mspointerover", onmspointerover);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerup() {
        return this.getEventHandler("mspointerup");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerup(Object onmspointerup) {
        this.setEventHandler("mspointerup", onmspointerup);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmssitemodejumplistitemremoved() {
        return this.getEventHandler("mssitemodejumplistitemremoved");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmssitemodejumplistitemremoved(Object onmssitemodejumplistitemremoved) {
        this.setEventHandler("mssitemodejumplistitemremoved", onmssitemodejumplistitemremoved);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsthumbnailclick() {
        return this.getEventHandler("msthumbnailclick");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsthumbnailclick(Object onmsthumbnailclick) {
        this.setEventHandler("msthumbnailclick", onmsthumbnailclick);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnstop() {
        return this.getEventHandler("stop");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnstop(Object onstop) {
        this.setEventHandler("stop", onstop);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnstoragecommit() {
        return this.getEventHandler("storagecommit");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnstoragecommit(Object onstoragecommit) {
        this.setEventHandler("storagecommit", onstoragecommit);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnactivate() {
        return this.getEventHandler("activate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnactivate(Object onactivate) {
        this.setEventHandler("activate", onactivate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforeactivate() {
        return this.getEventHandler("beforeactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforeactivate(Object onbeforeactivate) {
        this.setEventHandler("beforeactivate", onbeforeactivate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforedeactivate() {
        return this.getEventHandler("beforedeactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforedeactivate(Object onbeforedeactivate) {
        this.setEventHandler("beforedeactivate", onbeforedeactivate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOndeactivate() {
        return this.getEventHandler("deactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOndeactivate(Object ondeactivate) {
        this.setEventHandler("deactivate", ondeactivate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ScriptableObject getCurrentScript() {
        return this.currentScript_;
    }

    public void setCurrentScript(ScriptableObject script) {
        this.currentScript_ = script;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ScriptableObject getFonts() {
        if (this.fonts_ == null) {
            FontFaceSet fonts = new FontFaceSet();
            fonts.setParentScope((Scriptable)this.getWindow());
            fonts.setPrototype(this.getPrototype(fonts.getClass()));
            this.fonts_ = fonts;
        }
        return this.fonts_;
    }

    @JsxGetter
    public HTMLCollection getAll() {
        return new HTMLAllCollection(this.getDomNodeOrDie()){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }

            @Override
            public boolean avoidObjectDetection() {
                return true;
            }
        };
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getParentWindow() {
        return this.getWindow();
    }

    @JsxFunction
    public Object getElementById(String id) {
        DomNode domNode = this.getDomNodeOrDie();
        Object domElement = domNode.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement != null) {
            if (!(domNode instanceof XmlPage) || domElement instanceof HtmlElement || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_GET_ELEMENT_BY_ID__ANY_ELEMENT)) {
                return ((DomElement)domElement).getScriptableObject();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getElementById(" + id + "): no HTML DOM node found with this ID"));
            }
        }
        return null;
    }

    @JsxFunction
    public Object createProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getPage().createProcessingInstruction(target, data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public Object createCDATASection(String data) {
        CDATASection node = this.getPage().createCDATASection(data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public void clear() {
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean contains(Object element) {
        return this.getDocumentElement().contains(element);
    }

    static {
        HashMap<String, Class> dom2EventMap = new HashMap<String, Class>();
        dom2EventMap.put("HTMLEvents", Event.class);
        dom2EventMap.put("MouseEvents", MouseEvent.class);
        dom2EventMap.put("MutationEvents", MutationEvent.class);
        dom2EventMap.put("UIEvents", UIEvent.class);
        SUPPORTED_DOM2_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom2EventMap);
        HashMap<String, Class<TextEvent>> dom3EventMap = new HashMap<String, Class<TextEvent>>();
        dom3EventMap.put("Event", Event.class);
        dom3EventMap.put("KeyboardEvent", KeyboardEvent.class);
        dom3EventMap.put("MouseEvent", MouseEvent.class);
        dom3EventMap.put("MessageEvent", MessageEvent.class);
        dom3EventMap.put("MutationEvent", MutationEvent.class);
        dom3EventMap.put("UIEvent", UIEvent.class);
        dom3EventMap.put("CustomEvent", CustomEvent.class);
        dom3EventMap.put("CloseEvent", CloseEvent.class);
        dom3EventMap.put("CompositionEvent", CompositionEvent.class);
        dom3EventMap.put("DragEvent", DragEvent.class);
        dom3EventMap.put("TextEvent", TextEvent.class);
        SUPPORTED_DOM3_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom3EventMap);
        HashMap<String, Class<SVGZoomEvent>> additionalEventMap = new HashMap<String, Class<SVGZoomEvent>>();
        additionalEventMap.put("BeforeUnloadEvent", BeforeUnloadEvent.class);
        additionalEventMap.put("Events", Event.class);
        additionalEventMap.put("HashChangeEvent", HashChangeEvent.class);
        additionalEventMap.put("KeyEvents", KeyboardEvent.class);
        additionalEventMap.put("PointerEvent", PointerEvent.class);
        additionalEventMap.put("PopStateEvent", PopStateEvent.class);
        additionalEventMap.put("ProgressEvent", ProgressEvent.class);
        additionalEventMap.put("MouseWheelEvent", MouseWheelEvent.class);
        additionalEventMap.put("FocusEvent", FocusEvent.class);
        additionalEventMap.put("WheelEvent", WheelEvent.class);
        additionalEventMap.put("SVGZoomEvent", SVGZoomEvent.class);
        SUPPORTED_VENDOR_EVENT_TYPE_MAP = Collections.unmodifiableMap(additionalEventMap);
        UniqueID_Counter_ = new AtomicInteger(1);
        List<String> cmds = Arrays.asList("2D-Position", "AbsolutePosition", "BlockDirLTR", "BlockDirRTL", "BrowseMode", "ClearAuthenticationCache", "CreateBookmark", "Copy", "Cut", "DirLTR", "DirRTL", "EditMode", "InlineDirLTR", "InlineDirRTL", "InsertButton", "InsertFieldset", "InsertIFrame", "InsertInputButton", "InsertInputCheckbox", "InsertInputFileUpload", "InsertInputHidden", "InsertInputImage", "InsertInputPassword", "InsertInputRadio", "InsertInputReset", "InsertInputSubmit", "InsertInputText", "InsertMarquee", "InsertSelectDropdown", "InsertSelectListbox", "InsertTextArea", "LiveResize", "MultipleSelection", "Open", "OverWrite", "PlayImage", "Refresh", "RemoveParaFormat", "SaveAs", "SizeToControl", "SizeToControlHeight", "SizeToControlWidth", "Stop", "StopImage", "UnBookmark", "Paste");
        for (String cmd : cmds) {
            EXECUTE_CMDS_IE.add(cmd.toLowerCase(Locale.ROOT));
        }
        cmds = Arrays.asList("BackColor", "BackgroundImageCache", "Bold", "CreateLink", "Delete", "FontName", "FontSize", "ForeColor", "FormatBlock", "Indent", "InsertHorizontalRule", "InsertImage", "InsertOrderedList", "InsertParagraph", "InsertUnorderedList", "Italic", "JustifyCenter", "JustifyFull", "JustifyLeft", "JustifyNone", "JustifyRight", "Outdent", "Print", "Redo", "RemoveFormat", "SelectAll", "StrikeThrough", "Subscript", "Superscript", "Underline", "Undo", "Unlink", "Unselect");
        for (String cmd : cmds) {
            EXECUTE_CMDS_IE.add(cmd.toLowerCase(Locale.ROOT));
            if ("Bold".equals(cmd)) continue;
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
        cmds = Arrays.asList("backColor", "bold", "contentReadOnly", "copy", "createLink", "cut", "decreaseFontSize", "delete", "fontName", "fontSize", "foreColor", "formatBlock", "heading", "hiliteColor", "increaseFontSize", "indent", "insertHorizontalRule", "insertHTML", "insertImage", "insertOrderedList", "insertUnorderedList", "insertParagraph", "italic", "justifyCenter", "JustifyFull", "justifyLeft", "justifyRight", "outdent", "paste", "redo", "removeFormat", "selectAll", "strikeThrough", "subscript", "superscript", "underline", "undo", "unlink", "useCSS", "styleWithCSS");
        for (String cmd : cmds) {
            EXECUTE_CMDS_FF.add(cmd.toLowerCase(Locale.ROOT));
            if ("bold".equals(cmd)) continue;
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
    }
}

