/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSubCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class HTMLCollection
extends AbstractList {
    private int currentIndex_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection() {
    }

    public HTMLCollection(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    HTMLCollection(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, initialElements);
    }

    public static HTMLCollection emptyCollection(DomNode domNode) {
        final List list = Collections.emptyList();
        return new HTMLCollection(domNode, false){

            @Override
            public List<DomNode> getElements() {
                return list;
            }
        };
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        return new HTMLCollection(parentScope, initialElements);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.supportsParentheses()) {
            return super.call(cx, scope, thisObj, args);
        }
        throw ScriptRuntime.typeError((String)"HTMLCollection does nont support function like access");
    }

    protected boolean supportsParentheses() {
        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_SUPPORTS_PARANTHESES);
    }

    @Override
    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            Object object;
            double doubleValue;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_DOUBLE_INDEX_ALSO) && !Double.isNaN(doubleValue = Context.toNumber((Object)name)) && (object = this.get((int)doubleValue, (Scriptable)this)) != NOT_FOUND) {
                return object;
            }
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @Override
    public Object item(Object index) {
        Object object;
        if (index instanceof String && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_ID_SEARCH_ALSO)) {
            String name = (String)index;
            return this.namedItem(name);
        }
        int idx = 0;
        double doubleValue = Context.toNumber((Object)index);
        if (!Double.isNaN(doubleValue)) {
            idx = (int)doubleValue;
        }
        if ((object = this.get(idx, (Scriptable)this)) == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public Object namedItem(String name) {
        DomElement elem;
        List<DomNode> elements = this.getElements();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NAMED_ITEM_ID_FIRST)) {
            for (DomNode next : elements) {
                String id;
                if (!(next instanceof DomElement) || !name.equals(id = (elem = (DomElement)next).getId())) continue;
                return this.getScriptableForElement(elem);
            }
        }
        for (DomNode next : elements) {
            if (!(next instanceof DomElement)) continue;
            elem = (DomElement)next;
            String nodeName = elem.getAttributeDirect("name");
            if (name.equals(nodeName)) {
                return this.getScriptableForElement(elem);
            }
            String id = elem.getId();
            if (!name.equals(id)) continue;
            return this.getScriptableForElement(elem);
        }
        return null;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object nextNode() {
        List<DomNode> elements = this.getElements();
        DomNode nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object tags(final String tagName) {
        return new HTMLSubCollection(this){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagName.equalsIgnoreCase(node.getLocalName());
            }
        };
    }
}

