/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip
extends ZipFile {
    public static void toDir(File file, File file2) throws IOException {
        Unzip unzip = new Unzip(file);
        unzip.unzip(file2);
        unzip.close();
    }

    public Unzip(File file) throws ZipException, IOException {
        super(file);
    }

    public void unzip(File file) throws ZipException, IOException {
        if (file == null) {
            file = new File("");
        }
        file.mkdirs();
        Enumeration<? extends ZipEntry> enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.unzip(file, zipEntry);
        }
    }

    public void unzip(File file, String string) throws ZipException, IOException {
        Unzip.unzipEntry(this, this.getEntry(string), file);
    }

    public void unzip(File file, ZipEntry zipEntry) throws ZipException, IOException {
        Unzip.unzipEntry(this, zipEntry, file);
    }

    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, File file) throws ZipException, IOException {
        File file2 = new File(file, zipEntry.getName());
        if (zipEntry.isDirectory()) {
            file2.mkdirs();
        } else {
            int n;
            file2.getParentFile().mkdirs();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write((byte)n);
            }
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
    }

    public InputStream getInputStream(String string) throws IOException {
        ZipEntry zipEntry = this.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        return this.getInputStream(zipEntry);
    }
}

