/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBRowUpdater;
import org.firebirdsql.jdbc.FBServerScrollFetcher;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableCursorFetcher;
import org.firebirdsql.jdbc.FBUpdatableFetcher;
import org.firebirdsql.jdbc.FirebirdResultSet;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.field.FBCloseableField;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TrimmableField;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBResultSet
implements ResultSet,
FirebirdResultSet,
FBObjectListener.FetcherListener {
    private static final String UNICODE_STREAM_NOT_SUPPORTED = "Unicode stream not supported.";
    private final FBStatement fbStatement;
    private FBFetcher fbFetcher;
    private FirebirdRowUpdater rowUpdater;
    protected final FBConnection connection;
    protected final GDSHelper gdsHelper;
    protected final RowDescriptor rowDescriptor;
    protected RowValue row;
    private boolean wasNull = false;
    private boolean wasNullValid = false;
    private volatile boolean closed = false;
    private SQLWarning firstWarning;
    private final FBField[] fields;
    private final List<FBCloseableField> closeableFields = new ArrayList<FBCloseableField>();
    private final Map<String, Integer> colNames;
    private final String cursorName;
    private final FBObjectListener.ResultSetListener listener;
    private final int rsType;
    private final int rsConcurrency;
    private final int rsHoldability;
    private int fetchDirection = 1000;

    @Override
    public void allRowsFetched(FBFetcher fetcher) throws SQLException {
        this.listener.allRowsFetched(this);
    }

    @Override
    public void fetcherClosed(FBFetcher fetcher) throws SQLException {
    }

    @Override
    public void rowChanged(FBFetcher fetcher, RowValue newRow) throws SQLException {
        this.row = newRow;
    }

    public FBResultSet(FBConnection connection, FBStatement fbStatement, FbStatement stmt, FBObjectListener.ResultSetListener listener, boolean metaDataQuery, int rsType, int rsConcurrency, int rsHoldability, boolean cached) throws SQLException {
        try {
            this.connection = connection;
            this.gdsHelper = connection != null ? connection.getGDSHelper() : null;
            this.cursorName = fbStatement.getCursorName();
            this.listener = listener != null ? listener : FBObjectListener.NoActionResultSetListener.instance();
            this.rowDescriptor = stmt.getRowDescriptor();
            this.fields = new FBField[this.rowDescriptor.getCount()];
            this.colNames = new HashMap<String, Integer>(this.rowDescriptor.getCount(), 1.0f);
            this.fbStatement = fbStatement;
            if (rsType == 1005) {
                fbStatement.addWarning(FbExceptionBuilder.forWarning(337248266).toSQLException(SQLWarning.class));
                rsType = 1004;
            }
            boolean serverSideScrollable = rsHoldability != 1 && !metaDataQuery && connection != null && connection.isScrollableCursor("SERVER") && stmt.supportsFetchScroll();
            cached = cached || metaDataQuery || rsType != 1003 && !serverSideScrollable;
            this.prepareVars(cached, metaDataQuery);
            if (cached) {
                this.fbFetcher = new FBCachedFetcher(this.gdsHelper, fbStatement.fetchSize, fbStatement.maxRows, stmt, this, rsType == 1003);
            } else if (serverSideScrollable && rsType == 1004) {
                this.fbFetcher = new FBServerScrollFetcher(fbStatement.fetchSize, fbStatement.maxRows, stmt, this);
            } else if (fbStatement.isUpdatableCursor()) {
                this.fbFetcher = new FBUpdatableCursorFetcher(this.gdsHelper, stmt, this, fbStatement.maxRows, fbStatement.fetchSize);
            } else {
                assert (rsType == 1003) : "Expected TYPE_FORWARD_ONLY";
                this.fbFetcher = new FBStatementFetcher(this.gdsHelper, stmt, this, fbStatement.maxRows, fbStatement.fetchSize);
            }
            if (rsConcurrency == 1008) {
                try {
                    this.rowUpdater = new FBRowUpdater(connection, this.rowDescriptor, cached, listener);
                    if (serverSideScrollable && this.fbFetcher instanceof FBServerScrollFetcher) {
                        this.fbFetcher = new FBUpdatableFetcher(this.fbFetcher, this, this.rowDescriptor.createDeletedRowMarker());
                    }
                }
                catch (FBResultSetNotUpdatableException ex) {
                    fbStatement.addWarning(FbExceptionBuilder.forWarning(337248264).toSQLException(SQLWarning.class));
                    rsConcurrency = 1007;
                }
            }
            this.rsType = rsType;
            this.rsConcurrency = rsConcurrency;
            this.rsHoldability = rsHoldability;
            this.fetchDirection = fbStatement.getFetchDirection();
        }
        catch (SQLException e) {
            try {
                stmt.closeCursor();
            }
            catch (SQLException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public FBResultSet(RowDescriptor rowDescriptor, List<RowValue> rows, FBObjectListener.ResultSetListener listener) throws SQLException {
        this(rowDescriptor, null, rows, listener, false, false);
    }

    public FBResultSet(RowDescriptor rowDescriptor, List<RowValue> rows) throws SQLException {
        this(rowDescriptor, rows, null);
    }

    public FBResultSet(RowDescriptor rowDescriptor, FBConnection connection, List<RowValue> rows, boolean retrieveBlobs) throws SQLException {
        this(rowDescriptor, connection, rows, null, retrieveBlobs, true);
    }

    public FBResultSet(RowDescriptor rowDescriptor, FBConnection connection, List<RowValue> rows, FBObjectListener.ResultSetListener listener, boolean retrieveBlobs, boolean trimStrings) throws SQLException {
        this.connection = connection;
        this.gdsHelper = connection != null ? connection.getGDSHelper() : null;
        this.fbStatement = null;
        this.listener = listener != null ? listener : FBObjectListener.NoActionResultSetListener.instance();
        this.cursorName = null;
        this.fbFetcher = new FBCachedFetcher(rows, this, rowDescriptor, this.gdsHelper, retrieveBlobs);
        this.rowDescriptor = rowDescriptor;
        this.fields = new FBField[rowDescriptor.getCount()];
        this.colNames = new HashMap<String, Integer>(rowDescriptor.getCount(), 1.0f);
        this.prepareVars(true, trimStrings);
        this.rsType = 1003;
        this.rsConcurrency = 1007;
        this.rsHoldability = 2;
    }

    private void prepareVars(boolean cached, boolean trimStrings) throws SQLException {
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            final int fieldPosition = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return FBResultSet.this.row.getFieldData(fieldPosition);
                }

                @Override
                public void setFieldData(byte[] data) {
                    FBResultSet.this.row.setFieldData(fieldPosition, data);
                }
            };
            FBField field = FBField.createField(this.rowDescriptor.getFieldDescriptor(i), dataProvider, this.gdsHelper, cached);
            if (field instanceof FBCloseableField) {
                this.closeableFields.add((FBCloseableField)((Object)field));
            }
            if (trimStrings && field instanceof TrimmableField) {
                ((TrimmableField)((Object)field)).setTrimTrailing(true);
            }
            this.fields[i] = field;
        }
    }

    private void notifyRowUpdater() throws SQLException {
        if (this.rowUpdater != null) {
            this.rowUpdater.setRow(this.row);
        }
    }

    protected void checkCursorMove() throws SQLException {
        this.checkOpen();
        this.closeFields();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The result set is closed", "07005");
        }
    }

    protected void checkScrollable() throws SQLException {
        if (this.rsType == 1003) {
            throw new FbExceptionBuilder().nonTransientException(337248279).toSQLException();
        }
    }

    protected void closeFields() throws SQLException {
        this.wasNullValid = false;
        if (this.closeableFields.isEmpty()) {
            return;
        }
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (FBCloseableField field : this.closeableFields) {
            try {
                field.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.next();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Deprecated
    void close(boolean notifyListener) throws SQLException {
        this.close(notifyListener, CompletionReason.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean notifyListener, CompletionReason completionReason) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try {
            this.closeFields();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        finally {
            try {
                if (this.fbFetcher != null) {
                    try {
                        this.fbFetcher.close(completionReason);
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (this.rowUpdater != null) {
                    try {
                        this.rowUpdater.close();
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (notifyListener) {
                    try {
                        this.listener.resultSetClosed(this);
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
            }
            finally {
                this.fbFetcher = null;
                this.rowUpdater = null;
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (!this.wasNullValid) {
            throw new SQLException("Look at a column before testing null.");
        }
        if (this.row == null) {
            throw new SQLException("No row available for wasNull.");
        }
        return this.wasNull;
    }

    @Override
    public final InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getString();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    public FBField getField(int columnIndex) throws SQLException {
        FBField field = this.getField(columnIndex, true);
        this.wasNullValid = true;
        this.wasNull = this.row == null || this.row.getFieldData(columnIndex - 1) == null;
        return field;
    }

    public FBField getField(int columnIndex, boolean checkRowPosition) throws SQLException {
        this.checkOpen();
        if (checkRowPosition && this.row == null && this.rowUpdater == null) {
            throw new SQLException("The result set is not in a row, use next", "01S06");
        }
        if (columnIndex > this.rowDescriptor.getCount()) {
            throw new SQLException("Invalid column index: " + columnIndex, "HY002");
        }
        if (this.rowUpdater != null) {
            return this.rowUpdater.getField(columnIndex - 1);
        }
        return this.fields[columnIndex - 1];
    }

    public FBField getField(String columnName) throws SQLException {
        this.checkOpen();
        if (this.row == null && this.rowUpdater == null) {
            throw new SQLException("The result set is not in a row, use next", "01S06");
        }
        if (columnName == null) {
            throw new SQLException("Column identifier must be not null.", "HY002");
        }
        Integer fieldNum = this.colNames.get(columnName);
        if (fieldNum == null) {
            fieldNum = this.findColumn(columnName);
            this.colNames.put(columnName, fieldNum);
        }
        FBField field = this.rowUpdater != null ? this.rowUpdater.getField(fieldNum - 1) : this.fields[fieldNum - 1];
        this.wasNullValid = true;
        this.wasNull = this.row == null || this.row.getFieldData(fieldNum - 1) == null;
        return field;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getField(columnName).getString();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    @Override
    public final InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getBinaryStream(columnName);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new FBResultSetMetaData(this.rowDescriptor, this.connection);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (columnName == null || columnName.equals("")) {
            throw new SQLException("Empty string does not identify column.", "HY002");
        }
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            int i;
            columnName = columnName.substring(1, columnName.length() - 1);
            for (i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!columnName.equals(this.rowDescriptor.getFieldDescriptor(i).getFieldName())) continue;
                return ++i;
            }
            for (i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!columnName.equals(this.rowDescriptor.getFieldDescriptor(i).getOriginalName())) continue;
                return ++i;
            }
        } else {
            int i;
            for (i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!columnName.equalsIgnoreCase(this.rowDescriptor.getFieldDescriptor(i).getFieldName())) continue;
                return ++i;
            }
            for (i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!columnName.equalsIgnoreCase(this.rowDescriptor.getFieldDescriptor(i).getOriginalName())) continue;
                return ++i;
            }
        }
        if ("RDB$DB_KEY".equalsIgnoreCase(columnName)) {
            return this.findColumn("DB_KEY");
        }
        throw new SQLException("Column name " + columnName + " not found in result set.", "HY002");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.beforeFirst();
        this.notifyRowUpdater();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.afterLast();
        this.notifyRowUpdater();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.first();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.last();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.getRowNum();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.absolute(row);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.relative(rows);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.previous();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        switch (direction) {
            case 1000: {
                this.fetchDirection = direction;
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw FbExceptionBuilder.forException(337248278).messageParameter(direction).toSQLException();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Can't set negative fetch size.", "HY009");
        }
        this.fbFetcher.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.rsType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowDeleted();
    }

    private void checkUpdatable() throws SQLException {
        this.checkOpen();
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setNull();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBoolean(x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setByte(x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setShort(x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setInteger(x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setLong(x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setFloat(x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setDouble(x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBigDecimal(x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setString(x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBytes(x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setDate(x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setTime(x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setTimestamp(x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setObject(x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setNull();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBoolean(x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setByte(x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setShort(x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setInteger(x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setLong(x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setFloat(x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setDouble(x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBigDecimal(x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setString(x);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        this.updateString(columnIndex, string);
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this.updateString(columnLabel, string);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBytes(x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setDate(x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setTime(x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setTimestamp(x);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public final void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnName, x, length);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setCharacterStream(reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(columnName, x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setObject(x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.insertRow();
        this.fbFetcher.insertRow(this.rowUpdater.getInsertRow());
        this.notifyRowUpdater();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.updateRow();
        this.fbFetcher.updateRow(this.rowUpdater.getNewRow());
        this.notifyRowUpdater();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.deleteRow();
        this.fbFetcher.deleteRow();
        this.notifyRowUpdater();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.refreshRow();
        this.fbFetcher.updateRow(this.rowUpdater.getOldRow());
        this.notifyRowUpdater();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
        this.rowUpdater.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() {
        return this.fbStatement;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    @Override
    public URL getURL(int param1) throws SQLException {
        throw new FBDriverNotCapableException("Type URL not supported");
    }

    @Override
    public URL getURL(String param1) throws SQLException {
        throw new FBDriverNotCapableException("Type URL not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getField(columnIndex).getObject(type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getField(columnLabel).getObject(type);
    }

    @Override
    public void updateRef(int param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    @Override
    public void updateRef(String param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBlob(blob);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBlob(blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setClob(clob);
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setClob(clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader);
    }

    @Override
    public void updateArray(int param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public void updateArray(String param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return (NClob)this.getClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return (NClob)this.getClob(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getRowId();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getField(columnLabel).getRowId();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this.updateClob(columnIndex, (Clob)clob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.updateClob(columnLabel, (Clob)clob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkUpdatable();
        throw new FBDriverNotCapableException("Firebird rowId (RDB$DB_KEY) is not updatable");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkUpdatable();
        throw new FBDriverNotCapableException("Firebird rowId (RDB$DB_KEY) is not updatable");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public String getExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.fbStatement == null) {
            return "";
        }
        return this.fbStatement.getExecutionPlan();
    }

    @Override
    public String getExplainedExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.fbStatement == null) {
            return "";
        }
        return this.fbStatement.getExplainedExecutionPlan();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            this.firstWarning.setNextWarning(warning);
        }
    }
}

