/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef.modules;

import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.softwareexpress.sitef.modules.FuncoesInternas;
import br.com.softwareexpress.sitef.modules.IPinPad;

public class PinPad
implements IPinPad {
    private JCliSiTefI jclisitefi;
    private FuncoesInternas funcInternas;

    public PinPad(JCliSiTefI jCliSiTefI, FuncoesInternas funcoesInternas) {
        this.jclisitefi = jCliSiTefI;
        this.funcInternas = funcoesInternas;
    }

    public boolean isPresent() throws Exception {
        int n = this.jclisitefi.verificaPresencaPinPad();
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new Exception("IPinPad.isPresent err [" + n + "]");
    }

    public int open() {
        return this.jclisitefi.abrePinPad();
    }

    public int close() {
        return this.jclisitefi.fechaPinPad();
    }

    public int getInformation(StringBuffer stringBuffer) throws Exception {
        if (stringBuffer == null) {
            throw new Exception("Output data sent as null.");
        }
        int n = this.jclisitefi.obtemInformacoesPinPad();
        if (n == 0) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.jclisitefi.getDadosSaida());
        }
        return n;
    }

    public int setDisplayMessage(String string) {
        return this.setDisplayMessage(string, false);
    }

    public int setDisplayMessage(String string, boolean bl) {
        if (bl) {
            return this.jclisitefi.escreveMensagemPermanentePinPad(string);
        }
        return this.jclisitefi.escreveMensagemPinPad(string);
    }

    public int readYesNo(String string) {
        return this.jclisitefi.leSimNaoPinPad(string);
    }

    public int readCard(String string) throws Exception {
        if (!this.funcInternas.verificaListener()) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n = this.jclisitefi.leCartaoSeguro(string);
        if (n == 10000) {
            n = this.funcInternas.processoIterativo(n);
        }
        return n;
    }

    public int readCard(String string, short s, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4) throws Exception {
        if (stringBuffer == null || stringBuffer2 == null || stringBuffer3 == null || stringBuffer4 == null) {
            throw new Exception("Output data sent as null.");
        }
        int n = this.jclisitefi.leCartaoDiretoSeguro(string, s);
        if (n == 0) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer3.delete(0, stringBuffer3.length());
            stringBuffer4.delete(0, stringBuffer4.length());
            stringBuffer.append(this.jclisitefi.getTipoTrilha1());
            stringBuffer2.append(this.jclisitefi.getTrilha1());
            stringBuffer3.append(this.jclisitefi.getTipoTrilha2());
            stringBuffer4.append(this.jclisitefi.getTrilha2());
        }
        return n;
    }

    public int readEMVCard(int n) throws Exception {
        if (!this.funcInternas.verificaListener()) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        if (n == 50 || n == 51) {
            int n2 = this.jclisitefi.leTrilhaChipInterativo(n);
            if (n2 == 10000) {
                n2 = this.funcInternas.processoIterativo(n2);
            }
            return n2;
        }
        return -20;
    }

    public int readTrack3(String string) throws Exception {
        if (!this.funcInternas.verificaListener()) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n = this.jclisitefi.leTrilha3(string);
        if (n == 10000) {
            n = this.funcInternas.processoIterativo(n);
        }
        return n;
    }

    public int readPIN(String string) throws Exception {
        if (!this.funcInternas.verificaListener()) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n = this.jclisitefi.leSenhaInterativo(string);
        if (n == 10000) {
            n = this.funcInternas.processoIterativo(n);
        }
        return n;
    }

    public String readPIN(String string, String string2, short s) throws Exception {
        int n = this.jclisitefi.leSenhaDiretoEx(string, string2, s);
        if (n == 0) {
            return this.jclisitefi.getSenha();
        }
        throw new Exception("IPinPad.readPIN err [" + n + "]");
    }

    public int getData(String string, String string2, String string3) throws Exception {
        if (!this.funcInternas.verificaListener()) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n = this.jclisitefi.obtemDadoPinPadEx(string, string2, string3);
        if (n == 10000) {
            n = this.funcInternas.processoIterativo(n);
        }
        return n;
    }

    public int getData(String string, String string2, String string3, StringBuffer stringBuffer) throws Exception {
        if (stringBuffer == null) {
            throw new Exception("Output data sent as null.");
        }
        int n = this.jclisitefi.obtemDadoPinPadDiretoEx(string, string2, string3);
        if (n == 0) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.jclisitefi.getDadosSaida());
        }
        return n;
    }

    public String readField(String string, short s) throws Exception {
        int n = this.jclisitefi.leCampoPinPad(string, s, (short)0);
        if (n == 0) {
            return this.jclisitefi.getCampo();
        }
        throw new Exception("IPinPad.readField err [" + n + "]");
    }

    public String readEncryptedField(String string, String string2, short s, short s2) throws Exception {
        int n = this.jclisitefi.leCampoCriptografadoPinPad(string, string2, s, s2);
        if (n == 0) {
            return this.jclisitefi.getCampo();
        }
        throw new Exception("IPinPad.readField err [" + n + "]");
    }

    public int readDigit(String string) {
        return this.jclisitefi.leDigitoPinPad(string);
    }

    public int readTwoDigits(String string) {
        return this.jclisitefi.leDoisDigitosPinPad(string);
    }

    public int getSecurityKey(String string, String string2, StringBuffer stringBuffer) throws Exception {
        if (stringBuffer == null) {
            throw new Exception("Output data sent as null.");
        }
        int n = this.jclisitefi.obtemChaveSeguranca(string, string2);
        if (n == 0) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.jclisitefi.getChaveSeguranca());
        }
        return n;
    }
}

