/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXSnackbar$$Lambda$1;
import com.jfoenix.controls.JFXSnackbar$$Lambda$10;
import com.jfoenix.controls.JFXSnackbar$$Lambda$11;
import com.jfoenix.controls.JFXSnackbar$$Lambda$2;
import com.jfoenix.controls.JFXSnackbar$$Lambda$3;
import com.jfoenix.controls.JFXSnackbar$$Lambda$4;
import com.jfoenix.controls.JFXSnackbar$$Lambda$5;
import com.jfoenix.controls.JFXSnackbar$$Lambda$6;
import com.jfoenix.controls.JFXSnackbar$$Lambda$7;
import com.jfoenix.controls.JFXSnackbar$$Lambda$8;
import com.jfoenix.controls.JFXSnackbar$$Lambda$9;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXSnackbar
extends Group {
    private static final String DEFAULT_STYLE_CLASS = "jfx-snackbar";
    private Pane snackbarContainer;
    private ChangeListener<? super Number> sizeListener = JFXSnackbar$$Lambda$1.lambdaFactory$(this);
    private WeakChangeListener<? super Number> weakSizeListener = new WeakChangeListener(this.sizeListener);
    private AtomicBoolean processingQueue = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<SnackbarEvent> eventQueue = new ConcurrentLinkedQueue();
    private ConcurrentHashMap.KeySetView<Object, Boolean> eventsSet = ConcurrentHashMap.newKeySet();
    private Interpolator easeInterpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    private Pane content;
    private PseudoClass activePseudoClass = null;
    private PauseTransition pauseTransition;
    private Timeline openAnimation = null;
    private SnackbarEvent currentEvent = null;

    public JFXSnackbar() {
        this(null);
    }

    public JFXSnackbar(Pane snackbarContainer) {
        this.initialize();
        this.content = new StackPane();
        this.content.getStyleClass().add((Object)"jfx-snackbar-content");
        this.getChildren().add((Object)this.content);
        this.setManaged(false);
        this.setVisible(false);
        this.registerSnackbarContainer(snackbarContainer);
        this.layoutBoundsProperty().addListener(JFXSnackbar$$Lambda$2.lambdaFactory$(this));
        this.addEventHandler(SnackbarEvent.SNACKBAR, JFXSnackbar$$Lambda$3.lambdaFactory$(this));
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Pane getPopupContainer() {
        return this.snackbarContainer;
    }

    public void setPrefWidth(double width) {
        this.content.setPrefWidth(width);
    }

    public double getPrefWidth() {
        return this.content.getPrefWidth();
    }

    public void registerSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer != null) {
                throw new IllegalArgumentException("Snackbar Container already set");
            }
            this.snackbarContainer = snackbarContainer;
            this.snackbarContainer.getChildren().add((Object)this);
            this.snackbarContainer.heightProperty().addListener(this.weakSizeListener);
            this.snackbarContainer.widthProperty().addListener(this.weakSizeListener);
        }
    }

    public void unregisterSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer == null) {
                throw new IllegalArgumentException("Snackbar Container not set");
            }
            this.snackbarContainer.getChildren().remove((Object)this);
            this.snackbarContainer.heightProperty().removeListener(this.weakSizeListener);
            this.snackbarContainer.widthProperty().removeListener(this.weakSizeListener);
            this.snackbarContainer = null;
        }
    }

    private void show(SnackbarEvent event) {
        this.content.getChildren().setAll((Object[])new Node[]{event.getContent()});
        this.openAnimation = this.getTimeline(event.getTimeout());
        if (event.getPseudoClass() != null) {
            this.activePseudoClass = event.getPseudoClass();
            this.content.pseudoClassStateChanged(this.activePseudoClass, true);
        }
        this.openAnimation.play();
    }

    private Timeline getTimeline(Duration timeout) {
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$4.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.translateYProperty(), (Object)this.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), JFXSnackbar$$Lambda$5.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, this.easeInterpolator)})});
        animation.setCycleCount(1);
        PauseTransition pauseTransition = this.pauseTransition = Duration.INDEFINITE.equals((Object)timeout) ? null : new PauseTransition(timeout);
        if (this.pauseTransition != null) {
            animation.setOnFinished(JFXSnackbar$$Lambda$6.lambdaFactory$(this));
        }
        return animation;
    }

    public void close() {
        if (this.openAnimation != null) {
            this.openAnimation.stop();
        }
        if (this.isVisible()) {
            Timeline closeAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$7.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)290.0), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), JFXSnackbar$$Lambda$8.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.translateYProperty(), (Object)this.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)0, this.easeInterpolator)})});
            closeAnimation.setCycleCount(1);
            closeAnimation.setOnFinished(JFXSnackbar$$Lambda$9.lambdaFactory$(this));
            closeAnimation.play();
        }
    }

    public SnackbarEvent getCurrentEvent() {
        return this.currentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(SnackbarEvent event) {
        JFXSnackbar jFXSnackbar = this;
        synchronized (jFXSnackbar) {
            if (!this.eventsSet.contains((Object)event)) {
                this.eventsSet.add((Object)event);
                this.eventQueue.offer(event);
            } else if (this.currentEvent == event && this.pauseTransition != null) {
                this.pauseTransition.playFromStart();
            }
        }
        if (this.processingQueue.compareAndSet(false, true)) {
            Platform.runLater((Runnable)JFXSnackbar$$Lambda$10.lambdaFactory$(this));
        }
    }

    private void resetPseudoClass() {
        if (this.activePseudoClass != null) {
            this.content.pseudoClassStateChanged(this.activePseudoClass, false);
            this.activePseudoClass = null;
        }
    }

    private void processSnackbar() {
        this.currentEvent = this.eventQueue.poll();
        if (this.currentEvent != null) {
            this.eventsSet.remove((Object)this.currentEvent);
            this.show(this.currentEvent);
        } else {
            this.processingQueue.getAndSet(false);
        }
    }

    private void refreshPopup() {
        Bounds contentBound = this.getLayoutBounds();
        double offsetX = Math.ceil(this.snackbarContainer.getWidth() / 2.0) - Math.ceil(contentBound.getWidth() / 2.0);
        double offsetY = this.snackbarContainer.getHeight() - contentBound.getHeight();
        this.setLayoutX(offsetX);
        this.setLayoutY(offsetY);
    }

    static /* synthetic */ void lambda$enqueue$10(JFXSnackbar this_) {
        this_.currentEvent = this_.eventQueue.poll();
        if (this_.currentEvent != null) {
            this_.show(this_.currentEvent);
        }
    }

    static /* synthetic */ void lambda$close$9(JFXSnackbar this_, ActionEvent e) {
        this_.resetPseudoClass();
        this_.processSnackbar();
    }

    static /* synthetic */ void lambda$close$8(JFXSnackbar this_, ActionEvent e) {
        this_.toBack();
    }

    static /* synthetic */ void lambda$close$7(JFXSnackbar this_, ActionEvent e) {
        this_.toFront();
    }

    static /* synthetic */ void lambda$getTimeline$6(JFXSnackbar this_, ActionEvent finish) {
        this_.pauseTransition.setOnFinished(JFXSnackbar$$Lambda$11.lambdaFactory$(this_));
        this_.pauseTransition.play();
    }

    static /* synthetic */ void lambda$null$5(JFXSnackbar this_, ActionEvent done) {
        this_.pauseTransition = null;
        this_.eventsSet.remove((Object)this_.currentEvent);
        this_.currentEvent = this_.eventQueue.peek();
        this_.close();
    }

    static /* synthetic */ void lambda$getTimeline$4(JFXSnackbar this_, ActionEvent e) {
        this_.toFront();
    }

    static /* synthetic */ void lambda$getTimeline$3(JFXSnackbar this_, ActionEvent e) {
        this_.toBack();
    }

    static /* synthetic */ void lambda$new$2(JFXSnackbar this_, SnackbarEvent e) {
        this_.enqueue(e);
    }

    static /* synthetic */ void lambda$new$1(JFXSnackbar this_, ObservableValue o, Bounds oldVal, Bounds newVal) {
        this_.refreshPopup();
    }

    static /* synthetic */ void lambda$new$0(JFXSnackbar this_, ObservableValue o, Number oldVal, Number newVal) {
        this_.refreshPopup();
    }

    public static class SnackbarEvent
    extends Event {
        public static final EventType<SnackbarEvent> SNACKBAR = new EventType(Event.ANY, "SNACKBAR");
        private final Node content;
        private final PseudoClass pseudoClass;
        private final Duration timeout;

        public SnackbarEvent(Node content) {
            this(content, Duration.millis((double)1500.0), null);
        }

        public SnackbarEvent(Node content, PseudoClass pseudoClass) {
            this(content, Duration.millis((double)1500.0), pseudoClass);
        }

        public SnackbarEvent(Node content, Duration timeout, PseudoClass pseudoClass) {
            super(SNACKBAR);
            this.content = content;
            this.pseudoClass = pseudoClass;
            this.timeout = timeout;
        }

        public Node getContent() {
            return this.content;
        }

        public PseudoClass getPseudoClass() {
            return this.pseudoClass;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public EventType<? extends SnackbarEvent> getEventType() {
            return super.getEventType();
        }

        public boolean isPersistent() {
            return Duration.INDEFINITE.equals((Object)this.getTimeout());
        }
    }
}

