/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.events.JFXAutoCompleteEvent;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$1;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$2;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$3;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$4;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$5;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$6;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$7;
import com.jfoenix.skins.JFXAutoCompletePopupSkin$$Lambda$8;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Scale;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXAutoCompletePopupSkin<T>
implements Skin<JFXAutoCompletePopup<T>> {
    private JFXAutoCompletePopup<T> control;
    private ListView<T> suggestionList;
    private final StackPane pane = new StackPane();
    private Scale scale;
    private Timeline showTransition;
    private boolean itemChanged = true;

    public JFXAutoCompletePopupSkin(JFXAutoCompletePopup<T> control) {
        this.control = control;
        this.suggestionList = new ListView<T>(control.getFilteredSuggestions()){

            protected void layoutChildren() {
                super.layoutChildren();
                if (JFXAutoCompletePopupSkin.this.itemChanged) {
                    if (JFXAutoCompletePopupSkin.this.suggestionList.getItems().size() > 0) {
                        JFXAutoCompletePopupSkin.this.suggestionList.getSelectionModel().select(0);
                        JFXAutoCompletePopupSkin.this.suggestionList.scrollTo(0);
                    }
                    JFXAutoCompletePopupSkin.this.itemChanged = false;
                }
            }
        };
        this.suggestionList.setFixedCellSize(control.getFixedCellSize());
        control.fixedCellSizeProperty().addListener(JFXAutoCompletePopupSkin$$Lambda$1.lambdaFactory$(this, control));
        this.suggestionList.getItems().addListener(JFXAutoCompletePopupSkin$$Lambda$2.lambdaFactory$(this));
        this.suggestionList.getStyleClass().add((Object)"autocomplete-list");
        control.suggestionsCellFactoryProperty().addListener(JFXAutoCompletePopupSkin$$Lambda$3.lambdaFactory$(this));
        if (control.getSuggestionsCellFactory() != null) {
            this.suggestionList.setCellFactory(control.getSuggestionsCellFactory());
        }
        this.pane.getChildren().add((Object)new Group(new Node[]{this.suggestionList}));
        this.pane.getStyleClass().add((Object)"autocomplete-container");
        this.suggestionList.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.suggestionList.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
        this.suggestionList.minWidthProperty().bind((ObservableValue)control.minWidthProperty());
        this.registerEventListener();
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked(JFXAutoCompletePopupSkin$$Lambda$4.lambdaFactory$(this));
        this.control.showingProperty().addListener(JFXAutoCompletePopupSkin$$Lambda$5.lambdaFactory$(this));
        this.suggestionList.setOnKeyPressed(JFXAutoCompletePopupSkin$$Lambda$6.lambdaFactory$(this));
    }

    public void animate() {
        this.updateListHeight();
        if (this.showTransition == null || this.showTransition.getStatus().equals((Object)Animation.Status.STOPPED)) {
            if (this.scale == null) {
                this.scale = new Scale(1.0, 0.0);
                this.pane.getTransforms().add((Object)this.scale);
            }
            this.scale.setY(0.0);
            this.suggestionList.setOpacity(0.0);
            this.scale.setPivotX(this.pane.getLayoutBounds().getWidth() / 2.0);
            this.showTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)this.scale.yProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            this.showTransition.setOnFinished(JFXAutoCompletePopupSkin$$Lambda$7.lambdaFactory$(this));
            this.showTransition.play();
        }
    }

    private void updateListHeight() {
        double height = (double)Math.min(this.suggestionList.getItems().size(), this.getSkinnable().getCellLimit()) * this.suggestionList.getFixedCellSize();
        this.suggestionList.setPrefHeight(height + this.suggestionList.getFixedCellSize() / 2.0);
    }

    private void selectItem() {
        Object item = this.suggestionList.getSelectionModel().getSelectedItem();
        if (item == null) {
            try {
                this.suggestionList.getSelectionModel().select(0);
                item = this.suggestionList.getSelectionModel().getSelectedItem();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (item != null) {
            this.control.getSelectionHandler().handle(new JFXAutoCompleteEvent<Object>(JFXAutoCompleteEvent.SELECTION, item));
        }
    }

    public Node getNode() {
        return this.pane;
    }

    public JFXAutoCompletePopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
        if (this.showTransition != null) {
            this.showTransition.stop();
            this.showTransition.getKeyFrames().clear();
            this.showTransition = null;
        }
    }

    static /* synthetic */ void lambda$animate$7(JFXAutoCompletePopupSkin this_, ActionEvent finish) {
        Group vf = (Group)this_.suggestionList.lookup(".sheet");
        ParallelTransition trans = new ParallelTransition();
        for (int i = 0; i < vf.getChildren().size(); ++i) {
            ListCell cell = (ListCell)vf.getChildren().get(i);
            int index = cell.getIndex();
            if (index <= -1) continue;
            cell.setOpacity(0.0);
            cell.setTranslateY(-this_.suggestionList.getFixedCellSize() / 8.0);
            Timeline f = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), JFXAutoCompletePopupSkin$$Lambda$8.lambdaFactory$(cell), new KeyValue[]{new KeyValue((WritableValue)cell.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cell.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            f.setDelay(Duration.millis((double)(index * 20)));
            trans.getChildren().add((Object)f);
        }
        this_.suggestionList.setOpacity(1.0);
        trans.play();
    }

    static /* synthetic */ void lambda$null$6(ListCell cell, ActionEvent end) {
        cell.setOpacity(1.0);
        cell.setTranslateY(0.0);
    }

    static /* synthetic */ void lambda$registerEventListener$5(JFXAutoCompletePopupSkin this_, KeyEvent event) {
        switch (event.getCode()) {
            case ENTER: {
                this_.selectItem();
                this_.getSkinnable().hide();
                break;
            }
            case ESCAPE: {
                this_.getSkinnable().hide();
                break;
            }
        }
    }

    static /* synthetic */ void lambda$registerEventListener$4(JFXAutoCompletePopupSkin this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            this_.animate();
        }
    }

    static /* synthetic */ void lambda$registerEventListener$3(JFXAutoCompletePopupSkin this_, MouseEvent me) {
        if (me.getButton() == MouseButton.PRIMARY) {
            this_.selectItem();
            this_.getSkinnable().hide();
        }
    }

    static /* synthetic */ void lambda$new$2(JFXAutoCompletePopupSkin this_, ObservableValue o, Callback oldVal, Callback newVal) {
        if (newVal != null) {
            this_.suggestionList.setCellFactory(newVal);
        }
    }

    static /* synthetic */ void lambda$new$1(JFXAutoCompletePopupSkin this_, Observable observable) {
        this_.itemChanged = true;
        this_.updateListHeight();
    }

    static /* synthetic */ void lambda$new$0(JFXAutoCompletePopupSkin this_, JFXAutoCompletePopup control, Observable observable) {
        this_.suggestionList.setFixedCellSize(control.getFixedCellSize());
    }
}

