/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions.template;

import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$1;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$2;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$3;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$4;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$5;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$6;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$7;
import com.jfoenix.transitions.template.JFXAnimationTemplate$$Lambda$8;
import com.jfoenix.transitions.template.JFXAnimationTemplateAction;
import com.jfoenix.transitions.template.JFXAnimationTemplateConfig;
import com.jfoenix.transitions.template.JFXTemplateAction;
import com.jfoenix.transitions.template.JFXTemplateBuilder;
import com.jfoenix.transitions.template.JFXTemplateConfig;
import com.jfoenix.transitions.template.JFXTemplateProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.Timeline;
import javafx.scene.Node;

public class JFXAnimationTemplate<N>
implements JFXTemplateConfig<N>,
JFXTemplateBuilder<N> {
    private static final String NO_KEY_FOUND_MESSAGE = "No animation objects with key \"%s\" found.\nPlease check your build method where the namedAnimationObjects are defined or your withAnimationObject methods where the keys are accessed.";
    private final Set<Double> percents = new HashSet<Double>();
    private final Map<Double, List<Function<JFXAnimationTemplateAction.InitBuilder<N>, JFXAnimationTemplateAction.Builder<?, ?>>>> creatorValueBuilderFunctions = new HashMap();
    private final Class<N> animationObjectType;
    private Map<String, Collection<Object>> animationObjects;
    private Function<JFXAnimationTemplateConfig.Builder, JFXAnimationTemplateConfig.Builder> creatorConfigBuilderFunction;
    private boolean clearPercents;

    private JFXAnimationTemplate(Class<N> animationObjectType) {
        this.animationObjectType = animationObjectType;
    }

    public static <N> JFXTemplateProcess<N> create(Class<N> animationObjectType) {
        return new JFXAnimationTemplate<N>(animationObjectType);
    }

    public static JFXTemplateProcess<Node> create() {
        return JFXAnimationTemplate.create(Node.class);
    }

    public Map<Double, List<JFXAnimationTemplateAction<?, ?>>> buildAndGetAnimationValues() {
        HashMap animationValueMap = new HashMap();
        this.creatorValueBuilderFunctions.forEach(JFXAnimationTemplate$$Lambda$1.lambdaFactory$(this, animationValueMap));
        return animationValueMap;
    }

    private List<Object> getAnimationObjectsWithKeys(Collection<String> keys) {
        ArrayList<Object> animationObjectList = new ArrayList<Object>();
        for (String key : keys) {
            Collection<Object> animationObjectsPerKey = this.animationObjects.get(key);
            if (animationObjectsPerKey == null) {
                throw new NoSuchElementException(String.format(NO_KEY_FOUND_MESSAGE, key));
            }
            animationObjectList.addAll(animationObjectsPerKey);
        }
        return animationObjectList;
    }

    public JFXAnimationTemplateConfig buildAndGetTemplateConfig() {
        return this.creatorConfigBuilderFunction.apply(JFXAnimationTemplateConfig.builder()).build();
    }

    @Override
    public JFXTemplateAction<N> percent(double first, double ... rest) {
        if (this.clearPercents) {
            this.percents.clear();
            this.clearPercents = false;
        }
        this.percents.add(Math.max(0.0, Math.min(100.0, first)));
        this.creatorValueBuilderFunctions.put(first, new ArrayList());
        for (double percent : rest) {
            this.percents.add(Math.max(0.0, Math.min(100.0, percent)));
            this.creatorValueBuilderFunctions.put(percent, new ArrayList());
        }
        return this;
    }

    @Override
    public JFXTemplateAction<N> from() {
        return this.percent(0.0, new double[0]);
    }

    @Override
    public JFXTemplateAction<N> to() {
        return this.percent(100.0, new double[0]);
    }

    @Override
    public JFXTemplateConfig<N> action(Function<JFXAnimationTemplateAction.InitBuilder<N>, JFXAnimationTemplateAction.Builder<?, ?>> valueBuilderFunction) {
        for (Double percent : this.percents) {
            this.creatorValueBuilderFunctions.get(percent).add(valueBuilderFunction);
        }
        this.clearPercents = true;
        return this;
    }

    @Override
    public JFXTemplateConfig<N> action(JFXAnimationTemplateAction.Builder<?, ?> animationValueBuilder) {
        return this.action(JFXAnimationTemplate$$Lambda$2.lambdaFactory$(animationValueBuilder));
    }

    @Override
    public JFXTemplateBuilder<N> config(Function<JFXAnimationTemplateConfig.Builder, JFXAnimationTemplateConfig.Builder> configBuilderFunction) {
        this.creatorConfigBuilderFunction = configBuilderFunction;
        return this;
    }

    @Override
    public JFXTemplateBuilder<N> config(JFXAnimationTemplateConfig.Builder configBuilder) {
        return this.config(JFXAnimationTemplate$$Lambda$3.lambdaFactory$(configBuilder));
    }

    @Override
    public <B> B build(Function<JFXAnimationTemplate<N>, B> builderFunction, Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>, JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>> mapBuilderFunction) {
        this.animationObjects = mapBuilderFunction.apply(JFXTemplateBuilder.JFXAnimationObjectMapBuilder.builder()).getAnimationObjects();
        this.animationObjects.putIfAbsent("_DefaultName_", Collections.singletonList(null));
        return builderFunction.apply(this);
    }

    @Override
    public <B> B build(Function<JFXAnimationTemplate<N>, B> builderFunction, N defaultAnimationObject) {
        return this.build(builderFunction, (N)JFXAnimationTemplate$$Lambda$4.lambdaFactory$(defaultAnimationObject));
    }

    @Override
    public Timeline build(Function<JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>, JFXTemplateBuilder.JFXAnimationObjectMapBuilder<N>> mapBuilderFunction) {
        return (Timeline)this.build((Function)JFXAnimationTemplate$$Lambda$5.lambdaFactory$(), (N)mapBuilderFunction);
    }

    @Override
    public Timeline build(N defaultAnimationObject) {
        return this.build((N)JFXAnimationTemplate$$Lambda$6.lambdaFactory$(defaultAnimationObject));
    }

    @Override
    public Timeline build() {
        return this.build((N)Function.identity());
    }

    static /* synthetic */ JFXTemplateBuilder.JFXAnimationObjectMapBuilder lambda$build$5(Object defaultAnimationObject, JFXTemplateBuilder.JFXAnimationObjectMapBuilder b) {
        return b.defaultObject(defaultAnimationObject, new Object[0]);
    }

    static /* synthetic */ JFXTemplateBuilder.JFXAnimationObjectMapBuilder lambda$build$4(Object defaultAnimationObject, JFXTemplateBuilder.JFXAnimationObjectMapBuilder b) {
        return b.defaultObject(defaultAnimationObject, new Object[0]);
    }

    static /* synthetic */ JFXAnimationTemplateConfig.Builder lambda$config$3(JFXAnimationTemplateConfig.Builder configBuilder, JFXAnimationTemplateConfig.Builder builder) {
        return configBuilder;
    }

    static /* synthetic */ JFXAnimationTemplateAction.Builder lambda$action$2(JFXAnimationTemplateAction.Builder animationValueBuilder, JFXAnimationTemplateAction.InitBuilder builder) {
        return animationValueBuilder;
    }

    static /* synthetic */ void lambda$buildAndGetAnimationValues$1(JFXAnimationTemplate this_, Map animationValueMap, Double percent, List animationValueBuilderFunctions) {
        List animationValues = animationValueBuilderFunctions.stream().flatMap(JFXAnimationTemplate$$Lambda$7.lambdaFactory$(this_)).collect(Collectors.toList());
        animationValueMap.put(percent, animationValues);
    }

    static /* synthetic */ Stream lambda$null$0(JFXAnimationTemplate this_, Function builderFunction) {
        return ((JFXAnimationTemplateAction.Builder)builderFunction.apply(JFXAnimationTemplateAction.builder(this_.animationObjectType))).buildActions(JFXAnimationTemplate$$Lambda$8.lambdaFactory$(this_));
    }

    static /* synthetic */ List access$lambda$0(JFXAnimationTemplate jFXAnimationTemplate, Collection collection) {
        return jFXAnimationTemplate.getAnimationObjectsWithKeys(collection);
    }
}

