/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.TopLevelDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Email {
    private final String localPart;
    private final String localPartWithoutComments;
    private final String domain;
    private final String domainWithoutComments;
    private final String fullSourceRoute;
    private final String identifier;
    private final List<String> domainParts;
    private final List<String> comments;
    private final List<String> sourceRoutes;
    private final boolean isIpAddress;
    private final boolean containsWhitespace;
    private final boolean hasIdentifier;
    private final TopLevelDomain tld;

    Email(String localPart, String localPartWithoutComments, String domain, String domainWithoutComments, String fullSourceRoute, String identifier, List<String> domainParts, List<String> comments, List<String> sourceRoutes, boolean isIpAddress, boolean containsWhitespace) {
        this.localPart = localPart;
        this.localPartWithoutComments = localPartWithoutComments;
        this.domain = domain;
        this.domainWithoutComments = domainWithoutComments;
        this.fullSourceRoute = fullSourceRoute;
        this.identifier = identifier;
        this.domainParts = Collections.unmodifiableList(domainParts);
        this.comments = Collections.unmodifiableList(comments);
        this.sourceRoutes = Collections.unmodifiableList(sourceRoutes);
        this.isIpAddress = isIpAddress;
        this.containsWhitespace = containsWhitespace;
        this.hasIdentifier = identifier != null && identifier.length() > 0;
        this.tld = domainParts.size() > 1 ? TopLevelDomain.fromString(domainParts.get(domainParts.size() - 1)) : TopLevelDomain.NONE;
    }

    Email(Email other, String identifier) {
        this.localPart = other.localPart;
        this.localPartWithoutComments = other.localPartWithoutComments;
        this.domain = other.domain;
        this.domainWithoutComments = other.domainWithoutComments;
        this.fullSourceRoute = other.fullSourceRoute;
        this.identifier = identifier;
        this.domainParts = other.domainParts;
        this.comments = other.comments;
        this.sourceRoutes = other.sourceRoutes;
        this.isIpAddress = other.isIpAddress;
        this.containsWhitespace = other.containsWhitespace;
        this.hasIdentifier = identifier != null && identifier.length() > 0;
        this.tld = other.tld;
    }

    public static Optional<Email> of(String email) {
        return JMail.tryParse(email);
    }

    public String localPart() {
        return this.localPart;
    }

    public String localPartWithoutComments() {
        return this.localPartWithoutComments;
    }

    public String domain() {
        return this.domain;
    }

    public String domainWithoutComments() {
        return this.domainWithoutComments;
    }

    public String identifier() {
        return this.identifier;
    }

    public List<String> domainParts() {
        return this.domainParts;
    }

    public List<String> comments() {
        return this.comments;
    }

    public List<String> explicitSourceRoutes() {
        return this.sourceRoutes;
    }

    public boolean isIpAddress() {
        return this.isIpAddress;
    }

    public boolean containsWhitespace() {
        return this.containsWhitespace;
    }

    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    public TopLevelDomain topLevelDomain() {
        return this.tld;
    }

    public String normalized() {
        String domain = this.isIpAddress ? "[" + this.domainWithoutComments + "]" : this.domainWithoutComments;
        return this.localPartWithoutComments + "@" + domain;
    }

    public String toString() {
        String fixedDomain = this.isIpAddress ? "[" + this.domain + "]" : this.domain;
        String fixedLocalPart = this.fullSourceRoute + this.localPart;
        String addr = fixedLocalPart + "@" + fixedDomain;
        return this.hasIdentifier ? this.identifier + "<" + addr + ">" : addr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.localPart, email.localPart) && Objects.equals(this.localPartWithoutComments, email.localPartWithoutComments) && Objects.equals(this.domain, email.domain) && Objects.equals(this.domainWithoutComments, email.domainWithoutComments) && Objects.equals(this.fullSourceRoute, email.fullSourceRoute) && Objects.equals(this.identifier, email.identifier) && Objects.equals(this.domainParts, email.domainParts) && Objects.equals(this.sourceRoutes, email.sourceRoutes) && Objects.equals(this.comments, email.comments) && Objects.equals(this.isIpAddress, email.isIpAddress) && Objects.equals(this.containsWhitespace, email.containsWhitespace) && Objects.equals(this.hasIdentifier, email.hasIdentifier) && Objects.equals(this.tld, email.tld);
    }

    public int hashCode() {
        return Objects.hash(this.localPart, this.localPartWithoutComments, this.domain, this.domainWithoutComments, this.fullSourceRoute, this.identifier, this.domainParts, this.sourceRoutes, this.comments, this.isIpAddress, this.containsWhitespace, this.hasIdentifier, this.tld);
    }
}

