/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.Optional;

public class FlattenedOptionalModule
implements Module {
    private static boolean isOptional(ResolvedType type) {
        return type.getErasedType() == Optional.class;
    }

    private ResolvedType resolveOptionalComponentType(MemberScope<?, ?> fieldOrMethod) {
        ResolvedType javaType = fieldOrMethod.getType();
        return FlattenedOptionalModule.isOptional(javaType) ? (ResolvedType)javaType.typeParametersFor(Optional.class).get(0) : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withTargetTypeOverrideResolver(this::resolveOptionalComponentType).withNullableCheck(field -> FlattenedOptionalModule.isOptional(field.getDeclaredType()) ? Boolean.TRUE : null);
        builder.forMethods().withTargetTypeOverrideResolver(this::resolveOptionalComponentType).withNullableCheck(method -> FlattenedOptionalModule.isOptional(method.getDeclaredType()) ? Boolean.TRUE : null);
    }
}

