/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.action;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.action.PdfAction;
import java.util.ArrayList;
import java.util.List;

public class PdfAnnotationAdditionalActions
extends PdfObjectWrapper<PdfDictionary> {
    private static final PdfName[] Events = new PdfName[]{PdfName.E, PdfName.X, PdfName.D, PdfName.U, PdfName.Fo, PdfName.Bl, PdfName.PO, PdfName.PC, PdfName.PV, PdfName.PI};

    public PdfAnnotationAdditionalActions(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfAction getOnEnter() {
        return this.getPdfActionForEvent(PdfName.E);
    }

    public void setOnEnter(PdfAction action) {
        this.setPdfActionForEvent(PdfName.E, action);
    }

    public PdfAction getOnExit() {
        return this.getPdfActionForEvent(PdfName.X);
    }

    public void setOnExit(PdfAction action) {
        this.setPdfActionForEvent(PdfName.X, action);
    }

    public PdfAction getOnMouseDown() {
        return this.getPdfActionForEvent(PdfName.D);
    }

    public void setOnMouseDown(PdfAction action) {
        this.setPdfActionForEvent(PdfName.D, action);
    }

    public PdfAction getOnMouseUp() {
        return this.getPdfActionForEvent(PdfName.U);
    }

    public void setOnMouseUp(PdfAction action) {
        this.setPdfActionForEvent(PdfName.U, action);
    }

    public PdfAction getOnFocus() {
        return this.getPdfActionForEvent(PdfName.Fo);
    }

    public void setOnFocus(PdfAction action) {
        this.setPdfActionForEvent(PdfName.Fo, action);
    }

    public PdfAction getOnLostFocus() {
        return this.getPdfActionForEvent(PdfName.Bl);
    }

    public void setOnLostFocus(PdfAction action) {
        this.setPdfActionForEvent(PdfName.Bl, action);
    }

    public PdfAction getOnPageOpened() {
        return this.getPdfActionForEvent(PdfName.PO);
    }

    public void setOnPageOpened(PdfAction action) {
        this.setPdfActionForEvent(PdfName.PO, action);
    }

    public PdfAction getOnPageClosed() {
        return this.getPdfActionForEvent(PdfName.PC);
    }

    public void setOnPageClosed(PdfAction action) {
        this.setPdfActionForEvent(PdfName.PC, action);
    }

    public PdfAction getOnPageVisible() {
        return this.getPdfActionForEvent(PdfName.PV);
    }

    public void setOnPageVisible(PdfAction action) {
        this.setPdfActionForEvent(PdfName.PV, action);
    }

    public PdfAction getOnPageLostView() {
        return this.getPdfActionForEvent(PdfName.PI);
    }

    public void setOnPageLostView(PdfAction action) {
        this.setPdfActionForEvent(PdfName.PI, action);
    }

    public List<PdfAction> getAllKnownActions() {
        ArrayList<PdfAction> result = new ArrayList<PdfAction>();
        for (PdfName event : Events) {
            PdfAction action = this.getPdfActionForEvent(event);
            if (action == null) continue;
            result.add(action);
        }
        return result;
    }

    public PdfAction getPdfActionForEvent(PdfName eventName) {
        PdfObject action = ((PdfDictionary)this.getPdfObject()).get(eventName);
        if (action == null || !action.isDictionary()) {
            return null;
        }
        return new PdfAction((PdfDictionary)action);
    }

    public void setPdfActionForEvent(PdfName event, PdfAction action) {
        if (action == null) {
            ((PdfDictionary)this.getPdfObject()).remove(event);
        } else {
            ((PdfDictionary)this.getPdfObject()).put(event, (PdfObject)action.getPdfObject());
        }
        this.setModified();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }
}

