/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.externalconnectors.models.ExternalActivity;
import com.microsoft.graph.externalconnectors.requests.ExternalActivityCollectionPage;
import com.microsoft.graph.externalconnectors.requests.ExternalActivityCollectionRequestBuilder;
import com.microsoft.graph.externalconnectors.requests.ExternalActivityCollectionResponse;
import com.microsoft.graph.externalconnectors.requests.ExternalActivityRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalActivityCollectionRequest
extends BaseEntityCollectionRequest<ExternalActivity, ExternalActivityCollectionResponse, ExternalActivityCollectionPage> {
    public ExternalActivityCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExternalActivityCollectionResponse.class, ExternalActivityCollectionPage.class, ExternalActivityCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ExternalActivity> postAsync(@Nonnull ExternalActivity newExternalActivity) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExternalActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newExternalActivity);
    }

    @Nonnull
    public ExternalActivity post(@Nonnull ExternalActivity newExternalActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExternalActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newExternalActivity);
    }

    @Nonnull
    public ExternalActivityCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ExternalActivityCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

