/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Chat;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatRequest
extends BaseRequest<Chat> {
    public ChatRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Chat.class);
    }

    @Nonnull
    public CompletableFuture<Chat> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Chat get() throws ClientException {
        return (Chat)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Chat> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Chat delete() throws ClientException {
        return (Chat)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Chat> patchAsync(@Nonnull Chat sourceChat) {
        return this.sendAsync(HttpMethod.PATCH, sourceChat);
    }

    @Nullable
    public Chat patch(@Nonnull Chat sourceChat) throws ClientException {
        return (Chat)this.send(HttpMethod.PATCH, sourceChat);
    }

    @Nonnull
    public CompletableFuture<Chat> postAsync(@Nonnull Chat newChat) {
        return this.sendAsync(HttpMethod.POST, newChat);
    }

    @Nullable
    public Chat post(@Nonnull Chat newChat) throws ClientException {
        return (Chat)this.send(HttpMethod.POST, newChat);
    }

    @Nonnull
    public CompletableFuture<Chat> putAsync(@Nonnull Chat newChat) {
        return this.sendAsync(HttpMethod.PUT, newChat);
    }

    @Nullable
    public Chat put(@Nonnull Chat newChat) throws ClientException {
        return (Chat)this.send(HttpMethod.PUT, newChat);
    }

    @Nonnull
    public ChatRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChatRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

