/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.DocumentSetVersion;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentSetVersionRequest
extends BaseRequest<DocumentSetVersion> {
    public DocumentSetVersionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DocumentSetVersion.class);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DocumentSetVersion get() throws ClientException {
        return (DocumentSetVersion)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DocumentSetVersion delete() throws ClientException {
        return (DocumentSetVersion)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> patchAsync(@Nonnull DocumentSetVersion sourceDocumentSetVersion) {
        return this.sendAsync(HttpMethod.PATCH, sourceDocumentSetVersion);
    }

    @Nullable
    public DocumentSetVersion patch(@Nonnull DocumentSetVersion sourceDocumentSetVersion) throws ClientException {
        return (DocumentSetVersion)this.send(HttpMethod.PATCH, sourceDocumentSetVersion);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> postAsync(@Nonnull DocumentSetVersion newDocumentSetVersion) {
        return this.sendAsync(HttpMethod.POST, newDocumentSetVersion);
    }

    @Nullable
    public DocumentSetVersion post(@Nonnull DocumentSetVersion newDocumentSetVersion) throws ClientException {
        return (DocumentSetVersion)this.send(HttpMethod.POST, newDocumentSetVersion);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> putAsync(@Nonnull DocumentSetVersion newDocumentSetVersion) {
        return this.sendAsync(HttpMethod.PUT, newDocumentSetVersion);
    }

    @Nullable
    public DocumentSetVersion put(@Nonnull DocumentSetVersion newDocumentSetVersion) throws ClientException {
        return (DocumentSetVersion)this.send(HttpMethod.PUT, newDocumentSetVersion);
    }

    @Nonnull
    public DocumentSetVersionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

