/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.PlannerTask;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlannerTaskRequest
extends BaseRequest<PlannerTask> {
    public PlannerTaskRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerTask.class);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public PlannerTask get() throws ClientException {
        return (PlannerTask)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public PlannerTask delete() throws ClientException {
        return (PlannerTask)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> patchAsync(@Nonnull PlannerTask sourcePlannerTask) {
        return this.sendAsync(HttpMethod.PATCH, sourcePlannerTask);
    }

    @Nullable
    public PlannerTask patch(@Nonnull PlannerTask sourcePlannerTask) throws ClientException {
        return (PlannerTask)this.send(HttpMethod.PATCH, sourcePlannerTask);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> postAsync(@Nonnull PlannerTask newPlannerTask) {
        return this.sendAsync(HttpMethod.POST, newPlannerTask);
    }

    @Nullable
    public PlannerTask post(@Nonnull PlannerTask newPlannerTask) throws ClientException {
        return (PlannerTask)this.send(HttpMethod.POST, newPlannerTask);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> putAsync(@Nonnull PlannerTask newPlannerTask) {
        return this.sendAsync(HttpMethod.PUT, newPlannerTask);
    }

    @Nullable
    public PlannerTask put(@Nonnull PlannerTask newPlannerTask) throws ClientException {
        return (PlannerTask)this.send(HttpMethod.PUT, newPlannerTask);
    }

    @Nonnull
    public PlannerTaskRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

