/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.regex.Pattern;
import org.modelmapper.spi.NameTokenizer;
import org.modelmapper.spi.NameableType;

public class NameTokenizers {
    public static final NameTokenizer CAMEL_CASE = new CamelCaseNameTokenizer();
    public static final NameTokenizer UNDERSCORE = new UnderscoreNameTokenizer();

    private static class UnderscoreNameTokenizer
    implements NameTokenizer {
        private static final Pattern underscore = Pattern.compile("_");

        private UnderscoreNameTokenizer() {
        }

        @Override
        public String[] tokenize(String name, NameableType nameableType) {
            return underscore.split(name);
        }

        public String toString() {
            return "Underscore";
        }
    }

    private static class CamelCaseNameTokenizer
    implements NameTokenizer {
        private static final Pattern camelCase = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");

        private CamelCaseNameTokenizer() {
        }

        @Override
        public String[] tokenize(String name, NameableType nameableType) {
            return camelCase.split(name);
        }

        public String toString() {
            return "Camel Case";
        }
    }
}

