/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.List;
import org.modelmapper.Condition;
import org.modelmapper.Provider;
import org.modelmapper.config.Configuration;
import org.modelmapper.convention.MatchingStrategies;
import org.modelmapper.convention.NameTokenizers;
import org.modelmapper.convention.NameTransformers;
import org.modelmapper.convention.NamingConventions;
import org.modelmapper.internal.TypeMapStore;
import org.modelmapper.internal.converter.AssignableConverter;
import org.modelmapper.internal.converter.ConverterStore;
import org.modelmapper.internal.converter.MergingCollectionConverter;
import org.modelmapper.internal.converter.NonMergingCollectionConverter;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.valueaccess.ValueAccessStore;
import org.modelmapper.internal.valuemutate.ValueMutateStore;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MatchingStrategy;
import org.modelmapper.spi.NameTokenizer;
import org.modelmapper.spi.NameTransformer;
import org.modelmapper.spi.NamingConvention;
import org.modelmapper.spi.ValueReader;
import org.modelmapper.spi.ValueWriter;

public class InheritingConfiguration
implements Configuration {
    private final Configuration parent;
    public final TypeMapStore typeMapStore;
    public final ConverterStore converterStore;
    public final ValueAccessStore valueAccessStore;
    public final ValueMutateStore valueMutateStore;
    private NameTokenizer destinationNameTokenizer;
    private NameTransformer destinationNameTransformer;
    private NamingConvention destinationNamingConvention;
    private Configuration.AccessLevel fieldAccessLevel;
    private MatchingStrategy matchingStrategy;
    private Configuration.AccessLevel methodAccessLevel;
    private Provider<?> provider;
    private Condition<?, ?> propertyCondition;
    private NameTokenizer sourceNameTokenizer;
    private NameTransformer sourceNameTransformer;
    private NamingConvention sourceNamingConvention;
    private Boolean fieldMatchingEnabled;
    private Boolean ambiguityIgnored;
    private Boolean fullTypeMatchingRequired;
    private Boolean implicitMatchingEnabled;
    private Boolean skipNullEnabled;
    private Boolean collectionsMergeEnabled;
    private Boolean useOSGiClassLoaderBridging;

    public InheritingConfiguration() {
        this.parent = null;
        this.typeMapStore = new TypeMapStore(this);
        this.converterStore = new ConverterStore();
        this.valueAccessStore = new ValueAccessStore();
        this.valueMutateStore = new ValueMutateStore();
        this.sourceNameTokenizer = NameTokenizers.CAMEL_CASE;
        this.destinationNameTokenizer = NameTokenizers.CAMEL_CASE;
        this.sourceNamingConvention = NamingConventions.JAVABEANS_ACCESSOR;
        this.destinationNamingConvention = NamingConventions.JAVABEANS_MUTATOR;
        this.sourceNameTransformer = NameTransformers.JAVABEANS_ACCESSOR;
        this.destinationNameTransformer = NameTransformers.JAVABEANS_MUTATOR;
        this.matchingStrategy = MatchingStrategies.STANDARD;
        this.fieldAccessLevel = Configuration.AccessLevel.PUBLIC;
        this.methodAccessLevel = Configuration.AccessLevel.PUBLIC;
        this.fieldMatchingEnabled = Boolean.FALSE;
        this.ambiguityIgnored = Boolean.FALSE;
        this.fullTypeMatchingRequired = Boolean.FALSE;
        this.implicitMatchingEnabled = Boolean.TRUE;
        this.skipNullEnabled = Boolean.FALSE;
        this.useOSGiClassLoaderBridging = Boolean.FALSE;
        this.collectionsMergeEnabled = Boolean.TRUE;
    }

    InheritingConfiguration(InheritingConfiguration source, boolean inherit) {
        this.typeMapStore = source.typeMapStore;
        this.converterStore = source.converterStore;
        this.valueAccessStore = source.valueAccessStore;
        this.valueMutateStore = source.valueMutateStore;
        if (inherit) {
            this.parent = source;
        } else {
            this.parent = null;
            this.sourceNameTokenizer = source.sourceNameTokenizer;
            this.destinationNameTokenizer = source.destinationNameTokenizer;
            this.sourceNamingConvention = source.sourceNamingConvention;
            this.destinationNamingConvention = source.destinationNamingConvention;
            this.sourceNameTransformer = source.sourceNameTransformer;
            this.destinationNameTransformer = source.destinationNameTransformer;
            this.matchingStrategy = source.matchingStrategy;
            this.fieldAccessLevel = source.fieldAccessLevel;
            this.methodAccessLevel = source.methodAccessLevel;
            this.fieldMatchingEnabled = source.fieldMatchingEnabled;
            this.ambiguityIgnored = source.ambiguityIgnored;
            this.provider = source.provider;
            this.propertyCondition = source.propertyCondition;
            this.fullTypeMatchingRequired = source.fullTypeMatchingRequired;
            this.implicitMatchingEnabled = source.implicitMatchingEnabled;
            this.skipNullEnabled = source.skipNullEnabled;
            this.collectionsMergeEnabled = source.collectionsMergeEnabled;
        }
    }

    @Override
    public <T> Configuration addValueReader(ValueReader<T> valueReader) {
        this.getValueReaders().add(valueReader);
        return this;
    }

    @Override
    public <T> Configuration addValueWriter(ValueWriter<T> valueWriter) {
        this.getValueWriters().add(valueWriter);
        return this;
    }

    @Override
    public Configuration copy() {
        return new InheritingConfiguration(this, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InheritingConfiguration other = (InheritingConfiguration)obj;
        if (!this.getSourceNameTransformer().equals(other.getSourceNameTransformer())) {
            return false;
        }
        if (!this.getDestinationNameTransformer().equals(other.getDestinationNameTransformer())) {
            return false;
        }
        if (this.getFieldAccessLevel() != other.getFieldAccessLevel()) {
            return false;
        }
        if (this.getMethodAccessLevel() != other.getMethodAccessLevel()) {
            return false;
        }
        return this.isFieldMatchingEnabled() == other.isFieldMatchingEnabled();
    }

    @Override
    public List<ConditionalConverter<?, ?>> getConverters() {
        return this.converterStore.getConverters();
    }

    @Override
    public NameTokenizer getDestinationNameTokenizer() {
        return this.destinationNameTokenizer == null ? Assert.notNull(this.parent).getDestinationNameTokenizer() : this.destinationNameTokenizer;
    }

    @Override
    public NameTransformer getDestinationNameTransformer() {
        return this.destinationNameTransformer == null ? Assert.notNull(this.parent).getDestinationNameTransformer() : this.destinationNameTransformer;
    }

    @Override
    public NamingConvention getDestinationNamingConvention() {
        return this.destinationNamingConvention == null ? Assert.notNull(this.parent).getDestinationNamingConvention() : this.destinationNamingConvention;
    }

    @Override
    public Configuration.AccessLevel getFieldAccessLevel() {
        return this.fieldAccessLevel == null ? Assert.notNull(this.parent).getFieldAccessLevel() : this.fieldAccessLevel;
    }

    @Override
    public MatchingStrategy getMatchingStrategy() {
        return this.matchingStrategy == null ? Assert.notNull(this.parent).getMatchingStrategy() : this.matchingStrategy;
    }

    @Override
    public Configuration.AccessLevel getMethodAccessLevel() {
        return this.methodAccessLevel == null ? Assert.notNull(this.parent).getMethodAccessLevel() : this.methodAccessLevel;
    }

    @Override
    public Condition<?, ?> getPropertyCondition() {
        if (this.parent != null) {
            return this.propertyCondition == null ? this.parent.getPropertyCondition() : this.propertyCondition;
        }
        return this.propertyCondition;
    }

    @Override
    public Provider<?> getProvider() {
        if (this.parent != null) {
            return this.provider == null ? Assert.notNull(this.parent).getProvider() : this.provider;
        }
        return this.provider;
    }

    @Override
    public NameTokenizer getSourceNameTokenizer() {
        return this.sourceNameTokenizer == null ? Assert.notNull(this.parent).getSourceNameTokenizer() : this.sourceNameTokenizer;
    }

    @Override
    public NameTransformer getSourceNameTransformer() {
        return this.sourceNameTransformer == null ? Assert.notNull(this.parent).getSourceNameTransformer() : this.sourceNameTransformer;
    }

    @Override
    public NamingConvention getSourceNamingConvention() {
        return this.sourceNamingConvention == null ? Assert.notNull(this.parent).getSourceNamingConvention() : this.sourceNamingConvention;
    }

    @Override
    public List<ValueReader<?>> getValueReaders() {
        return this.valueAccessStore.getValueReaders();
    }

    @Override
    public List<ValueWriter<?>> getValueWriters() {
        return this.valueMutateStore.getValueWriters();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getSourceNameTransformer().hashCode();
        result = 31 * result + this.getDestinationNameTransformer().hashCode();
        result = 31 * result + this.getFieldAccessLevel().hashCode();
        result = 31 * result + this.getMethodAccessLevel().hashCode();
        result = 31 * result + (this.isFieldMatchingEnabled() ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean isAmbiguityIgnored() {
        return this.ambiguityIgnored == null ? Assert.notNull(this.parent).isAmbiguityIgnored() : this.ambiguityIgnored.booleanValue();
    }

    @Override
    public boolean isFieldMatchingEnabled() {
        return this.fieldMatchingEnabled == null ? Assert.notNull(this.parent).isFieldMatchingEnabled() : this.fieldMatchingEnabled.booleanValue();
    }

    @Override
    public boolean isFullTypeMatchingRequired() {
        return this.fullTypeMatchingRequired == null ? Assert.notNull(this.parent).isFullTypeMatchingRequired() : this.fullTypeMatchingRequired.booleanValue();
    }

    @Override
    public boolean isImplicitMappingEnabled() {
        return this.implicitMatchingEnabled == null ? Assert.notNull(this.parent).isImplicitMappingEnabled() : this.implicitMatchingEnabled.booleanValue();
    }

    @Override
    public boolean isSkipNullEnabled() {
        return this.skipNullEnabled == null ? Assert.notNull(this.parent).isSkipNullEnabled() : this.skipNullEnabled.booleanValue();
    }

    @Override
    public boolean isUseOSGiClassLoaderBridging() {
        return this.useOSGiClassLoaderBridging == null ? Assert.notNull(this.parent).isUseOSGiClassLoaderBridging() : this.useOSGiClassLoaderBridging.booleanValue();
    }

    @Override
    public boolean isDeepCopyEnabled() {
        return this.converterStore.hasConverter(AssignableConverter.class);
    }

    @Override
    public boolean isCollectionsMergeEnabled() {
        return this.converterStore.hasConverter(NonMergingCollectionConverter.class);
    }

    @Override
    public Configuration setAmbiguityIgnored(boolean ignore) {
        this.ambiguityIgnored = ignore;
        return this;
    }

    @Override
    public Configuration setDestinationNameTokenizer(NameTokenizer nameTokenizer) {
        this.destinationNameTokenizer = Assert.notNull(nameTokenizer);
        return this;
    }

    @Override
    public Configuration setDestinationNameTransformer(NameTransformer nameTransformer) {
        this.destinationNameTransformer = Assert.notNull(nameTransformer);
        return this;
    }

    @Override
    public Configuration setDestinationNamingConvention(NamingConvention namingConvention) {
        this.destinationNamingConvention = Assert.notNull(namingConvention);
        return this;
    }

    @Override
    public Configuration setFieldAccessLevel(Configuration.AccessLevel accessLevel) {
        this.fieldAccessLevel = Assert.notNull(accessLevel);
        return this;
    }

    @Override
    public Configuration setFieldMatchingEnabled(boolean enabled) {
        this.fieldMatchingEnabled = enabled;
        return this;
    }

    @Override
    public Configuration setFullTypeMatchingRequired(boolean required) {
        this.fullTypeMatchingRequired = required;
        return this;
    }

    @Override
    public Configuration setImplicitMappingEnabled(boolean enabled) {
        this.implicitMatchingEnabled = enabled;
        return this;
    }

    @Override
    public Configuration setSkipNullEnabled(boolean enabled) {
        this.skipNullEnabled = enabled;
        return this;
    }

    @Override
    public Configuration setDeepCopyEnabled(boolean enabled) {
        if (enabled && this.converterStore.hasConverter(AssignableConverter.class)) {
            this.converterStore.removeConverter(AssignableConverter.class);
        } else if (!enabled && this.converterStore.hasConverter(AssignableConverter.class)) {
            this.converterStore.addConverter(new AssignableConverter());
        }
        return this;
    }

    @Override
    public Configuration setCollectionsMergeEnabled(boolean enabled) {
        if (enabled) {
            this.converterStore.replaceConverter(NonMergingCollectionConverter.class, new MergingCollectionConverter());
        } else {
            this.converterStore.replaceConverter(MergingCollectionConverter.class, new NonMergingCollectionConverter());
        }
        return this;
    }

    @Override
    public Configuration setMatchingStrategy(MatchingStrategy matchingStrategy) {
        this.matchingStrategy = Assert.notNull(matchingStrategy);
        return this;
    }

    @Override
    public Configuration setMethodAccessLevel(Configuration.AccessLevel accessLevel) {
        this.methodAccessLevel = Assert.notNull(accessLevel);
        return this;
    }

    @Override
    public Configuration setPropertyCondition(Condition<?, ?> condition) {
        this.propertyCondition = Assert.notNull(condition);
        return this;
    }

    @Override
    public Configuration setProvider(Provider<?> provider) {
        this.provider = Assert.notNull(provider);
        return this;
    }

    @Override
    public Configuration setSourceNameTokenizer(NameTokenizer nameTokenizer) {
        this.sourceNameTokenizer = Assert.notNull(nameTokenizer);
        return this;
    }

    @Override
    public Configuration setSourceNameTransformer(NameTransformer nameTransformer) {
        this.sourceNameTransformer = Assert.notNull(nameTransformer);
        return this;
    }

    @Override
    public Configuration setSourceNamingConvention(NamingConvention namingConvention) {
        this.sourceNamingConvention = Assert.notNull(namingConvention);
        return this;
    }

    @Override
    public Configuration setUseOSGiClassLoaderBridging(boolean useOSGiClassLoaderBridging) {
        this.useOSGiClassLoaderBridging = useOSGiClassLoaderBridging;
        return this;
    }
}

