/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.util.Iterator;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class ArrayConverter
implements ConditionalConverter<Object, Object> {
    ArrayConverter() {
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Iterables.isIterable(sourceType) && destinationType.isArray() ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    @Override
    public Object convert(MappingContext<Object, Object> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        boolean destinationProvided = context.getDestination() != null;
        Object destination = this.createDestination(context);
        Class<?> elementType = this.getElementType(context);
        int index = 0;
        Iterator<Object> iterator = Iterables.iterator(source);
        while (iterator.hasNext()) {
            Object sourceElement = iterator.next();
            Object element = null;
            if (destinationProvided) {
                element = Iterables.getElement(destination, index);
            }
            if (sourceElement != null) {
                MappingContext<Object, Object> elementContext = element == null ? context.create(sourceElement, elementType) : context.create(sourceElement, element);
                element = context.getMappingEngine().map(elementContext);
            }
            Array.set(destination, index, element);
            ++index;
        }
        return destination;
    }

    private Object createDestination(MappingContext<Object, Object> context) {
        int sourceLength = Iterables.getLength(context.getSource());
        int destinationLength = context.getDestination() != null ? Iterables.getLength(context.getDestination()) : 0;
        int newLength = Math.max(sourceLength, destinationLength);
        Object originalDestination = context.getDestination();
        Class<Object> destType = context.getDestinationType();
        Object destination = Array.newInstance(destType.isArray() ? destType.getComponentType() : destType, newLength);
        if (originalDestination != null) {
            System.arraycopy(originalDestination, 0, destination, 0, destinationLength);
        }
        return destination;
    }

    private Class<?> getElementType(MappingContext<Object, Object> context) {
        if (context.getGenericDestinationType() instanceof GenericArrayType) {
            return Types.rawTypeFor(context.getGenericDestinationType()).getComponentType();
        }
        return context.getDestinationType().getComponentType();
    }
}

