/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.modelmapper.ModelMapper;
import org.modelmapper.Module;
import org.modelmapper.jackson.ArrayNodeToCollectionConverter;
import org.modelmapper.jackson.CollectionToArrayNodeConverter;
import org.modelmapper.jackson.JsonNodeValueReader;
import org.modelmapper.jackson.PrimitiveJsonNodeConverter;
import org.modelmapper.spi.ValueReader;

public class JacksonModule
implements Module {
    private ObjectMapper objectMapper;

    public JacksonModule() {
        this(new ObjectMapper());
    }

    public JacksonModule(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setupModule(ModelMapper modelMapper) {
        modelMapper.getConfiguration().addValueReader((ValueReader)new JsonNodeValueReader());
        modelMapper.getConfiguration().getConverters().add(0, new PrimitiveJsonNodeConverter());
        modelMapper.getConfiguration().getConverters().add(0, new ArrayNodeToCollectionConverter());
        modelMapper.getConfiguration().getConverters().add(0, new CollectionToArrayNodeConverter(this.objectMapper));
    }
}

